﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<List<Area>>" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.BaseServers;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageAreas;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server"> 地区管理 </asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
        SetExpireDays="30" />
  <% Dictionary<string, Language> languages = Languages.GetLanguages(false); %>
  <p> <strong>行政区号编码规范</strong></p>
  <p> 总共有八位，每两位为一组  XX   XX   XX   XX </p>
  <p> 前两位表示省，直辖市</p>
  <p> 第二组两位数据码，其中01-20、51-70表示省直辖市，21-50表示地区（州、盟） </p>
  <p>第三组两位数字码，其中01-18、表示市辖区或地辖区，21-80表示县（旗），81-99表示省直辖县级市 </p>
  <p>第四组是预留两位数字码，可以填写乡镇级地区编码 </p>
  <div class="tn-list-header">
    <div class="tn-list-header-row"> <%=SPBHtmlHelper.Instance().LinkButton("addedit", "添加地区", Url.Action("Control_EditArea", "ManageSettings"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%> </div>
  </div>
  <%
                if (TempData["StatusMessageType"] != null)
                {
                    StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                    if (messageType == StatusMessageType.Success)
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                    else
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                    TempData["StatusMessageType"] = null;
                }
                    %>
  <table class="tn-table-grid">
    <tr class="tn-table-grid-header">
      <th class="tn-border-gray tn-border-bottom tn-text-note">地区名称</th>
      <% foreach (Language language in languages.Values)
               { %>
      <td class="tn-border-gray tn-border-bottom tn-text-note"><%=language.NativeName%></td>
      <%} %>
      <td class="tn-border-gray tn-border-bottom tn-text-note">行政区号</td>
      <td class="tn-border-gray tn-border-bottom tn-text-note">序号</td>
      <td class="tn-border-gray tn-border-bottom tn-text-note">邮编</td>
      <td class="tn-border-gray tn-border-bottom tn-text-note">操作</td>
    </tr>
    <%foreach (var item in Model)
       { %>
    <tr value="<%=item.AreaCode %>" depth="<%=item.Depth %>" class="tn-table-grid-row">
      <th class="tn-border-gray tn-border-bottom tn-width-auto"> <% if (item.ChildCount > 0)
                { %>
        <span class="tn-icon tn-icon-expand tn-icon-inline"></span> <a href="javascript:;" name="toggleButton"><%=item.Name%></a>
        <%}
                else
                {%>
        <span class="tn-icon tn-icon-empty tn-icon-inline"></span> <%=item.Name %>
        <%} %>
      </th>
      <% foreach (string languageCode in languages.Keys)
                { %>
      <th class="tn-border-gray tn-border-bottom tn-width-auto"> <% if (item.AreaNameResForAdmin != null && item.AreaNameResForAdmin.ContainsKey(languageCode)) Response.Write(item.AreaNameResForAdmin[languageCode]); else Response.Write("--"); %>
      </th>
      <%} %>
      <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=item.AreaCode%></td>
      <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=item.DisplayOrder %></td>
      <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=item.PostCode %></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><span class="tn-action"> <a class="tn-action-text" href="<%=Url.Action("Control_EditArea","ManageSettings",new{ areaCode = item.AreaCode}) %>" name="editButton">编辑</a></span> <span class="tn-action"><a class="tn-action-text" onclick="if(!confirm('你确定要删除此地区吗？')){ return false;}" href="<%=Url.Action("DeleteArea","ManageSettings",new{ areaCode = item.AreaCode}) %>">删除</a></span> <span class="tn-action"> <a class="tn-action-text" href="<%=Url.Action("Control_EditArea","ManageSettings",new{parentCode=item.AreaCode}) %>" name="editButton" >添加子地区</a></span></td>
    </tr>
    <%} %>
  </table>
  <script type="text/javascript">
      $(document).ready(function() {
          $("a[name='toggleButton']").live("click", function() {
          var areaCode = $(this).parents("tr.tn-table-grid-row:first").attr("value");
              var $tr = $("tr[value='" + areaCode + "']");
              var depth = $tr.attr("depth");
              var $toggleButton = $tr.find("a[name='toggleButton']");
              var $childAreas = $tr.nextUntil("tr[depth='" + depth + "']").filter(function() { return eval($(this).attr("depth")) > depth; });
              if (!$childAreas.length) {
                  $toggleButton.after("<span id='loading'>&nbsp;&nbsp;数据加载中...</span>");
                  $.get('<%=SPBUrlHelper.Action("Control_ListChildAreas", "ManageSettings")%>',
                { "parentCode": areaCode },
                function(data) {
                    $tr.after(data);
                    $("#loading").remove();
                });
              }
              else {
                  if ($childAreas.eq(0).is(":hidden")) {
                      $childAreas.show();
                      $toggleButton.attr("title", "展开").siblings(".tn-icon").removeClass("tn-icon-fold").addClass("tn-icon-expand");
                  }
                  else {
                      $childAreas.hide();
                      $toggleButton.attr("title", "折叠").siblings(".tn-icon").removeClass("tn-icon-expand").addClass("tn-icon-fold");
                  }
              }
              return false;
          });
          $('a[name="editButton"]').each(function() {
          var areaCode = $(this).parents("tr.tn-table-grid-row:first").attr("value");
              $(this).nyroModal({
                  resizeable: true
                  //height: 500,
                  //width: 500
              });
          });
          $('a.nyroModal,#addedit').nyroModal({
              resizeable: true,
              width: 700,
              height: 350
          });
      });
    </script>
</asp:content>
