﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageRule;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.AuditingSettings;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  审核设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="ManageAuditingSettings"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
          {
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, "修改已保存成功", 3000));
          }
          else
          {
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          }
          TempData["StatusMessageType"] = null;
      }

      ///type=0表示按角色显示，1为按级别显示
      int type = Request.QueryString.GetInt("type", 0);
      int appID = Request.QueryString.GetInt("appID", 0);
      Application application = ViewData.Get<Application>("Application", null);

      //  int type = Request.QueryString.GetInt("type", 1);
      Dictionary<int, Dictionary<string, AuditingItemSettings>> DRole = null;
      Dictionary<int, Dictionary<string, AuditingItemSettings>> DRank = null;
      if (ViewData["DRank"] != null)
          DRank = ViewData["DRank"] as Dictionary<int, Dictionary<string, AuditingItemSettings>>;
      if (ViewData["DRole"] != null)
          DRole = ViewData["DRole"] as Dictionary<int, Dictionary<string, AuditingItemSettings>>;
    %>

              <div class="tn-tabs tn-widget">

<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
              <li class="tn-widget-content tn-border-gray tn-border-trl <%if (appID == 0) Response.Write(" tn-tabs-selected");%>"><a href="<%=Url.Action("AuditingSettings", "ManageSettings", new { appID = 0 })%>"
                                target="_self"><span>全局</span></a></li>
              <%
                  Dictionary<int, Application> dic = null;
                  if (ViewData["DicApplication"] != null)
                  {
                      dic = ViewData["DicApplication"] as Dictionary<int, Application>;
                  }
                  if (dic != null)
                  {
                      string str = "<li {0}><a href=\"{1}\" target=\"_self\"><span>{2}</span></a></li>";
                      string strUrl = "";
                      foreach (var item in dic.Values)
                      {
                          string strClass = "";
                          if (item.ApplicationID == appID)
                              strClass = "class=\"tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected\"";
                          else
                              strClass = "class=\"tn-widget-content tn-border-gray tn-border-trl\"";
                          strUrl = Url.Action("AuditingSettings", "ManageSettings", new { AppID = item.ApplicationID });
                          Response.Write(string.Format(str, strClass, strUrl, item.GetMultilingualApplicationName(CurrentUserLanguage)));
                      }
                  }
                            %>
            </ul>

          <div class="tn-tabs-panel tn-widget-content tn-border-gray">
            <%
                if (type == 1)
                {
                    Response.Write("<form id=\"ManageRankForm\" method=\"post\" action=\"" + Url.Action("Control_SetRanksAuditingSettings", "ManageSettings", new { appID = appID }) + "\">");
                        %>
            <script type="text/javascript">
                $(document).ready(function() {
                    $('#ManageRankForm').submit(function(e) {
                        e.preventDefault();
                        $('#ManageRankForm').nyroModalManual({
                            resizeable: true
                        });
                        return false;
                    });
                });
                        </script>
            <%} %>
              <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                查看： <span class="tn-action <%if (type == 0) Response.Write(" tn-selected"); %>"><a
                    class="tn-action-text" href="<%=SPBUrlHelper.Action("AuditingSettings", "ManageSettings", new RouteValueDictionary { { "type", 0 } , { "appID", appID }})%>">
                    按角色设置</a></span> <span class="tn-action <%if (type == 1) Response.Write(" tn-selected"); %>">
                        <a class="tn-action-text" href="<%=SPBUrlHelper.Action("AuditingSettings", "ManageSettings", new RouteValueDictionary { { "type", 1 },{ "appID", appID }})%>">
                            按级别设置</a></span>
                               <%
                                   if (type == 1)
                                   { %>
                <%=SPBHtmlHelper.Instance().LinkButton("Button_Set", GetResourceString("Button_Set"), "javascripr:;", ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Set, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "$('#ManageRankForm').submit(); return false;" }, { "title", "批量设置选定的级别" } }, null)%>

            <%} %>
            </div>
        </div>
            
            
            <%--<div class="toolbarArea"> <span>
              <select class="dropDownList" onchange="window.location.href='?appID=<%=Request.QueryString.GetInt("appID",0) %>&type='+$(this).val();">
                <option value="1">按级别设置</option>
                <option value="0" <%if(type==0) Response.Write("selected"); %>>按角色设置</option>
              </select>
              </span> </div>--%>
         
                   <table class="tn-table-grid">
          <tr class="tn-table-grid-header">

                                <th  class="tn-border-gray tn-border-bottom tn-text-note">
                <%if (type == 1) { Response.Write("<input type=\"checkbox\" id=\"TopCheckBox\" class=\"checkbox\" onclick=\"checkAll(this,'CheckBoxGroup')\" /></th><th class=\"tn-border-gray tn-border-bottom tn-text-note\">级别"); } else { Response.Write("角色"); } %>
                </th>
                <%
                    List<AuditingItem> AudListItem = null;
                    if (ViewData["ListItem"] != null)
                    {
                        AudListItem = ViewData["ListItem"] as List<AuditingItem>;

                        if (type == 1)
                        {
                            AudListItem = (from it in AudListItem
                                           where it.EnabledInUserRank == true
                                           select new AuditingItem
                                           {
                                               ItemID = it.ItemID,
                                               ItemKey = it.ItemKey,
                                               ItemName = it.ItemName,
                                               ApplicationID = it.ApplicationID,
                                           }).ToList();

                        }
                        else
                        {
                            AudListItem = (from it in AudListItem
                                           where it.EnabledInUserRole == true
                                           select new AuditingItem
                                           {
                                               ItemID = it.ItemID,
                                               ItemKey = it.ItemKey,
                                               ItemName = it.ItemName,
                                               ApplicationID = it.ApplicationID,
                                           }).ToList();
                        }

                        foreach (var item in AudListItem)
                        {
                                %>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=item.ItemName %> </th>
                <%
                    }
                    }
                                %>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 编辑 </th>
              </tr>
              <%
                  if (ViewData["sortlistUserRank"] != null)
                  {
                      SortedList<int, UserRank> slistRank = ViewData["sortlistUserRank"] as SortedList<int, UserRank>;
                      IList<UserRank> listRank = slistRank.Values;
                      if (listRank != null && listRank.Count > 0)
                      {
                          foreach (var item in listRank)
                          {
                            
                            %>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-check">
                  <input type="checkbox" id="CheckBoxGroup" name="CheckBoxGroup" class="tn-checkbox" value="<%=item.Rank %>" />
                  </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.Rank %>级 </td>
                <%
                    if (AudListItem != null)
                    {
                        foreach (var AudItem in AudListItem)
                        {
                                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%
                                                                          string strOut = "未设置";
                                                                          try
                                                                          {
                                                                              if (DRank[item.Rank][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.Create)
                                                                                  strOut = "创建时审核";
                                                                          }
                                                                          catch { }
                                                                          try
                                                                          {
                                                                              if (DRank[item.Rank][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.Update)
                                                                                  strOut = "再审核";
                                                                          }
                                                                          catch { }
                                                                          try
                                                                          {
                                                                              if (DRank[item.Rank][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.None)
                                                                                  strOut = "不审核";
                                                                          }
                                                                          catch { }
                                                                          Response.Write(strOut);
                                    %>
                </td>
                <%
                    }
                    }
                                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=Url.Action("Control_SetRankAuditingSettings", "ManageSettings",new{Rank=item.Rank,appID=appID})%>"
                                        name="SetSettings" >编辑</a> </td>
              </tr>
              <%          }
                      }
                  } 
                            %>
              <%
                  if (ViewData["ListRoles"] != null)
                  {
                      List<Role> ListRoles = ViewData["ListRoles"] as List<Role>;
                      foreach (var item in ListRoles)
                      {
                          bool IsLocked = false;
                            %>
                       <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.FriendlyRoleName %> </td>
                <%
                    if (AudListItem != null)
                    {
                        foreach (var AudItem in AudListItem)
                        {
                                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%
                                                                          try
                                                                          {
                                                                              if (item.RoleName == UserRoleNames.Instance().SystemAdministrator() || item.RoleName == UserRoleNames.Instance().ContentAdministrator())
                                                                              { Response.Write("不审核"); }
                                                                              else
                                                                              {
                                                                                  IsLocked = DRole[item.RoleID][AudItem.ItemKey].IsLocked;

                                                                                  if (DRole[item.RoleID][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.Create)
                                                                                      Response.Write("创建时审核");
                                                                                  else if (DRole[item.RoleID][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.Update)
                                                                                      Response.Write("再审核");
                                                                                  else if (DRole[item.RoleID][AudItem.ItemKey].StrictDegree == AuditingStrictDegrees.None)
                                                                                      Response.Write("不审核");
                                                                                  else
                                                                                  {
                                                                                      if (IsLocked)
                                                                                          Response.Write("无意义");
                                                                                      else
                                                                                          Response.Write("未设置");
                                                                                  }

                                                                              }
                                                                          }
                                                                          catch
                                                                          {
                                                                              Response.Write("未设置");
                                                                          }
                                    %>
                </td>
                <%
                    }
                    }
                                %>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%
                                                                          if (item.RoleName != UserRoleNames.Instance().SystemAdministrator() && item.RoleName != UserRoleNames.Instance().ContentAdministrator() && !IsLocked)
                                                                          {
                                    %>
                  <a href="<%=Url.Action("Control_SetRoleAuditingSettings", "ManageSettings",new{ RoleID = item.RoleID, RoleName = item.FriendlyRoleName,appID=appID})%>"
                                        name="SetSettings" >编辑</a>
                  <%} %>
                </td>
              </tr>
              <%
                  }
                  }
                            %>
            </table>
            <%
                if (type == 1)
                    Response.Write("</form>");
                        %>
            <% if (application != null)
               {  %>
               
              
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>对外显示设置</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">哪些审核状态可以公开显示：</p>
 <form id="AuditingStatusForPublicDisplayForm" name="AuditingStatusForPublicDisplayForm" action="<%=SPBUrlHelper.Action("UpdateAuditingStatusForPublicDisplay","ManageSettings",new RouteValueDictionary{{"applicationID",application.ApplicationID}}) %>" method="post">

         <table>
              <tr>
                <td><input name="AuditingStatusForPublicDisplay" id="AuditingStatusesForPublicDisplay123"
                type="radio" value="<%=(int)AuditingStatusesForDisplay.Success%>" <%  if (application.AuditingStatusForPublicDisplay==AuditingStatusesForDisplay.Success) Response.Write("checked=\"checked\""); %> />
                    <label for="AuditingStatusesForPublicDisplay123">通过审核</label></td>
                <td>
                <input name="AuditingStatusForPublicDisplay" id="AuditingStatusesForPublicDisplay1"
                type="radio" value="<%=(int)AuditingStatusesForDisplay.Again_GreaterThanOrEqual%>"
                <%  if (application.AuditingStatusForPublicDisplay==AuditingStatusesForDisplay.Again_GreaterThanOrEqual) Response.Write("checked=\"checked\""); %> />
                    <label  for="AuditingStatusesForPublicDisplay1">需再次审核、通过审核</label>
                </td>
                <td> <input name="AuditingStatusForPublicDisplay" id="AuditingStatusesForPublicDisplay12"
                type="radio" value="<%=(int)AuditingStatusesForDisplay.Pending_GreaterThanOrEqual%>"
                <%  if (application.AuditingStatusForPublicDisplay==AuditingStatusesForDisplay.Pending_GreaterThanOrEqual) Response.Write("checked=\"checked\""); %> />
                    <label  for="AuditingStatusesForPublicDisplay12">待审核、需再次审核、通过审核</label></td>
              </tr>
       
              <tr>
                <td colspan="3"><input type="submit"  value="<%=GetResourceString("Button_Save")%>" /></td>
              </tr>
            </table>
            </form>
          </div>

            <%} %>
          </div>
        </div>
   
  <script type="text/javascript">
      $(document).ready(function() {
          $('a[name="SetSettings"]').nyroModal({
              resizeable: true
          });
      });
    </script>
</asp:content>
