﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string, Language>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <% 
      ViewData["SystemSettingMenu"] = SystemSettingMenu.BaseServers;
      ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageLanguage;
      Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
        </asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  语言管理
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      
    %>
       <div class="tn-tabs tn-widget">
        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
      <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
         <%=SPBHtmlHelper.Instance().LinkButton("addedit", "添加新语言", Url.Action("Control_NewLanguage", "ManageSettings"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
         </div>
         </div>   

              <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 区域/语言编码</th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 本地化名称 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%> </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                </tr>
                <%
                    foreach (Language language in Model.Values)
                    {%>
                   <tr class="tn-table-grid-row">
                      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=language.LanguageCode%> </td>
                      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=language.NativeName%> </td>
                      <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <%if (language.IsEnabled == true)
                                   { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept,"此语言已启用"));}
                                  else
                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross,"此语言已禁用"));}%>
                          
                      </td>
                      <td class="tn-border-gray tn-border-bottom"><a href="<%=Url.Action("Control_EditLanguage", "ManageSettings", new { languageCode=language.LanguageCode})%>"
                                             name="addedit">编辑</a> <a href="<%=Url.Action("DeleteLanguage", "ManageSettings", new { languageCode=language.LanguageCode})%>"
                                                onclick="if(!confirm('确定要删除该语言吗？')) {return false;}">删除</a> 
                                                
                                                </td>
                   </tr>
                 <%} %>
              </table>
             
          
          </div>
        </div>
  
  <script type="text/javascript">
      $(document).ready(function() {
          $('a[name="addedit"],#addedit').nyroModal({
              resizeable: true
          });


      });
    </script>
</asp:content>
