﻿<%@ Page Title="" Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<IList<Navigation>>" %>
<asp:content id="Content1" runat="server" contentplaceholderid="HeaderContent">
  <% 
          ViewData["SystemSettingMenu"] = SystemSettingMenu.AboutInterFace;
          ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageNavigations;
          Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server"> 导航管理 </asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
        SetExpireDays="30" />
  <% Dictionary<string, Language> languages = Languages.GetLanguages(false); %>
  <spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
        SetExpireDays="30" />
  <spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js"
        SetExpireDays="30" />
  <spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js"
        SetExpireDays="30" />
  <style type="text/css">
        html > body #sortable tr
        {
            height: 1.5em;
            line-height: 1.2em;
        }
        .ui-state-highlight
        {
            height: 1.5em;
            line-height: 1.2em;
        }
    </style>
  <%
        int presentAreaID = Html.GetParameterFromRouteDateOrQueryString("presentAreaID", PresentAreaIDs.Instance().Channel());
        int applicationID = ApplicationIDs.Instance().User();
        Dictionary<int, Application> applications = Applications.GetApplications();
    %>
  <div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-clearfix spb-nav-manage">
      <li class="tn-widget-content tn-border-gray tn-border-trl <%if (presentAreaID == PresentAreaIDs.Instance().Channel()) { Response.Write(" tn-tabs-selected"); } %>"> <a href="<%=this.Url.Action("ManageNavigations", "ManageSettings", new { presentAreaID = PresentAreaIDs.Instance().Channel()})%>"> <span>总站导航</span></a></li>
      <li class="tn-widget-content tn-border-gray tn-border-trl <%if (presentAreaID == PresentAreaIDs.Instance().UserDomain()) { Response.Write(" tn-tabs-selected"); } %>"> <a href="<%=this.Url.Action("ManageNavigations", "ManageSettings", new { presentAreaID = PresentAreaIDs.Instance().UserDomain()})%>"> <span>个人空间导航</span></a></li>
      <li class="tn-widget-content tn-border-gray tn-border-trl <%if (presentAreaID == PresentAreaIDs.Instance().CompanyUserDomain()) { Response.Write(" tn-tabs-selected"); } %>"> <a href="<%=this.Url.Action("ManageNavigations", "ManageSettings", new { presentAreaID = PresentAreaIDs.Instance().CompanyUserDomain()})%>"> <span>企业空间导航</span></a></li>
      <li class="tn-widget-content tn-border-gray tn-border-trl <%if (presentAreaID == PresentAreaIDs.Instance().ClubDomain()) { Response.Write(" tn-tabs-selected"); } %>"> <a href="<%=this.Url.Action("ManageNavigations", "ManageSettings", new { presentAreaID = PresentAreaIDs.Instance().ClubDomain()})%>"> <span>群组导航</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray">
      <div class="tn-widget">
        <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
          <div class="tn-helper-flowfix">
            <ul>
              <li><%=GetResourceString("Description_ManageUserNavigation1",applicationID) %></li>
              <li><%=GetResourceString("Description_ManageUserNavigation2",applicationID) %></li>
              <li><%=GetResourceString("Description_ManageUserNavigation3",applicationID) %></li>
            </ul>
          </div>
        </div>
      </div>
      <div class="spb-drag-adjust">
        <%if (TempData["StatusMessageType"] != null)
          {
              StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
              if (messageType == StatusMessageType.Success)
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Success, GetResourceString("Message_SetUserNavigationSucceed", applicationID), 3000));
              }
              else
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Error, GetResourceString("Message_SetUserNavigationFailed", applicationID)));
              }
              TempData["StatusMessageType"] = null;
          } %>
        <form id="menuForm" name="menuForm" method="post" action="<%=Url.Action("UpdateNavigations", "ManageSettings",new {presentAreaID=presentAreaID})%>">
          <div class="tn-form">
            <%
                User currentDomainUser = Users.GetUser(Html.GetParameterFromRouteDateOrQueryString("UserDomainName"), false);
                
                    %>
            <table id="sortable">
              <tr>
                <td><table>
                    <tr>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">导航ID</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">导航名称</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note">链接</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">新窗口打开</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">类型</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">应用</td>
                      <%if (presentAreaID == PresentAreaIDs.Instance().Channel())
                      {%>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">辅助ID</td>
                      <%} %>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">启用</td>
                      <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width">操作</td>
                    </tr>
                  </table></td>
              </tr>
              <% 
                  int i = 0;
                  foreach (Navigation navigation in Model)
                  {                                
                        %>
              <tr name="sortableTr" value="<%=i %>">
                <td><div class="spb-drag-row tn-bg-gray tn-border-gray">
                    <table>
                      <tr>
                        <td class="spb-drag-td-width"><%=navigation.DefaultNavigationID %></td>
                        <td class="spb-drag-td-width"><input type="text" maxlength="12" id="navigationText_<%=i %>" name="navigationText_<%=i %>" class="tn-textbox tn-input-short tn-border-gray" value="<%=navigation.GetMultilingualNavigationName(CurrentUserLanguage).Replace("\"","&quot;") %>" /></td>
                        <td class="tn-width-auto"><%if (string.IsNullOrEmpty(navigation.UrlRouteName))
                                                  {  %>
                          <input type="text" id="navigationLink_<%=i %>" name="navigationLink_<%=i %>" class="tn-textbox tn-input-short tn-border-gray" title="" value="<%=navigation.GetNavigationUrl() %>"/>
                          <%}
                                                  else
                                                  { %>
                          <%=navigation.GetNavigationUrl() %>
                          <%} %></td>
                        <td class="spb-drag-td-width"><input type="checkbox" class="tn-checkbox" name="navigationTarget_<%=i %>" <%if(navigation.NavigationTarget == "_blank"){Response.Write("checked=\"checked\"");} %> value="true" id="navigationTarget_<%=i %>"/></td>
                        <td class="spb-drag-td-width"><%=navigation.NavigationType == NavigationTypes.HyperLink ? GetResourceString("Label_NavigationExternalLink", applicationID) : GetResourceString("Label_NavigationApplication", applicationID)%></td>
                        <td class="spb-drag-td-width"><%if (navigation.NavigationType != NavigationTypes.HyperLink) { if (applications.ContainsKey(navigation.ApplicationID)) { Response.Write(applications[navigation.ApplicationID].ApplicationName); } } %></td>
                        <%if (presentAreaID == PresentAreaIDs.Instance().Channel())
                        {%>
                        <td class="spb-drag-td-width"><input type="text" maxlength="12" id="secondaryID_<%=i %>" name="secondaryID_<%=i %>" class="tn-textbox tn-input-short tn-border-gray" value="<%=navigation.SecondaryID %>" /></td>
                        <%} %>
                        <td class="spb-drag-td-width"><input type="checkbox" class="tn-checkbox" <%if (navigation.IsLocked) { Response.Write("disabled=\"disabled\""); } %> name="isEnabled_<%=i %>" <%if(navigation.IsEnabled){Response.Write("checked=\"checked\"");} %> value="true" id="isEnabled_<%=i %>"/>
                          <input type="hidden" id="DefaultNavID_<%=i %>" name="DefaultNavID_<%=i %>" value="<%=navigation.DefaultNavigationID %>" />
                          <input type="hidden" id="displayOrder_<%=i %>" name="displayOrder_<%=i %>" value="<%=i %>" /></td>
                        <td class="spb-drag-td-width"><% if (!navigation.IsLocked && !navigation.CanAssignOwner || navigation.NavigationType != NavigationTypes.Application)
                                                       { %>
                          <%=SPBHtmlHelper.Instance().LinkButton("deleteLink_" + i, GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "deleteLinkForjs" },{"value",navigation.DefaultNavigationID} }, null)%>
                          <%} %></td>
                      </tr>
                    </table>
                  </div></td>
              </tr>
              <%
                                                       i++;
                  }%>
            </table>
            <div class="tn-form-row-button">
              <%if (presentAreaID != PresentAreaIDs.Instance().Manage())
              {%>
              <%=SPBHtmlHelper.Instance().LinkButton("addUserNavigation",GetResourceString("Action_AddUserNavigation",applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
              <%} %>
              <%=SPBHtmlHelper.Instance().SubmitButton("updateButton", GetResourceString("Button_Update"), ButtonSizes.Default, null, null)%> </div>
            <input type="hidden" id="totalOptionCount" name="totalOptionCount" />
          </div>
        </form>
      </div>
    </div>
  </div>
  <script type="text/javascript">      
      $(document).ready(function() {
          $("#sortable").sortable({
              placeholder: 'spb-drag-block',
              items: 'tr[name="sortableTr"]',
              stop: function() {
              $("tr[name='sortableTr']").each(function(i) {
                $(this).find("input[id^='displayOrder'][type='hidden']").attr("value",eval(i+1));
            });
              }
          });
          $("#menuForm").validate();
          $("#updateButton").click(function(){
                if ($("#menuForm").valid()) {
                $("#totalOptionCount").attr("value",$("tr[name='sortableTr']").length);
                $("#updateButton").hide();
                $("#updateButton_ForHide").show();

            }
          });
          $("select[name^='navigationTypes_']").live('change',function(){
          var index= $(this).parents("tr[name=\"sortableTr\"]").attr("value");
          if($(this).val()=='1')
          $("select[name='applications_"+index+"']").hide();
          else
          $("select[name='applications_"+index+"']").show();
          });

        $("#addUserNavigation").click(function() {
        var value = eval($("tr[name='sortableTr']").length);
            $("<tr name=\"sortableTr\" value=\""+ value +"\">"
                +"<td><div class=\"spb-drag-row tn-bg-gray tn-border-gray\">"
                  +"<table>"
                    +"<tr>"
                      + "<td class=\"spb-drag-td-width\"><input type=\"text\" id=\"DefaultNavID_" + value + "\" name=\"DefaultNavID_" + value + "\" class=\"tn-textbox tn-input-short tn-border-gray {required:true,digits:true,maxBlength:6}\"></td>"
                      + "<td class=\"spb-drag-td-width\"><input type=\"text\" maxlength=\"12\" id=\"navigationText_" + value + "\" name=\"navigationText_" + value + "\" class=\"tn-textbox tn-input-short tn-border-gray {required:true,maxBlength:6}\"></td>"
                      + "<td class=\"tn-width-auto\"><input type=\"text\" id=\"navigationLink_" + value + "\" name=\"navigationLink_" + value + "\" class=\"tn-textbox tn-input-short tn-border-gray {url:true}\">"
                      + "<td class=\"spb-drag-td-width\"><input type=\"checkbox\" value=\"true\" class=\"tn-checkbox\" name=\"navigationTarget_" + value + "\" id=\"navigationTarget_" + value + "\"/></td>"
                      + "<td class=\"spb-drag-td-width\"><select name=\"navigationTypes_" + value + "\" class=\"tn-dropdownlist\"><option value=\"<%=(int)NavigationTypes.HyperLink%>\"><%=GetResourceString("Label_NavigationExternalLink", applicationID)%></option><option value=\"<%=(int)NavigationTypes.Application%>\"><%=GetResourceString("Label_NavigationApplication", applicationID)%></option></select></td>"
                      + "<td class=\"spb-drag-td-width\"><select style=\"display:none\" name=\"applications_" + value + "\" class=\"tn-dropdownlist\"><%foreach (var app in applications){%><option value=\"<%=app.Value.ApplicationID%>\"><%=app.Value.ApplicationName%></option><% } %></select></td>"
                      + "<%if (presentAreaID == PresentAreaIDs.Instance().Channel()){%><td class=\"spb-drag-td-width\"><input type=\"text\" id=\"secondaryID_" + value + "\" name=\"secondaryID_" + value + "\" class=\"tn-textbox tn-input-short tn-border-gray\"> </td><%} %>"
                      + "<td class=\"spb-drag-td-width\"><input type=\"checkbox\" class=\"tn-checkbox\" value=\"true\" name=\"isEnabled_" + value + "\" id=\"isEnabled_" + value + "\" checked=\"checked\"/><input type=\"hidden\" id=\"displayOrder_" + value + "\" name=\"displayOrder_" + value + "\" value=\"" + value + "\" /></td>"
                      + "<td class=\"spb-drag-td-width\"><span class=\"tn-button tn-button-default\"><span class=\"tn-first-child\"><a id=\"deleteLink_" + value + "\" href=\"javascript:;\" class=\"deleteLinkForjs tn-button-text\" value=\"0\"><%=GetResourceString("Action_Delete") %></a></span></span></td>"
                      + "</tr>"
                      +"</table>"
                  +"</div></td>"
                +"</tr>").insertAfter("tr[name='sortableTr']:last");
        });
        $("a[id^='deleteLink_']").live('click',function(){
        var ownerNavID = eval($(this).attr("value"));
      if(ownerNavID > 0)
      $.get('<%=SPBUrlHelper.Action("DeleteNavigation","ManageSettings",new RouteValueDictionary{{"presentAreaID",presentAreaID}}) %>',{"navigationID": ownerNavID});
                    $(this).parents("tr[name=\"sortableTr\"]").nextAll("tr[name=\"sortableTr\"]")
                    .each(function(){
                    var oldValue = $(this).attr("value");
                    var value=eval(oldValue-1);
                    $(this).attr("value",value);
                    $(this).find("#navigationText_"+oldValue).attr("name","navigationText_"+value).attr("id","navigationText_"+value);
                    $(this).find("#deleteLink_"+oldValue).attr("name","deleteLink_"+value).attr("id","deleteLink_"+value);
                    $(this).find("#displayOrder_"+oldValue).attr("name","displayOrder_"+value).attr("id","displayOrder_"+value).attr("value",value);
                    $(this).find("#navigationLink_"+oldValue).attr("name","navigationLink_"+value).attr("id","navigationLink_"+value);
                    $(this).find("#navigationTarget_"+oldValue).attr("name","navigationTarget_"+value).attr("id","navigationTarget_"+value);
                    $(this).find("#isEnabled_"+oldValue).attr("name","isEnabled_"+value).attr("id","isEnabled_"+value);
                    $(this).find("#secondaryID_"+oldValue).attr("name","secondaryID_"+value).attr("id","secondaryID_"+value);
                    $(this).find("#DefaultNavID_"+oldValue).attr("name","DefaultNavID_"+value).attr("id","DefaultNavID_"+value);
                    }).end().remove();
        });  
                    
    });
</script>
</asp:content>
