﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <% 
        ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageRule;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.PointSettings;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
积分设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="ManagePointSettings"
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <%
      int appID = Request.QueryString.GetInt("AppID", ApplicationIDs.Instance().User());
      Dictionary<int, Application> apps = ViewData["DicApplication"] as Dictionary<int, Application>;
    %>

     <div class="tn-tabs tn-widget">
       <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
       <%if (apps != null)
         {
             foreach (KeyValuePair<int, Application> app in apps)
             {
                 %>
          <li class="tn-widget-content tn-border-gray tn-border-trl <% if(app.Value.ApplicationID == appID) Response.Write(" tn-tabs-selected"); %>">
              <a href="<%=SPBUrlHelper.Action("PointSettings", "ManageSettings", new RouteValueDictionary  {{ "AppID",app.Value.ApplicationID}})%>" target="_self" style="cursor: pointer">
                  <span><%=app.Value.GetMultilingualApplicationName(CurrentUserLanguage) %></span>
              </a>
          </li>
          <%}
         }%>
       </ul>
       <div class="tn-tabs-panel tn-widget-content tn-border-gray">
         <table class="tn-table-grid">
              <tbody>
              <tr class="tn-table-grid-header">
                <td class="tn-border-gray tn-border-bottom tn-text-note">操作</td>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Enum_UserPointCategory_BasicPoint") %> </th>
                <td class="tn-border-gray tn-border-bottom tn-text-note">声望</td>
               <%-- 隐藏<td class="tn-border-gray tn-border-bottom tn-text-note"> 信誉积分 </td>--%>
                <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Enum_UserPointCategory_TradePoint")%></td>
                 <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Enum_UserPointCategory_BasicPoint") %>日最大限额</th>
                <td class="tn-border-gray tn-border-bottom tn-text-note">声望日最大限额</td>
                <%--<td class="tn-border-gray tn-border-bottom tn-text-note"> 信誉积分日最大限额</td>--%>
                <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Enum_UserPointCategory_TradePoint")%>日最大限额</td>
                <td class="tn-border-gray tn-border-bottom tn-text-note"> 编辑 </td>
              </tr>
              <%if (ViewData["ItemPoints"] != null && ViewData["DPoints"] != null)
                {
                    List<UserPointItem> ItemPoints = ViewData["ItemPoints"] as List<UserPointItem>;
                    Dictionary<string, UserPointItemRole> RolePoints = ViewData["DPoints"] as Dictionary<string, UserPointItemRole>;

                    foreach (var item in ItemPoints)
                    {%>
              <tr class="tn-table-grid-row">
                <th class="tn-border-gray tn-border-bottom tn-width-auto"><%=item.ItemName %></th>
                <td class="tn-border-gray tn-border-bottom tn-width-tags"><%=RolePoints[item.ItemKey].BasicPoints%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-location tn-nowrap"><%=RolePoints[item.ItemKey].ReportPoints%> </td>
<%--                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%=RolePoints[item.ItemKey].CreditPoints%></td>
--%>                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=RolePoints[item.ItemKey].TradePoints%></td>
                 <td class="tn-border-gray tn-border-bottom tn-width-tags"><%=RolePoints[item.ItemKey].BasicPointQuota%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-location tn-nowrap"><%=RolePoints[item.ItemKey].ReportPointQuota%> </td>
<%--                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%=RolePoints[item.ItemKey].CreditPointQuota%></td>
--%>                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=RolePoints[item.ItemKey].TradePointQuota%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                    <span class="tn-action">
                        <a href="<%=SPBUrlHelper.Action("Control_EditPoints","ManageSettings",new RouteValueDictionary{{"ItemKey",item.ItemKey}}) %>" name="EditPoint">编辑
                        </a> 
                    </span>
                </td>
              </tr>
              <%}
                } %>
            </tbody>
        </table>
          <%if (appID == ApplicationIDs.Instance().Event())
            { %>
          <div> <br />
            此外会在活动结束时计算：<br />
            活动发起人获取“发起活动”积分，积分规则为：声誉积分=活动积分*0.5 , <%=GetResourceString("Enum_UserPointCategory_TradePoint")%>=活动积分*1 </div>
          <%} %>
        </div>
      </div>
<script type="text/javascript">
    $(document).ready(function() {
        $('a[name="EditPoint"]').nyroModal({
                width: 300
        });
    });
</script>
</asp:content>
