﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<IList<PresentArea>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.AboutInterFace;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManagePresentAreas;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
表现区域设置
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
    <div class="tn-tabs tn-widget">
<div class="tn-tabs-panel tn-widget-content ">

  <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    表现区域ID
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    名称
                </td>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    描述信息
                </th>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    启用皮肤
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                    默认皮肤
                </td>
                 <td class="tn-border-gray tn-border-bottom tn-text-note">
                    默认外观
                </td>
                 <td class="tn-border-gray tn-border-bottom tn-text-note">
                    皮肤文件位置
                </td>
                 <td class="tn-border-gray tn-border-bottom tn-text-note">
                   Widget文件位置
                </td>
                <td class="tn-border-gray tn-border-bottom tn-text-note">
                   操作
                </td>               
            </tr>  
            <%foreach (PresentArea presentArea in ViewData.Model)
              { %>          
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                  <%=presentArea.PresentAreaID %>
                </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap">
                   <%=presentArea.Name %>  
                 </td>
                 <th class="tn-border-gray tn-border-bottom tn-width-auto">
                    <%=presentArea.DefaultAppearance %>
                 </th>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap">                      
                       <%if (presentArea.EnableThemes)
                         { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept));}
                                  else
                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross));}%>
                 </td>
                 <td class="tn-border-gray tn-border-bottom tn-nowrap">
                     <%=presentArea.DefaultTheme %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=presentArea.DefaultAppearance %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%=presentArea.ThemeLocation %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap">
                     <%=presentArea.WidgetLocation %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                      <a  href="<%=SPBUrlHelper.Action("Control_EditPresentArea","ManageSettings",new RouteValueDictionary{{"PresentAreaID", presentArea.PresentAreaID}}) %>" name="EditPresentAreas">编辑 </a>                        
                </td>
            </tr>
            <%}  %>
        </table>
   
   </div>
   </div>
 <script type="text/javascript">
     $(document).ready(function() {
         $('a[name="EditPresentAreas"]').nyroModal({
             resizeable: true
         });
     });
 </script>
                
</asp:content>
