﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<School>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.BaseServers;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageSchools;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  学校管理
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      string areaCode = Request.QueryString.GetString("areaCode", "11000000");
      SchoolTypes schoolType = (SchoolTypes)Request.QueryString.GetInt("schoolType", (int)SchoolTypes.University);
    %>
   <div class="tn-form-box tn-border-gray tn-border-bottom">
        <form action="<%=SPBUrlHelper.Action("ManageSchools","ManageSettings") %>" id="SearchSchoolTypeForm" method="get">  
                <table>
                    <tr>
                        <th>
                            地区：
                        </th>
                        <td>
                          <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", string.Empty, areaCode, 3, "tn-dropdownlist"));%>
                        </td>
                        <th>
                           学校类型：
                        </th>
                        <td>
                             <select name="schoolType" id="schoolType" class="tn-dropdownlist">
                                    <option <% if (schoolType ==SchoolTypes.University) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.University)%>">大学</option>
                                    <option <% if (schoolType ==SchoolTypes.SeniorHighSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.SeniorHighSchool)%>">高中</option>
                                    <option <% if (schoolType ==SchoolTypes.JuniorHighSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.JuniorHighSchool)%>">初中</option>
                                    <option <% if (schoolType ==SchoolTypes.GradeSchool) Response.Write("selected=\"selected\""); %>
                                    value="<% =(int)(SchoolTypes.GradeSchool)%>">小学</option>
                          </select>
                        </td>
                      
                        <td>
                        <input type="submit" class="tn-botton" id="searchButton" value="<%=GetResourceString("Button_Search") %>" />
                       
                        </td>
                    </tr>
                </table>
  </form>
        </div>
          <div class="tn-tabs tn-widget">

        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
         <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
         <%=SPBHtmlHelper.Instance().LinkButton("addedit","添加新学校", Url.Action("Control_NewSchool", "ManageSettings", new { areaCode = areaCode, schoolType = (int)schoolType }),ButtonSizes.Default,HighlightStyles.Default,IconTypes.Add,TextIconLayout.IconText)%>
         </div>
         </div>
              <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> SchoolID </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 学校名称 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 学校类型 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 所在地区区号 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 所在地区名称 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 排序序号 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                </tr>
                <%string schoolT = string.Empty;
                  foreach (School item in Model.Records)
                  { %>
 <tr class="tn-table-grid-row">
                   <%if (item.SchoolType == SchoolTypes.University)
                         schoolT = "大学";
                     else if (item.SchoolType == SchoolTypes.SeniorHighSchool)
                         schoolT = "高中";
                     else if (item.SchoolType == SchoolTypes.JuniorHighSchool)
                         schoolT = "初中";
                     else
                         schoolT = "小学"; %>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.SchoolID %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.SchoolName %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=schoolT.ToString()  %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.AreaCode %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatArea(item.AreaCode,true) %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=item.DisplayOrder %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-nowrap">
                  <a href="<%=Url.Action("Control_EditSchool", "ManageSettings", new { schoolID=item.SchoolID })%>"
                           name="addedit">编辑</a> <a href="<%=Url.Action("DeleteSchool", "ManageSettings", new { returnURl = Request.RawUrl,schoolID=item.SchoolID })%>"
                                                onclick="if(!confirm('确定要删除该学校吗？')) {return false;}">删除</a> </td>
                </tr>
                <%
                    }%>
              </table>
              <div class="tn-pagination tn-helper-align-center">
                  <% Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)); %>
                </div>
             
          </div>
        </div>
     
  <script type="text/javascript">
      $(document).ready(function() {
          $('a[name="addedit"],#addedit').nyroModal({
              resizeable: true
          });
          $("#SearchSchoolTypeForm").validate({
              rules: {
                  areaCode: { required: true }
              },
              messages: {
                  areaCode: { required: "请选择学校地区" }
              }
          });

          $("#searchButton").click(function() {

              if (!$("#SearchSchoolTypeForm").valid()) {
                  return false;
              }
          });

      });
    </script>
    
</asp:content>
