﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<UserPointRecord>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
  <%    ViewData["SystemSettingMenu"] = SystemSettingMenu.BaseServers;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.SystemPoint;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">

     <div class="tn-tabs tn-widget">
       <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
       </ul>
       <div class="tn-tabs-panel tn-widget-content tn-border-gray">
       <p style="margin: 5px 0px;"><strong>系统积分：<%=ViewData.Get<int>("SystemPoint", 0)%></strong></p>
         <table class="tn-table-grid">
              <tbody>
              <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">日期</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 积分项 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">积分</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">积分类型</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 积分描述 </th>
              </tr>
              <%if (Model != null)
                {
                    foreach (UserPointRecord record in Model.Records)
                    {%>
              <tr class="tn-table-grid-row">
                <th class="tn-border-gray tn-border-bottom tn-width-date "><%=Formatter.FormatFriendlyDate(record.CreateDate)%></th>
                <td class="tn-border-gray tn-border-bottom tn-width-tags"><%=record.PointItemName%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-location tn-nowrap"><%=record.Points%> </td>
                <td class="tn-nowrap tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%=record.PointCategoryName(Globals.GetCurrentUserLanguage())%></td>
                <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=record.Description%></td>
              </tr>
              <%}
                } %>
            </tbody>
        </table>
        <div class="tn-pagination tn-helper-align-center">
        <%if (Model != null && Model.TotalRecords > Model.PageSize)
          {
              Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex));
          } %>
          </div>
        </div>
      </div>
   
<script type="text/javascript">
    $(document).ready(function() {
        $('a[name="EditPoint"]').nyroModal({
            resizeable: true
        });
    });
</script>
</asp:content>
