﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<IList<Theme>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
     <% 
         ViewData["SystemSettingMenu"] = SystemSettingMenu.AboutInterFace;
         ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageThemes;
         Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
 皮肤管理
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
<% int presentAreaID = ViewData.GetInt("presentAreaID", PresentAreaIDs.Instance().Channel());
   Dictionary<string, Theme> themesDictionary = ViewData.Get<Dictionary<string, Theme>>("themesDictionary", new Dictionary<string, Theme>());
   Dictionary<string, Dictionary<string, ThemeAppearance>> themeAppearancesDictionary = ViewData.Get<Dictionary<string, Dictionary<string, ThemeAppearance>>>("themeAppearancesDictionary", null);
   if (themesDictionary == null)
       themeAppearancesDictionary = new Dictionary<string, Dictionary<string, ThemeAppearance>>();
   string defaultTheme = ViewData.GetString("defaultTheme", string.Empty);
   string defaultThemeAppearence = ViewData.GetString("defaultThemeAppearence", string.Empty);
   IList<PresentArea> presentAreas = PresentAreas.GetPresentAreasForAdmin();
   %>

 <div class="tn-tabs tn-widget">

           <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
<% foreach (PresentArea presentArea in presentAreas)
   {
    %>
                    <li class="tn-widget-content tn-border-gray tn-border-trl  <% if (presentAreaID ==presentArea.PresentAreaID ) { Response.Write(" tn-tabs-selected"); } %>">
                        <a href="<%=Url.Action("ManageThemes","ManageSettings",new RouteValueDictionary{{"presentAreaID",presentArea.PresentAreaID}}) %>"><span><%=presentArea.Name %></span></a></li>
                        
    <%} %>
                </ul>
     <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                    <%
                        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                        if (statusMessageData != null)
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                            statusMessageData = null;
                        }
                    %>                   
   
        <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">主题/外观 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 存放路径 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 允许角色 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 允许用户级别</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 适用版本</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 作者</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_DateCreated")%></th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_IsEnabled")%></th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
           </tr>
              <%  foreach (Theme theme in ViewData.Model)
                  { %>
                   <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=theme.DirectoryName %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (theme.IsEnabled)
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                            else
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <%
                        if (theme.DirectoryName.ToLower() != defaultTheme.ToLower())
                        {
                            if (themesDictionary.ContainsKey(theme.DirectoryName.ToLower()))
                            { %>
                    <a href="<%=Url.Action("SetThemeEnabled","ManageSettings",new{presentAreaID=presentAreaID,theme=theme.DirectoryName, isEnabled=!theme.IsEnabled }) %>"
                                        ><%=theme.IsEnabled?"禁用":"启用" %></a> 
                    <% }%>
                    <a href="<%=Url.Action("DeleteTheme","ManageSettings",new{presentAreaID=presentAreaID, theme=theme.DirectoryName}) %>"
                                        >删除</a> 
                     <%} %>
                    </td>
                  </tr>
                  <%  
                      foreach (ThemeAppearance themeAppearance in theme.ThemeAppearances)
                      {
                       %>
                   <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">&nbsp;&nbsp;&nbsp;&nbsp;<%=themeAppearance.Title%></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=themeAppearance.DirectoryName%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Roles %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">=<%=themeAppearance.RequiredRank %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.ThemeVersion %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Author %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.DateCreated%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%
                                                                              if (theme.IsEnabled)
                                                                              {
                                                                                  if (themeAppearance.IsEnabled)
                                                                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                                  else
                                                                                  { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }
                                                                              }%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <% 
                        if (theme.DirectoryName.ToLower() != defaultTheme.ToLower() || themeAppearance.DirectoryName.ToLower() != defaultThemeAppearence.ToLower())
                        {
                            if (theme.IsEnabled)
                            { %>
                    <a href="<%=Url.Action("SetThemeAppearanceEnabled","ManageSettings",new{presentAreaID=presentAreaID,theme=theme.DirectoryName,appearanceDirectoryName=themeAppearance.DirectoryName, isEnabled=!themeAppearance.IsEnabled }) %>"
                                        ><%=themeAppearance.IsEnabled ? "禁用" : "启用"%></a>                     
                                        <%}
                      
                         %>
                    <a href="<%=Url.Action("DeleteThemeAppearance","ManageSettings",new{presentAreaID=presentAreaID, theme=theme.DirectoryName,appearanceDirectoryName=themeAppearance.DirectoryName }) %>"
                                        >删除</a> 
                        <%} %>
                    </td>
                  </tr>
             <%
                 if (themeAppearancesDictionary.ContainsKey(theme.DirectoryName.ToLower())
                 && themeAppearancesDictionary[theme.DirectoryName.ToLower()].ContainsKey(themeAppearance.DirectoryName.ToLower()))
                     themeAppearancesDictionary[theme.DirectoryName.ToLower()].Remove(themeAppearance.DirectoryName.ToLower());
                      } %>
                  <% if (themeAppearancesDictionary.ContainsKey(theme.DirectoryName.ToLower()))
                     {
                         foreach (ThemeAppearance themeAppearance in themeAppearancesDictionary[theme.DirectoryName.ToLower()].Values)
                         {
                       %>
                   <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=themeAppearance.Title%></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=themeAppearance.DirectoryName%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Roles %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">=<%=themeAppearance.RequiredRank %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.ThemeVersion %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Author %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.DateCreated%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (themeAppearance.IsEnabled)
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                            else
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <a href="<%=Url.Action("ImportThemeAppearance","ManageSettings",new{presentAreaID=presentAreaID, theme=theme.DirectoryName,appearanceDirectoryName=themeAppearance.DirectoryName }) %>"
                                        >入库</a> 
                    </td>
                  </tr>
             <%}
                     } %>            
                      <%if (themesDictionary.ContainsKey(theme.DirectoryName.ToLower()))
                            themesDictionary.Remove(theme.DirectoryName.ToLower());
                  }
                  foreach (Theme theme in themesDictionary.Values)
                  {
                      if (themeAppearancesDictionary.ContainsKey(theme.DirectoryName.ToLower()) && themeAppearancesDictionary[theme.DirectoryName.ToLower()].Count <= 0)
                          continue;
                  %>
                   <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=theme.DirectoryName %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (theme.IsEnabled)
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                            else
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    <a href="<%=Url.Action("ImportTheme","ManageSettings",new{presentAreaID=presentAreaID, theme=theme.DirectoryName}) %>"
                                        >入库</a> 
                    </td>
                  </tr>
                  <% if (themeAppearancesDictionary.ContainsKey(theme.DirectoryName.ToLower()))
                     {
                         foreach (ThemeAppearance themeAppearance in themeAppearancesDictionary[theme.DirectoryName.ToLower()].Values)
                         {
                       %>
                   <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=themeAppearance.Title%></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"> <%=themeAppearance.DirectoryName%> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Roles %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">=<%=themeAppearance.RequiredRank %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.ThemeVersion %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.Author %></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=themeAppearance.DateCreated %> </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (themeAppearance.IsEnabled)
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                            else
                                                                            { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                    </td>
                  </tr>
             <%}
                     }
                  } %>
             </table>
                </div>
            </div>
         
</asp:content>
