﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<IList<Widget>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.AboutInterFace;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.ManageWidgets;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
 Widgets管理
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
<%  int presentAreaID = PresentAreaIDs.Instance().Channel();
    if (ViewData["presentAreaID"] != null)
        presentAreaID = ViewData.GetInt("presentAreaID", 10);
    Dictionary<string, Widget> widgetsDictionary = ViewData.Get<Dictionary<string, Widget>>("widgetsDictionary", new Dictionary<string, Widget>());%>
<% %>
<div class="tn-tabs tn-widget">
<ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (presentAreaID ==  PresentAreaIDs.Instance().Channel()) { Response.Write(" tn-tabs-selected"); } %>">
                        <a href="<%=Url.Action("ManageWidgets","ManageSettings",new RouteValueDictionary{{"presentAreaID",PresentAreaIDs.Instance().Channel()}}) %>"><span>总站</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (presentAreaID == PresentAreaIDs.Instance().UserDomain()) { Response.Write(" tn-tabs-selected"); } %>">
                        <a href="<%=Url.Action("ManageWidgets","ManageSettings",new RouteValueDictionary{{"presentAreaID",PresentAreaIDs.Instance().UserDomain()}}) %>"><span>用户</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <% if (presentAreaID == PresentAreaIDs.Instance().ClubDomain()) { Response.Write(" tn-tabs-selected"); } %>">
                        <a href="<%=Url.Action("ManageWidgets","ManageSettings",new RouteValueDictionary{{"presentAreaID",PresentAreaIDs.Instance().ClubDomain()}}) %>"><span>群组</span></a></li>
                </ul>
                <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                    <%
                        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                        if (statusMessageData != null)
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                            statusMessageData = null;
                        }
                    %>
                    <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
         <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "全部更新", Url.Action("UpdateWidgets", "ManageSettings", new RouteValueDictionary { { "presentAreaID", presentAreaID } }), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Update, TextIconLayout.IconText, null, null)%>
         <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, "全部入库", Url.Action("CreateWidgets", "ManageSettings", new RouteValueDictionary { { "presentAreaID", presentAreaID } }), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Add, TextIconLayout.IconText, null, null)%>
         
         </div>
         </div>
                    <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note"> Widget名称 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">WidgetID </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">ApplicationID </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">Widget类型 </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
              </tr>
              <% foreach (Widget widget in ViewData.Model)
                 { %>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.ProcessResourceToken(widget.WidgetName, CurrentUserLanguage)%> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.WidgetID %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.ApplicationID %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.WidgetType.ToString() %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <% if (widgetsDictionary.ContainsKey(widget.WidgetID.ToLower()))
                   { %>
                <a href="<%=Url.Action("UpdateWidget","ManageSettings",new{presentAreaID=presentAreaID, widgetID=widget.WidgetID }) %>"
                                    >更新</a> 
                <%  widgetsDictionary.Remove(widget.WidgetID.ToLower());
                   } %>
                <a href="<%=Url.Action("DeleteWidget","ManageSettings",new{presentAreaID=presentAreaID, widgetID=widget.WidgetID }) %>"
                                    >删除</a> 
                </td>
              </tr>
             <%}
                 foreach (Widget widget in widgetsDictionary.Values)
                 { %>
                <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.ProcessResourceToken(widget.WidgetName,CurrentUserLanguage) %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.WidgetID %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.ApplicationID %> </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=widget.WidgetType.ToString() %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <a href="<%=Url.Action("CreateWidget","ManageSettings",new{presentAreaID=presentAreaID, widgetID=widget.WidgetID }) %>">增加</a> 
                    </td>
              </tr>
             <%} %>
             </table>
                </div>
            </div>
       
</asp:content>
