﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string, Dictionary<int, NoticeItem>>>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
  <% 
      ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageRule;
      ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.NoticeSettings;
      Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  通知设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="NoticeSettings"
</asp:content>
<asp:content id="Content2" contentplaceholderid="wideContent" runat="server">
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            TempData["StatusMessageType"] = null;
        }
        UserTypes userType = (UserTypes)Enum.Parse(typeof(UserTypes), Request.QueryString.GetString("userType", "PersonUser"), true);
    %>
    <form action="<%=Url.Action("UpdateNoticeSettings", "ManageSettings",new { userType = userType })%>"
    method="post">
 
             <div class="tn-tabs tn-widget">
               <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">

                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if (userType == UserTypes.PersonUser) Response.Write(" tn-tabs-selected");%>">
                        <a href="<%=Url.Action("NoticeSettings", "ManageSettings", new { userType = UserTypes.PersonUser })%>"
                            arget="_self"><span>个人用户</span></a></li>
                    <li class="tn-widget-content tn-border-gray tn-border-trl <%if (userType == UserTypes.CompanyUser) Response.Write(" tn-tabs-selected");%>">
                        <a href="<%=Url.Action("NoticeSettings", "ManageSettings", new { userType = UserTypes.CompanyUser })%>"
                            arget="_self"><span>企业用户</span></a></li>
                </ul>
     
            
             <div class="tn-tabs-panel tn-widget-content tn-border-gray">
                <%
                    Dictionary<string, Dictionary<int, NoticeItem>> globalNoticeItemSettings = ViewData.Model;
                    Dictionary<string, NoticeItem> NoticeItem = null;
                    if (ViewData["NoticeItem"] != null)
                    { NoticeItem = ViewData["NoticeItem"] as Dictionary<string, NoticeItem>; }
                    foreach (var code in NoticeProcessorFactory.Instance().NoticeProcessorsNames.Keys)
                    {
                        string name = NoticeProcessorFactory.Instance().GetMultilingualNoticeProcessorName(code, CurrentUserLanguage);

                %>
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>设置需要<%=name%>的项目</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">你可以设置下列哪些事件发生后允许<%=name%>。</p>
           <table width="800" cellpadding="3" cellspacing="5">
                    <%
                        Response.Write("<tr>");
                        string str = "<input type=\"checkbox\"  class=\"tn-checkbox\" id=\"{0}\" name=\"{1}\" value=\"{5}\" {2} /><label for=\"{3}\">{4}</label>";
                        int i = 1;
                        string strChecked = string.Empty;

                        foreach (KeyValuePair<string, NoticeItem> item in NoticeItem)
                        {
                            Response.Write("<td>");

                            if (globalNoticeItemSettings[code].Keys.Contains(item.Value.ItemID))
                                strChecked = "checked=\"checked\"";
                            else
                                strChecked = string.Empty;

                            Response.Write(string.Format(str, code + "_" + item.Value.ItemKey, code + "_" + item.Value.ItemKey, strChecked, code + "_" + item.Value.ItemKey, item.Value.ItemName, item.Value.ItemID));

                            if (i % 3 == 0)
                                Response.Write("</td></tr><tr>");
                            else
                                Response.Write("</td>");
                            i++;
                        }

                        Response.Write("</tr>");
                    %>
                </table>
          </div>
          <%} %>
         
              <input name="updateButton" type="submit"  id="updateButton" value="更新通知设置" />
              <input id="Reset1" type="reset" value="<%=GetResourceString("Button_Reset")%>" />
              </div>
                   </div>
  
  
    </form>
</asp:content>
