﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
     <% 
        ViewData["SystemSettingMenu"] = SystemSettingMenu.SiteSetting;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.PostHolder;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  帖子相关
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="PostHolderSetting"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            TempData["StatusMessageType"] = null;
        }
        SiteSettings setting = null;
        if (ViewData["SiteSetting"] != null)
            setting = ViewData["SiteSetting"] as SiteSettings;
        //Dictionary<string, string> dir = ViewData["languages"] as Dictionary<string, string>;
        //Dictionary<int, CodeItem> TimeZoneList = ViewData["TimeZone"] as Dictionary<int, CodeItem>;
    %>
    
    
    
<form id="PostHolderForm" method="post" action="<%=SPBUrlHelper.Action("UpdateSiteSetting", "ManageSettings")%>">
                       <div class="tn-form-box">
                                <table>
                                    <tr>
                                        <th>
                                            验证码使用设置：
                                        </th>
                                        <td>
                                            <select name="VerifyCodeOption">
                                                <option value="<%=(int)VerifyCodeOption.Disabled %>" <%if(setting.VerifyCodeOption.ToString()=="Disabled") Response.Write("selected"); %>>
                                                    禁用</option>
                                                <option value="<%=(int)VerifyCodeOption.Anonymous %>" <%if(setting.VerifyCodeOption.ToString()=="Anonymous") Response.Write("selected"); %>>
                                                    仅用于匿名用户</option>
                                                <option value="<%=(int)VerifyCodeOption.Enabled %>" <%if(setting.VerifyCodeOption.ToString()=="Enabled") Response.Write("selected"); %>>
                                                    一直使用</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            记录发帖者的IP地址：
                                        </th>
                                        <td>
                                            <input name="EnableTrackPostsByIP" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableTrackPostsByIP) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="EnableTrackPostsByIP" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableTrackPostsByIP) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            公开显示发帖者的IP地址：
                                        </th>
                                        <td>
                                            <input name="DisplayPostIP" class="tn-radiobutton" type="radio" value="true" <%  if (setting.DisplayPostIP) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="DisplayPostIP" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.DisplayPostIP) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            仅向管理员显示发帖者的IP地址：
                                        </th>
                                        <td>
                                            <input name="DisplayPostIPAdminsModeratorsOnly" class="tn-radiobutton" type="radio" value="true" <%  if (setting.DisplayPostIPAdminsModeratorsOnly) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="DisplayPostIPAdminsModeratorsOnly" class="tn-radiobutton" type="radio" value="false"
                                                <%  if (!setting.DisplayPostIPAdminsModeratorsOnly) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            是否允许匿名用户发帖：
                                        </th>
                                        <td>
                                            <input name="enableAnonymousPosting" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableAnonymousPosting) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="enableAnonymousPosting" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableAnonymousPosting) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            是否启用用户发帖间隔检查：
                                        </th>
                                        <td>
                                            <input name="enableCheckPostDate" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableCheckPostDate) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="enableCheckPostDate" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnableCheckPostDate) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            图片插入到编辑器使用的编码格式：
                                        </th>
                                        <td>
                                            <input name="enableCheckImageCode" class="tn-radiobutton" type="radio" value="true" <%  if (setting.UseUBBRenderInlinedImage) Response.Write("checked=\"checked\""); %> />UBB编码格式
                                            &nbsp;<input name="enableCheckImageCode" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.UseUBBRenderInlinedImage) Response.Write("checked=\"checked\""); %> />HTML格式
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            发帖最少间隔时间：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.MinPostDateInterval %>" name="minPostDateInterval"
                                                class="tn-textbox tn-input-long tn-border-gray" style="width: 25px;" />秒
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            页面嵌入图片的尺寸限制：
                                        </th>
                                        <td>
                                            最大宽度<input type="text" value="<%=setting.InlinedImageWidth %>" name="InlinedImageWidth"
                                                class="tn-textbox tn-input-long tn-border-gray" style="width: 25px;" />px &nbsp; &nbsp; 最大高度<input type="text" value="<%=setting.InlinedImageHeight %>"
                                                    name="InlinedImageHeight" class="tn-textbox tn-input-long tn-border-gray" style="width: 25px;" />px
                                        </td>
                                    </tr>
                                     <tr>
                                        <th>
                                           
                                        </th>
                                        <td>
                                           <input id="Submit3" type="submit"  value="<%=GetResourceString("Button_Save")%>" />
                                &nbsp;
                                <input id="Reset3"  type="reset" value="<%=GetResourceString("Button_Reset")%>" />
                                            
                                        </td>
                                    </tr>
                                </table>
                            <script type="text/javascript" rel="forceLoad">
                                $(document).ready(function() {
                                    $("#PostHolderForm").validate({
                                        rules: {
                                            minPostDateInterval: { required: true, digits: true },
                                            InlinedImageWidth: { required: true, digits: true },
                                            InlinedImageHeight: { required: true, digits: true }
                                        },
                                        messages: {
                                            minPostDateInterval: { required: "请输入发帖最少间隔时间", digits: "请输入非负整数" },
                                            InlinedImageWidth: { required: "请输入宽度", digits: "请输入非负整数" },
                                            InlinedImageHeight: { required: "请输入高度", digits: "请输入非负整数" }
                                        }
                                    });

                                    $("#Submit3").click(function() {
                                        if (!$("#PostHolderForm").valid()) {
                                            return false;
                                        }
                                    });
                                }); 
                            </script>
                        </div>
                        </form>
 
</asp:content>
