﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string, PrivacyItemSettings>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageRule;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.PrivacySettings;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  隐私设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="PrivacySettings"
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            TempData["StatusMessageType"] = null;
        }

    %>
    <div class="tn-tabs tn-widget">
        <div class="tn-tabs-panel tn-widget-content">
        <form action="<%=SPBUrlHelper.Action("UpdatePrivacySettings", "ManageSettings")%>" method="post">
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>档案隐私设置</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">你可以设置下列哪些事件发生后允许站内通知。</p>
            
            <table width="800" cellpadding="3" cellspacing="5">
                    <%
                        Dictionary<string, PrivacyItemSettings> globalPrivacySettings = ViewData.Model;
                        List<PrivacyItem> PrivacyItems = null;
                        if (ViewData["PrivacyItems"] != null)
                            PrivacyItems = ViewData["PrivacyItems"] as List<PrivacyItem>;
                        if (PrivacyItems != null)
                        {
                            Response.Write("<tr>");
                            int i = 1;
                            foreach (var item in PrivacyItems)
                            {
                                if (!item.ItemKey.StartsWith("UserProfile"))
                                    continue;
                                Response.Write(" <td align=\"right\" style=\"width: 10%\">");
                                Response.Write(item.ItemName + "：");
                                Response.Write("</td>");
                                Response.Write("<td align=\"left\" style=\"width: 20%\">");
                                Response.Write(SPBHtmlHelper.Instance().PrivacyTypeRadioButtonList("SPB_" + item.ItemKey, globalPrivacySettings[item.ItemKey].PrivacyDegree, new RouteValueDictionary { { "Class", "tn-radiobutton" } }));
                                Response.Write("<div class=\"tn-text-note\">" + item.Description + "</div>");
                                if (i % 2 == 0)
                                    Response.Write("</td></tr><tr>");
                                else
                                    Response.Write("</td>");
                                i++;
                            }
                            Response.Write("</tr>");
                        }
                    %>
                </table>
          </div>
          <div class="tn-text-heading tn-border-gray tn-border-bottom"><strong>行为隐私设置</strong></div>
          <div class="tn-form-box">
            <p class="tn-text-note">你可以设置下列哪些事件发生后允许站内通知。</p>
               <table width="800" cellpadding="3" cellspacing="5">
                    <%
                        if (PrivacyItems != null)
                        {
                            Response.Write("<tr>");
                            int i = 1;
                            foreach (var item in PrivacyItems)
                            {
                                if (!item.ItemKey.StartsWith("Action"))
                                    continue;
                                Response.Write(" <td align=\"right\" style=\"width: 10%\">");
                                Response.Write(item.ItemName + "：");
                                Response.Write("</td>");
                                Response.Write("<td align=\"left\" style=\"width: 20%\">");

                                if (item.ItemKey == PrivacyItemKeys.Instance().Action_ReceiveFriendInvitation())
                                    Response.Write(SPBHtmlHelper.Instance().SpecialPrivacyActionRadioButtonList("SPB_" + item.ItemKey, globalPrivacySettings[item.ItemKey].PrivacyDegree == PrivacyDegree.Public ? true : false, new RouteValueDictionary { { "Class", "radiobutton" } }));
                                else
                                    Response.Write(SPBHtmlHelper.Instance().PrivacyTypeRadioButtonList("SPB_" + item.ItemKey, globalPrivacySettings[item.ItemKey].PrivacyDegree, new RouteValueDictionary { { "Class", "radiobutton" } }));
                                Response.Write("<div class=\"tn-text-note\">" + item.Description + "</div>");


                                if (i % 2 == 0)
                                    Response.Write("</td></tr><tr>");
                                else
                                    Response.Write("</td>");
                                i++;
                            }
                            Response.Write("</tr>");
                        }
                    %>
                     <tr>
                <td colspan="3">&nbsp;</td>
              </tr>
                     <tr> <td>&nbsp;</td>
                <td colspan="3">
                 <input name="updateButton" type="submit" id="updateButton" value="更新隐私设置" />&nbsp;
                        <input id="Reset1" type="reset" value="<%=GetResourceString("Button_Reset")%>" />
                </td>
              </tr>
                </table>
          </div>
          </form>
        </div>
      </div>

</asp:content>
