﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string,SpaceBuilder.Tasks.TaskDetail>>" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
   <% 
       ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageTool;
       ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.TasksReport;
       Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  任务执行报告
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="TasksReport"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">

<div class="tn-tabs tn-widget">


        <div class="tn-tabs-panel tn-widget-content tn-border-gray">
        <%
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
            if (statusMessageData != null)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                statusMessageData = null;
            }
        %>
        <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 序号</th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 服务名称</th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 上次开始时间 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note">上次结束时间 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 是否可用 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 上次运行是否正常 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 当前是否运行 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 下次运行时间 </th>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> 操作 </th>
                </tr>
          <%
              if (Model != null && Model.Count > 0)
              {
                  int threadCount = 1;
                  foreach (KeyValuePair<string, SpaceBuilder.Tasks.TaskDetail> taskDetail in Model)
                  {
                      SpaceBuilder.Tasks.TaskDetail taskThread = taskDetail.Value;
        %>
       <tr class="tn-table-grid-row">
       <td class="tn-border-gray tn-border-bottom tn-nowrap">
         <%=threadCount++ %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
           <%=taskThread.Name %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
          <% 
              if (taskThread.LastStarted == DateTime.MinValue)
                  Response.Write("--");
              else
                  Response.Write(Formatter.FormatDate(taskThread.LastStarted, true));
                                %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <% 
                if (taskThread.LastEnd == DateTime.MinValue)
                    Response.Write("--");
                else
                    Response.Write(Formatter.FormatDate(taskThread.LastEnd, true));
            %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
              <%=taskThread.Enabled.ToString()%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%=taskThread.LastIsSuccess?"正常":"<font color=\"red\">异常</font>" %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
            <%=taskThread.IsRunning.ToString() %>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-nowrap">
           <% =taskThread.NextStart.HasValue? Formatter.FormatDate(taskThread.NextStart.Value,true):"NULL" %>
        </td>
          <td class="tn-border-gray tn-border-bottom tn-nowrap">
         <a href="<%=Url.Action("ExecuteReport","ManageSettings",new{ taskName = taskThread.Name }) %>"
                onclick="return confirm('您确定要执行 <%=taskThread.Name %> 任务吗？')"
               >执行任务</a>
        </td>
 
          </tr>
          <%
              }
              } 
                    %>
                                    
                </table>
        </div>
      </div>

</asp:content>
