﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
     <% 
         ViewData["SystemSettingMenu"] = SystemSettingMenu.SiteSetting;
         ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.UserHolder;
         Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  用户相关
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="UserHolderSetting"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      SiteSettings setting = null;
      if (ViewData["SiteSetting"] != null)
          setting = ViewData["SiteSetting"] as SiteSettings;
      //Dictionary<string, string> dir = ViewData["languages"] as Dictionary<string, string>;
      //Dictionary<int, CodeItem> TimeZoneList = ViewData["TimeZone"] as Dictionary<int, CodeItem>;
    %>
<form id="UserHolderForm" method="post" action="<%=SPBUrlHelper.Action("UpdateSiteSetting", "ManageSettings")%>">
                      <div class="tn-form-box">
                                <table>
                                    <tr>
                                        <th>
                                            帐号激活设置：
                                        </th>
                                        <td>
                                            <select class="tn-dropdownlist" style="width: 80px" name="AccountActivation">
                                                <option value="<%=(int)AccountActivations.Automatic %>" <%if(setting.AccountActivation==AccountActivations.Automatic) Response.Write("selected"); %>>
                                                    自动激活</option>
                                                <option value="<%=(int)AccountActivations.Email %>" <%if(setting.AccountActivation==AccountActivations.Email) Response.Write("selected"); %>>
                                                    验证Email</option>
                                                <option value="<%=(int)AccountActivations.AdminApproval %>" <%if(setting.AccountActivation==AccountActivations.AdminApproval) Response.Write("selected"); %>>
                                                    管理员验证</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            用户注册方式设置：
                                        </th>
                                        <td>
                                            <select class="tn-dropdownlist" name="RegistrationMode">
                                                <option value="<%=(int)RegistrationModes.EnableAll %>" <%if (setting.RegistrationMode == RegistrationModes.EnableAll) Response.Write("selected"); %>>
                                                    允许所有途径的注册</option>
                                                <option value="<%=(int)RegistrationModes.DisableAll %>" <%if (setting.RegistrationMode == RegistrationModes.DisableAll) Response.Write("selected"); %>>
                                                    禁止注册</option>
                                                <option value="<%=(int)RegistrationModes.OnlyByInvitation %>" <%if (setting.RegistrationMode == RegistrationModes.OnlyByInvitation) Response.Write("selected"); %>>
                                                    仅允许通过邀请注册</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            是否允许待审批的用户登录：
                                        </th>
                                        <td>
                                            <input name="EnablePendingUsersToLogin" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnablePendingUsersToLogin) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="EnablePendingUsersToLogin" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.EnablePendingUsersToLogin) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                    <th>是否启用身份认证：</th>
                                    <td>
                                    <input name="EnableIdentity" class="tn-radiobutton"  type="radio" value="true" <% if (setting.EnableUserIdentity) Response.Write("checked=\"checked\" "); %> /> 是 &nbsp; 
                                    <input name="EnableIdentity"  class="tn-radiobutton" type="radio" value="false" <% if (!setting.EnableUserIdentity) Response.Write("checked=\"checked\" "); %>/>否
                                     </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            是否关闭企业用户注册：
                                        </th>
                                        <td>
                                            <input name="IsCloseCompanyUser" class="tn-radiobutton" type="radio" value="true" <%  if (setting.IsCloseCompanyUser) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="IsCloseCompanyUser" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.IsCloseCompanyUser) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            企业用户注册是否需要审核：
                                        </th>
                                        <td>
                                            <input name="IsAuditCompanyUser" class="tn-radiobutton" type="radio" value="true" <%  if (setting.IsAuditCompanyUser) Response.Write("checked=\"checked\""); %> />是
                                            &nbsp;<input name="IsAuditCompanyUser" class="tn-radiobutton" type="radio" value="false" <%  if (!setting.IsAuditCompanyUser) Response.Write("checked=\"checked\""); %> />否
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            是否进入向导模式值：
                                        </th>
                                        <td>
                                            <input name="EnterWizardModeValue" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=setting.EnterWizardModeValue %>"  />
                                            <span class="tn-text-note">小于<b>0</b>时不进入向导模式，与资料完整度比较</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            用户名最大长度：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.UserNameMaxLength %>" class="tn-textbox tn-input-long tn-border-gray" name="UserNameMaxLength" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            用户名最小长度：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.UserNameMinLength %>" class="tn-textbox tn-input-long tn-border-gray" name="UserNameMinLength" />
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <th>
                                            用户初始附件容量（K）：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.UserDatabaseQuota%>" class="tn-textbox tn-input-long tn-border-gray"
                                                name="UserDatabaseQuota" />
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <th>
                                            附件容量间隔值（K）：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.DatabaseQuotaIntervalValue%>" class="tn-textbox tn-input-long tn-border-gray"
                                                name="DatabaseQuotaIntervalValue" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            用户名验证正则表达式：<br />
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.UserNameRegex %>" class="tn-textbox tn-input-long tn-border-gray" name="UserNameRegex" />
                                            <span  class="tn-text-note">用于验证用户名字符串是否合法</span>
                                        </td>
                                    </tr>
                                    <tr>
                                    <th>电子邮件正则表达式：</th>
                                    <td>
                                    <input type="text" value="<%=setting.EmailRegex %>" class="tn-textbox tn-input-long tn-border-gray"  name="emailRegex" />
                                    <span class="tn-text-note">用户验证电子邮箱是否合法</span>
                                    </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            密码中包含的最少特殊字符数：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.MinRequiredNonAlphanumericCharacters%>" class="tn-textbox tn-input-long tn-border-gray"
                                                name="MinRequiredNonAlphanumericCharacters" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            密码最小长度：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.PasswordMinLength%>" class="tn-textbox tn-input-long tn-border-gray" name="PasswordMinLength" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            密码验证正则表达式：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.PasswordRegex%>" class="tn-textbox tn-input-long tn-border-gray" name="PasswordRegex" />
                                            <span  class="tn-text-note">用于验证用户密码符串是否合法</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            用户密码加密方式：
                                        </th>
                                        <td>
                                            <select class="tn-dropdownlist" name="UserPasswordFormat">
                                                <option value="<%=(int)UserPasswordFormats.MD5 %>" <%if (setting.UserPasswordFormat == UserPasswordFormats.MD5) Response.Write("selected"); %>>
                                                    MD5加密算法</option>
                                                <option value="<%=(int)UserPasswordFormats.EncryptedFromSpaceBuilder %>" <%if (setting.UserPasswordFormat == UserPasswordFormats.EncryptedFromSpaceBuilder) Response.Write("selected"); %>>
                                                    SpaceBuilder自有的对称加密算法</option>
                                                <option value="<%=(int)UserPasswordFormats.HashedFromMembership %>" <%if (setting.UserPasswordFormat == UserPasswordFormats.HashedFromMembership) Response.Write("selected"); %>>
                                                    使用 SHA1 哈希算法单向加密</option>
                                                <option value="<%=(int)UserPasswordFormats.EncryptedFromMembership %>" <%if (setting.UserPasswordFormat == UserPasswordFormats.EncryptedFromMembership) Response.Write("selected"); %>>
                                                    使用由machineKey元素配置确定的加密设置加密</option>
                                                <option value="<%=(int)UserPasswordFormats.Clear %>" <%if (setting.UserPasswordFormat == UserPasswordFormats.Clear) Response.Write("selected"); %>>
                                                    不使用加密</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            启用用户管制：
                                        </th>
                                        <td>
                                            <input name="EnableModeratedUser" id="EnableModeratedUser-true" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableModeratedUser) Response.Write("checked=\"checked\""); %> /><label
                                                for="EnableModeratedUser-true">是</label>
                                            &nbsp;<input name="EnableModeratedUser" id="EnableModeratedUser-false" class="tn-radiobutton" type="radio" value="false"
                                                <%  if (!setting.EnableModeratedUser) Response.Write("checked=\"checked\""); %> /><label
                                                    for="EnableModeratedUser-false">否</label>
                                            <span class="tn-text-note">启用时，管制用户所发布的信息会变为待审核状态</span>
                                        </td>
                                    </tr>
                                     <tr>
                                        <th>
                                            默认新注册用户管制状态：
                                        </th>
                                        <td>                 
                                            <input name="DefaultModeratedStatus" id="DefaultModeratedStatus_true" class="tn-radiobutton" type="radio" value="true" <%if (setting.DefaultModeratedStatus) Response.Write("checked=\"checked\""); %> /><label
                                                for="DefaultModeratedStatus_true">是</label>
                                            &nbsp;<input name="DefaultModeratedStatus" id="DefaultModeratedStatus_false" class="tn-radiobutton" type="radio" value="false"
                                                <%  if (!setting.DefaultModeratedStatus) Response.Write("checked=\"checked\""); %> /><label
                                                    for="DefaultModeratedStatus_false">否</label>
                                            <span class="tn-text-note">启用时，新注册用户默认为被管制状态</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            自动解除管制的用户积分：
                                        </th>
                                        <td>
                                            <input type="text" value="<%=setting.NoModeratedUserPoint%>" class="tn-textbox tn-input-short tn-border-gray" name="NoModeratedUserPoint" />
                                            <span class="tn-text-note">前台新注册的用户将受管制，当用户经验值升到该值时则自动解除管制状态</span>
                                        </td>
                                    </tr>

                                    <tr>
                                        <th>
                                            是否启用昵称：
                                        </th>
                                        <td>
                                            <input name="EnableNickName" id="EnableNickName-true" class="tn-radiobutton" type="radio" value="true" <%  if (setting.EnableNickName) Response.Write("checked=\"checked\""); %> /><label
                                                for="EnableNickName-true">是</label>
                                            &nbsp;<input name="EnableNickName" id="EnableNickName-false" class="tn-radiobutton" type="radio" value="false"
                                                <%  if (!setting.EnableNickName) Response.Write("checked=\"checked\""); %> /><label
                                                    for="EnableNickName-false">否</label>
                                        </td>
                                    </tr>
                                    <tr id="DisplayNameTypeTr">
                                        <th>
                                            用什么名称作为用户的DisplayName对外显示：
                                        </th>
                                        <td>
                                            <table class="radiobutton" border="0">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <input class="tn-radiobutton" type="radio" id="DisplayNameType1" name="DisplayNameType" value="<%=(int)DisplayNameTypes.NickNameFirst %>"
                                                                <%if(setting.DisplayNameType==DisplayNameTypes.NickNameFirst) Response.Write("checked=\"checked\"");%> /><label
                                                                    for="DisplayNameType1">优先采用昵称，如果昵称不存在则用真实姓名，如果真实姓名也不存在则用UserName</label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <input class="tn-radiobutton" type="radio" id="DisplayNameType2" name="DisplayNameType" value="<%=(int)DisplayNameTypes.CommonNameFirst %>"
                                                                <%if(setting.DisplayNameType==DisplayNameTypes.CommonNameFirst) Response.Write("checked=\"checked\"");%> /><label
                                                                    for="DisplayNameType2">优先采用真实姓名，如果真实姓名不存在则用昵称，如果昵称也不存在则用UserName</label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <input class="tn-radiobutton" type="radio" id="DisplayNameType3" name="DisplayNameType" value="<%=(int)DisplayNameTypes.NickName %>"
                                                                <%if(setting.DisplayNameType==DisplayNameTypes.NickName) Response.Write("checked=\"checked\"");%> /><label
                                                                    for="DisplayNameType3">仅采用昵称</label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <input class="tn-radiobutton" type="radio" id="DisplayNameType4" name="DisplayNameType" value="<%=(int)DisplayNameTypes.CommonName %>"
                                                                <%if(setting.DisplayNameType==DisplayNameTypes.CommonName) Response.Write("checked=\"checked\"");%> /><label
                                                                    for="DisplayNameType4">仅采用真实姓名</label>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            不允许使用的用户名（管理员不受限制）：
                                        </th>
                                        <td>
                                            <textarea id="TextArea4" class="tn-textbox tn-input-long tn-border-gray" cols="60" rows="2" name="DisallowedUserNames"><%=setting.DisallowedUserNames%></textarea><span
                                                 class="tn-text-note">用逗号隔开每一个用户名</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            档案完整程度权重设置：
                                        </th>
                                        <td>
                                            头像<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="AvatarProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.Avatar] %>" /><strong>%</strong>
                                            <strong>+</strong>出生日期<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="BirthdayProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.Birthday] %>" /><strong>%</strong>
                                            <strong>+</strong>家乡<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="HomeAreaProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.HomeArea] %>" /><strong>%</strong>
                                            <strong>+</strong>居住地<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="NowAreaProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.NowArea] %>" /><strong>%</strong>
                                            <strong>+</strong>即时通讯<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="IMProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.IM] %>" /><strong>%</strong>
                                            <strong>+</strong>毕业院校<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="SchoolProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.School] %>" /><strong>%</strong>
                                            <strong>+</strong>公开邮箱<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="PublicEmailProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.PublicEmail] %>" /><strong>%</strong>
                                            <strong>+</strong>职业信息<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="JobInformationProportion"
                                                value="<%=setting.IntegrityProportions[(int)ProfileItems.JobInformation] %>" /><strong>%</strong>
                                            <div  class="tn-text-note">请确保各档案项所占比重总和为100</div>
                                        </td>
                                    </tr>
                 <tr>
            <th>&nbsp;</th>
            <td>
            <input id="Submit2" type="submit"  value="<%=GetResourceString("Button_Save")%>" />
                                &nbsp;
                                <input id="Reset2"  type="reset" value="<%=GetResourceString("Button_Reset")%>" />
            
            </td>
          </tr>
                                </table>
                          
                         
                                
                            <script type="text/javascript" rel="forceLoad">
                                $(document).ready(function() {
                                    $("#UserHolderForm").validate({
                                        rules: {
                                            UserNameMaxLength: { required: true, digits: true },
                                            UserNameMinLength: { required: true, digits: true },
                                            MinRequiredNonAlphanumericCharacters: { required: true, digits: true },
                                            PasswordMinLength: { required: true, digits: true }
                                        },
                                        messages: {
                                            UserNameMaxLength: { required: "请输入非负整数", digits: "请输入非负整数" },
                                            UserNameMinLength: { required: "请输入非负整数", digits: "请输入非负整数" },
                                            MinRequiredNonAlphanumericCharacters: { required: "请输入非负整数", digits: "请输入非负整数" },
                                            PasswordMinLength: { required: "请输入非负整数", digits: "请输入非负整数" }
                                        }
                                    });

                                    $("#Submit2").click(function() {
                                        if (!$("#UserHolderForm").valid()) {
                                            return false;
                                        }
                                    });
                                }); 
                            </script>

                        </div>
                        </form>    
    
</asp:content>
