﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<Dictionary<string, TunyNetLicense>>" %>

<%@ Import Namespace="TunyNet.License" %>
<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
     <% 
         ViewData["SystemSettingMenu"] = SystemSettingMenu.ManageTool;
         ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.LicenseInformation;
         Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  版本及授权信息
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="VersionReport"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">

                    <%
                        foreach (KeyValuePair<string, TunyNetLicense> item in Model)
                        {
                            TunyNetLicense license = item.Value;
                            DomainConstraint domainConstraint = null;
                            foreach (TunyNet.License.IConstraint constraint in license.Constraints)
                            {
                                if (constraint is TunyNet.License.DomainConstraint)
                                    domainConstraint = constraint as TunyNet.License.DomainConstraint;
                            }

                            string domainNameLicensed = string.Empty;
                            if (domainConstraint == null || domainConstraint.Domains.Length == 0)
                            {
                                domainNameLicensed = "未限制域名";
                            }
                            else
                            {
                                domainNameLicensed = string.Join(" , ", domainConstraint.Domains);
                            }

                            string licensedApplicationNames = string.Empty;
                            foreach (var application in license.ApplicationConstraint.Applications)
                            {
                                licensedApplicationNames += application.Value + "&nbsp;&nbsp;";
                            }    
                         %>
                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                            <strong>授权信息（<%=item.Key %>）</strong>
                            </div>
                           <p>
                                        版本类型：<%=license.Product.Level %>
                               </p>
                                <p>
                                    
                                        用户类型：<%=license.User.UserType%>
                                </p>
                                <p>
                                    
                                        授权域名：<%=domainNameLicensed%>
                                </p>
<%--                                <p>
                                    
                                        授权版本：<%=license.Product.Version%></p>--%>
                                <p>
                                    
                                        授权模块：<%= "{&nbsp;&nbsp;" + licensedApplicationNames + "}"%></p>
                         
                      
                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                            <strong>用户信息（<%=item.Key %>）</strong>
                          </div>
                         
                                <p>
                                    
                                        用户名称：<%=license.User.Name %>
                                </p>
                                <p>
                                    
                                        用户组织：<%=license.User.Organization %>
                                </p>
                                <p>
                                    
                                        电子信箱：<%=license.User.Email %>
                                </p>
                           
                       
                   <% 
                       }
                        TunyNetLicense mainLicense = Model.First<KeyValuePair<string, TunyNetLicense>>().Value;
                   %>
                       <div class="tn-text-heading tn-border-gray tn-border-bottom">
                            <strong>产品信息</strong>
                             </div>    
                      
                                <p>
                                    
                                        产品名称：<%=mainLicense.Product.FullName%>
                                </p>
                                <p>
                                    
                                        产品版本：<%=SPBConfig.Instance().SpaceBuilderVersion.ToString() %>
                                </p>
                                <p>
                                    
                                        产品编码：<%=mainLicense.Product.LicenseID%>
                                </p>
                                <p>
                                    
                                        开发厂商：<%=mainLicense.Product.Developer%>
                                </p>
                                <p>
                                    
                                        产品描述：<%=mainLicense.Product.Description%>
                                </p>
                             
                  
</asp:content>
