﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage" %>

<asp:content id="Content1" contentplaceholderid="HeaderContent" runat="server">
    <% 
        ViewData["SystemSettingMenu"] = SystemSettingMenu.SiteSetting;
        ViewData["SystemSettingsSubMenu"] = SystemSettingsSubMenu.WatermarkSetting;
        Html.RenderPartial("Controls/Settings/SettingsSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
  水印设置
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="WatermarkHolderSetting"
</asp:content>
<asp:content id="Content4" contentplaceholderid="wideContent" runat="server">
  <%
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          TempData["StatusMessageType"] = null;
      }
      SiteSettings setting = null;
      if (ViewData["SiteSetting"] != null)
          setting = ViewData["SiteSetting"] as SiteSettings;
    %>
<form id="WatermarkHolderForm"  method="post" action="<%=SPBUrlHelper.Action("UpdateSiteSetting", "ManageSettings")%>">
                            <script type="text/javascript">
                                function ChangeWaterTr(a) {
                                    if (a == '<%=(int)WatermarkTypes.None %>') {
                                        $('#WaterEableTr').css('display', 'none');
                                        $('#WaterEableTr1').css('display', 'none');
                                        $('#WaterEableTr2').css('display', 'none');
                                        $('#WaterEableTr3').css('display', 'none');
                                        $('#WaterEableTrWord').css('display', 'none');
                                        $('#WaterEableTrPic').css('display', 'none');
                                    }
                                    else {
                                        $('#WaterEableTr').css('display', '');
                                        $('#WaterEableTr1').css('display', '');
                                        $('#WaterEableTr2').css('display', '');
                                        $('#WaterEableTr3').css('display', '');

                                        if (a == '<%=(int)WatermarkTypes.Text %>') {
                                            $('#WaterEableTrWord').css('display', '');
                                            $('#WaterEableTrPic').css('display', 'none');
                                        }
                                        else {
                                            $('#WaterEableTrWord').css('display', 'none');
                                            $('#WaterEableTrPic').css('display', '');
                                        }
                                    }


                                }
                                //$(document).ready(ChangeWaterTr('<%=(int)setting.WatermarkType %>'));
                            </script>
    <div class="tn-form-box">
                                <table>
                                    <tr>
                                        <th>
                                            水印类型：
                                        </th>
                                        <td>
                                            <select class="tn-dropdownlist" name="WatermarkType" onchange="ChangeWaterTr(this.value)">
                                                <option value="<%=(int)WatermarkTypes.None %>" <% if(setting.WatermarkType==WatermarkTypes.None) Response.Write("selected"); %>>
                                                    禁用水印</option>
                                                <option value="<%=(int)WatermarkTypes.Text %>" <% if(setting.WatermarkType==WatermarkTypes.Text) Response.Write("selected"); %>>
                                                    文字水印</option>
                                                <option value="<%=(int)WatermarkTypes.Image %>" <% if(setting.WatermarkType==WatermarkTypes.Image) Response.Write("selected"); %>>
                                                    图像水印</option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr id="WaterEableTr">
                                        <th>
                                            水印所在位置：
                                        </th>
                                        <td>
                                            <table class="radiobutton" border="0">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <input id="WatermarkPosition1" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="LeftTop"
                                                                <%if (setting.WatermarkPosition.ToString() == "LeftTop") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition1">左上</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition2" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="CenterTop"
                                                                <%if (setting.WatermarkPosition.ToString() == "CenterTop") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition2">中上</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition3" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="RightTop"
                                                                <%if (setting.WatermarkPosition.ToString() == "RightTop") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition3">右上</label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <input id="WatermarkPosition4" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="LeftMiddle"
                                                                <%if (setting.WatermarkPosition.ToString() == "LeftMiddle") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition4">左中</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition5" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="Center"
                                                                <%if (setting.WatermarkPosition.ToString() == "Center") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition5">中心</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition6" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="RightMiddle"
                                                                <%if (setting.WatermarkPosition.ToString() == "RightMiddle") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition6">右中</label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <input id="WatermarkPosition7" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="LeftBottom"
                                                                <%if (setting.WatermarkPosition.ToString() == "LeftBottom") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition7">左下</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition8" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="CenterBottom"
                                                                <%if (setting.WatermarkPosition.ToString() == "CenterBottom") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPositio8">中下</label>
                                                        </td>
                                                        <td>
                                                            <input id="WatermarkPosition9" class="tn-radiobutton" type="radio" name="WatermarkPosition" value="RightBottom"
                                                                <%if (setting.WatermarkPosition.ToString() == "RightBottom") Response.Write("checked=\"checked\""); %> /><label
                                                                    for="WatermarkPosition9">右下</label>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr id="WaterEableTrWord">
                                        <th>
                                            水印文字：
                                        </th>
                                        <td>
                                            <input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 400px" name="WatermarkText" value="<%=setting.WatermarkText %>" />
                                        </td>
                                    </tr>
                                    <tr id="WaterEableTrPic">
                                        <th>
                                            水印图片名称：
                                        </th>
                                        <td>
                                            <input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 200px" name="WatermarkImageName"
                                                value="<%=setting.WatermarkImageName %>" /><span class="tn-text-note">
                                                    请将水印图片放到web根目录下的Images文件夹内</span>
                                        </td>
                                    </tr>
                                    <tr id="WaterEableTr1">
                                        <th>
                                            添加水印的条件：
                                        </th>
                                        <td>
                                            图片最小宽度<input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="WatermarkMinWidth"
                                                value="<%=setting.WatermarkMinWidth %>" />px &nbsp; X 最小高度<input type="text" class="tn-textbox tn-input-long tn-border-gray"
                                                    style="width: 30px" name="WatermarkMinHeight" value="<%=setting.WatermarkMinHeight %>" />px
                                            <span class="tn-text-note">如果图片的宽度或高度小于设定值，将不添加水印</span>
                                        </td>
                                    </tr>
                                    <tr id="WaterEableTr2">
                                        <th>
                                            水印透明度：
                                        </th>
                                        <td>
                                            <input type="text" class="tn-textbox tn-input-long tn-border-gray" style="width: 30px" name="WatermarkAlpha" value="<%=setting.WatermarkAlpha %>" />
                                            <span class="tn-text-note">水印透明度的取值范围为0.1~1.0</span>
                                        </td>
                                    </tr> 
                                         <tr>
                                    <th>
                                       
                                    </th>
                                    <td>
 <input id="Submit4" type="submit"  value="<%=GetResourceString("Button_Save")%>" />
                            &nbsp;
                            <input id="Reset4"  type="reset" value="<%=GetResourceString("Button_Reset")%>" />
 
                                    </td>
                                </tr>                          
                            </table>
        
                        <script type="text/javascript" rel="forceLoad">

                            $(document).ready(function() {
                                $("#WatermarkHolderForm").validate({
                                    rules: {
                                        WatermarkMinWidth: { required: true, digits: true },
                                        WatermarkMinHeight: { required: true, digits: true },
                                        WatermarkAlpha: { required: true, range: [0.1, 1] },
                                        WatermarkImageName: { required: true }
                                    },
                                    messages: {
                                        WatermarkMinWidth: { required: "请输入宽度", digits: "请输入非负整数" },
                                        WatermarkMinHeight: { required: "请输入高度", digits: "请输入非负整数" },
                                        WatermarkAlpha: { required: "请输入透明度", range: "请输入0.1~1.0的数" },
                                        WatermarkImageName: { required: "请填写水印图片名称" }
                                    }
                                });

                                $("#Submit4").click(function() {
                                    if (!$("#WatermarkHolderForm").valid()) {
                                        return false;
                                    }
                                });
                            }); 
                        </script>
                    </div>
                    </form> 
</asp:content>
