﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<ShareComment>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    分享评论管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Share-ManageShareComments"
</asp:content>
<asp:content runat="server" contentplaceholderid="HeaderContent">
  <% ViewData["ShareSubMenu"] = ShareSubMenu.ManageShareComment;%>
  <% Html.RenderPartial("Controls/Share/ShareSubMenu.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server"> 
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       if (messageType == StatusMessageType.Success)
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
       else
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
       TempData["StatusMessageType"] = null;
   }
   AuditingStatusesForDisplay auditingStatusForDisplay = AuditingStatusesForDisplay.Success;
   if (ViewData["AuditingStatusForDisplay"] != null)
       auditingStatusForDisplay = (AuditingStatusesForDisplay)ViewData["AuditingStatusForDisplay"];%>

<form id="SearchSharePostsForm" action="<%=Url.Action("SearechShareComments","ManageShare",new {auditingStatusForDisplay = auditingStatusForDisplay}) %>" method="post">
  <div class="tn-form-box tn-border-gray tn-border-bottom">
     <table>
           <tr>
               <th>
                   名称关键字：
               </th>
               <td>
                   <input name="bodyKeywords" id="bodyKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("bodyKeywords",string.Empty) %>" />
               </td>
               <th>
                   用户ID
               </th>
               <td>
                    <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<%= Request.QueryString.GetString("UserID", string.Empty)%>" />
               </td>
               <td>    
                          <input type="submit" id="searchButton"  value="<%=GetResourceString("Button_Search")%>" />                      
              </td>
           </tr>
       </table>
   </div>
</form>
           <script type="text/javascript">
               $(document).ready(function() {
                   $("#SearchSharePostsForm").validate({
                       rules: {
                           userID: { digits: true }
                       },
                       messages: {
                           userID: { digits: "请输入非负整数" }
                       }
                   });

                   $("#searchButton").click(function() {
                       if (!$("#SearchSharePostsForm").valid()) {
                           return false;
                       }
                   });
               }); 

    </script>
<div class="tn-tabs tn-widget">
  <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareComments", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Success,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>" target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareComments", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Pending,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>待审核</span></a></li>
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareComments", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Fail,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>未通过审核</span></a></li>
  </ul>
  <div class="tn-tabs-panel tn-widget-content tn-border-gray">
    <form id="ManageSharePostsForm" method="post" action="" >
      <table class="tn-table-grid">
        <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
          <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageSharePostsForm').attr('action','"+Url.Action("SetCommentAuditingStatus","ManageShare",
                    new {auditingStatuses=AuditingStatuses.Success,returnUrl= Request.RawUrl})+"'); $('#ManageSharePostsForm').submit();return false;"},{"title","把选中的分享通过审核"}}, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                                  new RouteValueDictionary { { "onclick", "$('#ManageSharePostsForm').attr('action','" + Url.Action("SetCommentAuditingStatus","ManageShare",
                    new {auditingStatuses=AuditingStatuses.Fail,returnUrl= Request.RawUrl}) + "'); $('#ManageSharePostsForm').submit();return false;" }, { "title", "把选中的分享不通过审核" } }, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                                  new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些分享吗？')) {$('#ManageSharePostsForm').attr('action','" + Url.Action("DeleteComments","ManageShare",
                    new {returnUrl= Request.RawUrl}) + "'); $('#ManageSharePostsForm').submit();return false;}" }, { "title", "确认要删除这些分享吗" } }, null)%>
         </div>
       </div>
        <tr class="tn-table-grid-header">
          <th class="tn-border-gray tn-border-bottom">
                  <input type="checkbox"  class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              评论者用户ID
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
             <%=GetResourceString("Label_Body")%>
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              评论者
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              评论对象
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              <%=GetResourceString("Label_CommentDate") %>
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
             操作
          </th>
        </tr>
        <% if (Model != null)
           {
               foreach (ShareComment comment in Model.Records)
               {%>
        <tr class="tn-table-grid-row">
         <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input type="checkbox" name="CheckBoxGroup" class="tn-checkbox" value="<%=comment.CommentID %>" />
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
           <%=comment.UserID%>
         </td>
         <td class="tn-border-gray tn-border-bottom tn-width-auto">
           <%=HtmlUtils.TrimHtml(comment.Body, 30)%>
         </td>
         <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
           <% if (comment.UserID > 0)
              { %>
             <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(comment.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                    title="点击查看<%=comment.Author%>的个人空间"> <%=comment.Author%></a>
           <%}
              else Response.Write(comment.Author); %>
         </td>
         <td class="tn-border-gray tn-border-bottom tn-width-auto">
            <% if (comment.ThreadID > 0)
               {
                   ShareThread thread = ShareThreads.GetThread(comment.ThreadID, false);
                   if (thread != null)
                   {%>                  
                  <a href="<%=SiteUrls.Instance().ShowShareThread(comment.ThreadID) %>"><%=StringUtils.Trim(thread.Subject, 20)%></a>
            <% }
               }
               else if (comment.UserThreadID > 0)
               {
                   UserShareThread userShareThread = UserShareThreads.GetThread(comment.UserThreadID, false);
                   if (userShareThread != null)
                   {
                       User user = Users.GetUser(userShareThread.UserID, false);
                       if (user != null)
                       {  %>
                   
               <a href="<%=SiteUrls.Instance().ShowUserShareThread(user.UserName,comment.UserThreadID) %>"><%=StringUtils.Trim(userShareThread.SiteShareThread.Subject,20) %></a>
               <%}
                   }
               }%>
         </td>
         <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
            <%= Formatter.FormatDate(comment.DateCreated, true)%>                    
         </td>
         <td class="tn-border-gray tn-border-bottom tn-nowrap">
           <span class="tn-action">
            <a href="javascript:;" class="tn-action-text" onclick="if (confirm('确定要删除该评论吗？')) {window.location= '<%=this.Url.Action("DeleteComment", "ManageShare", new { commentID =comment.CommentID,returnUrl= Request.RawUrl })%>'};"> 删除</a>
           </span>
         </td>
        </tr>
        <%}
           } %>
      </table>
      <div class="tn-pagination tn-helper-align-center">
           <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex)%> 
           <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>            
       </div>
    </form>
  </div>
</div>
</asp:content>
