﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<ShareThread>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    分享管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Share-ManageShareThreads"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
  <% ViewData["ShareSubMenu"] = ShareSubMenu.ManageShare;  %>
  <% Html.RenderPartial("Controls/Share/ShareSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
<%if (TempData["StautsMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StautsMessageType", (int)StatusMessageType.Error);
      if (messageType == StatusMessageType.Success)
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StautsMessageContent", string.Empty), 3000));
      else
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StautsMessageContent", string.Empty)));
  }
  TempData["StautsMessageType"] = null;

  AuditingStatusesForDisplay auditingStatusForDisplay = ViewData.Get<AuditingStatusesForDisplay>("AuditingStatusForDisplay", AuditingStatusesForDisplay.Success);%>
<form id="SearchSharesForm" action="<%=Url.Action("SearchShareThreads","ManageShare",new {auditingStautsesForDisplay= auditingStatusForDisplay}) %>" method="post">
  <div class="tn-form-box tn-border-gray tn-border-bottom">
     <table>
           <tr>
               <th>
                   名称关键字：
               </th>
               <td>
                   <input name="subjectKeywords" id="subjectKeywords" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("subjectKeywords",string.Empty) %>" />
               </td>
               <th>
                   用户ID
               </th>
               <td>
                    <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<%=Request.QueryString.GetString("UserID", string.Empty) %>" />
               </td>
               <td>    
                          <input type="submit" id="searchButton"  value="<%=GetResourceString("Button_Search")%>" />                      
              </td>
           </tr>
       </table>
   </div>
</form>
<div class="tn-tabs tn-widget">
  <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareThreads", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Success,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>" target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareThreads", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Pending,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>待审核</span></a></li>
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Again) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareThreads", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Again,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>需再审核</span></a></li>
    <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageShareThreads", "ManageShare", new {auditingStatusForDisplay = AuditingStatusesForDisplay.Fail,subjectKeywords=Request.QueryString.GetString("subjectKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>未通过审核</span></a></li>
  </ul>
  <div class="tn-tabs-panel tn-widget-content tn-border-gray">
    <form id="ManageSharesForm" method="post" action="" >
      <table class="tn-table-grid">
        <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
          <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageSharesForm').attr('action','"+Url.Action("SetShareAuditingStatus","ManageShare",
                  new {isPass=true,returnUrl= Request.RawUrl})+"'); $('#ManageSharesForm').submit();return false;"},{"title","把选中的分享通过审核"}}, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                  new RouteValueDictionary{{"onclick","$('#ManageSharesForm').attr('action','"+Url.Action("SetShareAuditingStatus","ManageShare",new {isPass=false,returnUrl= Request.RawUrl})+"'); $('#ManageSharesForm').submit();return false;"},{"title","把选中的分享不通过审核"}}, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,
                  new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些分享吗？')) {$('#ManageSharesForm').attr('action','" + Url.Action("DeleteShareThreads", "ManageShare", new { returnUrl = Request.RawUrl }) + "'); $('#ManageSharesForm').submit();return false;}" }, { "title", "确认要删除这些分享吗" } }, null)%>
         </div>
       </div>
        <tr class="tn-table-grid-header">
          <th class="tn-border-gray tn-border-bottom">
                  <input type="checkbox"  class="tn-checkbox" onclick="checkAll(this,'ManageSharesCheckBoxGroup')" />
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              <%=GetResourceString("Label_Subject")%>
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              分享人
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              分享类型
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              分享类别
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
              分享人数
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
             点击数
          </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note">
             操作
          </th>
        </tr>
        <% if (Model != null)
           {
               foreach (ShareThread thread in Model.Records)
               {%>
        <tr class="tn-table-grid-row">
         <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input type="checkbox" name="ManageSharesCheckBoxGroup" class="tn-checkbox" value="<%=thread.ThreadID%>" />
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-width-auto">
                        <a href="<%=SiteUrls.Instance().ShowShareThread(thread.ThreadID)%>"
                            target="_blank" title="<%=thread.Subject %>">
                            <%=StringUtils.Trim(thread.Subject ,20) %></a>
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                    <% if (thread.UserID > 0)
                       { %>
                        <a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            target="_blank" title="点击查看<%=thread.Author %>的个人空间">
                            <%=thread.Author%></a>
                    <%}
                       else
                           Response.Write(thread.Author); %>
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=thread.GetMultilingualShareTypeName(CurrentUserLanguage)%> 
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%SiteCategory sitecategory = SiteCategories.Instance(ApplicationIDs.Instance().Share()).Get(thread.SiteCategoryID, true);
                          if (sitecategory != null) Response.Write(sitecategory.CategoryName);%>
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                        <%=thread.UserCount %>
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                        <%=thread.HitTimes%>
                    </td>
         <td class="tn-border-gray tn-border-bottom tn-nowrap">
           <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"  menu="#ShareMenuButton_<%=thread.ThreadID %>"> 
             <span class="tn-icon tn-icon-triangle-down"></span> 
             <a  class="tn-action-text nyroModal" name="editButton" href="<%=SPBUrlHelper.Action("Control_EditShareThread","ChannelShare",new RouteValueDictionary{{"threadID",thread.ThreadID}})%>">编辑</a>
           </span>
           <div id="ShareMenuButton_<%=thread.ThreadID %>" class="tn-drop-menu ui-widget-content" style="display:none;">
             <ul class="tn-menu-drop-list">
               <li class="tn-menu-drop-item"><a name="ShareManagerCommend" class="nyroModal" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Share(),thread.UserID,thread.ThreadID,thread.Subject) %>">推荐</a></li>
               <li class="tn-menu-drop-item"><a onclick="if(!confirm('确认要删除这个分享么？'))return false;"
                                 href="<%=Url.Action("DeleteShareThread","ManageShare",new{threadID=thread.ThreadID,returnUrl=Request.RawUrl}) %>" href="javascript:;">删除</a></li>
             </ul>
           </div>
         </td>
        </tr>
        <%}
           } %>
      </table>
      <div class="tn-pagination tn-helper-align-center">
           <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex)%> 
           <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>            
       </div>
    </form>
  </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#SearchSharesForm").validate({
            rules: {
                userID: { digits: true }
            },
            messages: {
                userID: { digits: "请输入非负整数" }
            }
        });

        $("#searchButton").click(function() {
            if (!$("#SearchSharesForm").valid()) {
                return false;
            }
        });

        $("a[name='editButton']").nyroModal({
            resizeable: true
        });
        $('a[name="ShareManagerCommend"]').nyroModal({
            resizeable: true,
            height: 350,
            width: 400
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    }); 
 </script>
</asp:content>
