﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ManageViewPage<PagingDataSet<VoteComment>>" %>

<asp:content id="pageNameContent" contentplaceholderid="pageNameContent" runat="server">
    投票评论管理
</asp:content>
<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Vote-ManageVoteComments"
</asp:content>
<asp:content runat="server" contentplaceholderid="HeaderContent">
 <% ViewData["VoteSubMenu"] = VoteSubMenu.ManageVoteComment;
    Html.RenderPartial("Controls/Votes/VoteSubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="wideContent" runat="server">
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       if (messageType == StatusMessageType.Success)
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
       else
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
       TempData["StatusMessageType"] = null;
   }

   int presentAreaID = Request.QueryString.GetInt("presentAreaID", (int)PresentAreaIDs.Instance().UserDomain());
   AuditingStatusesForDisplay auditingStatusForDisplay = ViewData.Get<AuditingStatusesForDisplay>("AuditingStatusForDisplay", AuditingStatusesForDisplay.Success);
   string rootAreaCode = EventConfiguration.Instance().RootAreaCode;
   int areaDepth = EventConfiguration.Instance().AreaLevel - 1;%>
<form id="SearchVoteCommentsForm" action="<%=Url.Action("SearchComments","ManageVote",new {auditingStatusForDisplay = auditingStatusForDisplay,presentAreaID=presentAreaID}) %>" method="post">
    <div class="tn-form-box tn-border-gray tn-border-bottom">
        <table>
            <tr>
                <th>
                    内容关键字：
                </th>
                <td>
                    <input name="bodyKeyWords" id="bodyKeyWords" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=Request.QueryString.GetString("bodyKeywords",string.Empty) %>" />
                </td>
                <th>
                    用户ID
                </th>
                <td>
                     <input name="userID" type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userID" value="<%=Request.QueryString.GetString("ownerID", string.Empty) %>" />
                </td>
                <td>    
                          <input type="submit" id="searchButton"  value="<%=GetResourceString("Button_Search")%>" />                      
               </td>
            </tr>
        </table>
    </div>
 </form>

<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Success) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageVoteComments", "ManageVote", new {presentAreaID=presentAreaID, auditingStatusesForDisplay = AuditingStatusesForDisplay.Success,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>" target="_self" style="cursor: pointer"><span>已通过审核</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Pending) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageVoteComments", "ManageVote", new {presentAreaID=presentAreaID,  auditingStatusesForDisplay = AuditingStatusesForDisplay.Pending,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>待审核</span></a></li>
     <li class="tn-widget-content tn-border-gray tn-border-trl <% if(auditingStatusForDisplay==AuditingStatusesForDisplay.Fail) Response.Write(" tn-tabs-selected"); %>"> <a href="<%=Url.Action("ManageVoteComments", "ManageVote", new {presentAreaID=presentAreaID, auditingStatusesForDisplay = AuditingStatusesForDisplay.Fail,bodyKeywords=Request.QueryString.GetString("bodyKeywords",string.Empty),UserID=Request.QueryString.GetString("UserID",string.Empty)})%>"> <span>未通过审核</span></a></li>
   </ul>
   <div class="tn-tabs-panel tn-widget-content tn-border-gray">
     <form id="ManageVotePostsForm" method="post">
       <table class="tn-table-grid">
         <div class="tn-list-header">
         <div class="tn-toolbar-area tn-helper-clearfix">
           <%=SPBHtmlHelper.Instance().LinkButton("SetIsPassButton", "通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","$('#ManageVotePostsForm').attr('action','"+Url.Action("SetCommentAuditingStatus","ManageVote",
                   new {auditingStatuses=AuditingStatuses.Success,presentAreaID=presentAreaID,returnUrl= Request.RawUrl})+"'); $('#ManageVotePostsForm').submit();return false;"},{"title","把选中的投票评论通过审核"}}, null)%>
           <%=SPBHtmlHelper.Instance().LinkButton("SetNotPassButton", "不通过审核", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText,
                   new RouteValueDictionary { { "onclick", "$('#ManageVotePostsForm').attr('action','" + Url.Action("SetCommentAuditingStatus", "ManageVote", new { auditingStatuses = AuditingStatuses.Fail, presentAreaID = presentAreaID, returnUrl = Request.RawUrl }) + "'); $('#ManageVotePostsForm').submit();return false;" }, { "title", "把选中的投票评论不通过审核" } }, null)%>
           <%=SPBHtmlHelper.Instance().LinkButton("DeleteVotes", "删除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary{{"onclick","if (confirm('确认要删除这些评论吗？')){$('#ManageVotePostsForm').attr('action','"+Url.Action("DeleteComments","ManageVote",
                   new {presentAreaID=presentAreaID,returnUrl= Request.RawUrl})+"'); $('#ManageVotePostsForm').submit();return false;}"},{"title","删除选中的评论"}}, null)%>
         </div>
       </div>
         <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom">
                       <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'CheckBoxGroup')" />
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        评论者ID
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Body")%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        评论者
                    </th>
                     <th class="tn-border-gray tn-border-bottom tn-text-note">
                        评论对象
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        评论时间
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        操作
                    </th>
                </tr>
         <% if (Model != null)
            {
                foreach (VoteComment comment in Model.Records)
                {%>
         <tr class="tn-table-grid-row">
               <td class="tn-border-gray tn-border-bottom tn-width-check">
                       <input type="checkbox" name="CheckBoxGroup" class="tn-checkbox" value="<%=comment.CommentID %>" />
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                   <%=comment.UserID%>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-auto">
                   <%=HtmlUtils.TrimHtml( comment.Body,25)%>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
               <% if (comment.UserID > 0)
                  { %>
                   <a href="<%=SiteUrls.Instance().UserChannelHome(comment.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                       target="_blank" title="点击查看的个人空间">
                       <%=comment.Author%></a>
               <%}
                  else
                      Response.Write(comment.Author); %>
               </td>
               <td class="tn-border-gray tn-border-bottom tn-width-auto">
                        <%VoteThread thread = VoteThreads.GetThread(comment.ThreadID, false);
                          if (thread != null)
                          {
                              string url = string.Empty;
                              if (presentAreaID == PresentAreaIDs.Instance().UserDomain())
                                  url = SiteUrls.Instance().ShowVoteThread(thread.ThreadID);
                              else if (presentAreaID == PresentAreaIDs.Instance().ClubDomain())
                                  url = SiteUrls.Instance().ShowClubVoteThread(ClubID2ClubNameDictionary.GetClubDomainName(thread.OwnerID), thread.ThreadID);

                              Response.Write("<a href=\"" + url + "\" target=\"_blank\">" + StringUtils.Trim(thread.Subject, 10) + "</a>");
                          }
                          else
                              Response.Write("评论对象不存在或已被删除"); %>
                    </td>
               <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap">
                    <%= Formatter.FormatDate(comment.DateCreated, true)%>
                    </td>
               <td class="tn-border-gray tn-border-bottom tn-nowrap">
                 <span class="tn-action"><a class="tn-action-text" onclick="if (confirm('确定要删除该评论吗？')) {window.location= '<%=this.Url.Action("DeleteComment", "ManageVote", new {presentAreaID=presentAreaID, commentID =comment.CommentID,returnUrl= Request.RawUrl })%>'};">删除</a> </span>
               </td>
              </tr>
         <%}
            } %>
       </table>
       <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
        <div class="tn-page-results tn-text-note"> 共 <%=Model.TotalRecords %>个</div>
       </div>
     </form>
   </div>
</div>
     <script type="text/javascript">
         $(document).ready(function () {
             $("#SearchVoteCommentsForm").validate({
                 rules: {
                     userID: { digits: true }
                 },
                 messages: {
                     userID: { digits: "请输入非负整数" }
                 }
             });

             $("#searchButton").click(function () {
                 if (!$("#SearchVoteCommentsForm").valid()) {
                     return false;
                 }
             });
         }); 

    </script>
</asp:content>
