﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().MicroBlog();

    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();',2000)</script>"));
        }
        TempData["statusMessageData"] = null;
    }
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30">
</spb:Script>
<form id="EditUserTag" class="tn-helper-reset artDialog" action="<%=SPBUrlHelper.Action("CreateUserTagInModal","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
method="post">
<div class="tn-form tn-form-single">
    <input type="text" name="tagName" id="tagName" class="tn-textbox tn-input-medium tn-border-gray"
        maxlength="12" />
    <%=SPBHtmlHelper.Instance().SubmitButton("newUserTagSubmitButton", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserTag").validate({
            rules: {
                tagName: { required: true, rangelength: [1, 12] }
            },
            messages: {
                tagName: { required: "请填写标签名", rangelength: "标签名不超过12个字符" },
            }
        });
        $("#newUserTagSubmitButton").click(function() {
            if (!$("#EditUserTag").valid()) {
                return false;
            }
        });
    }); 
</script>

