﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<MicroBlogScreen>" %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      if (messageType == StatusMessageType.Success)
      {
          //关闭模式窗口
          Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();refresh();',0)</script>"));
      }
      else
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

      TempData["StatusMessageType"] = null;
      TempData["StatusMessageContent"] = null;
  }
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
%>
<form id="EditUserGroupForm" action="<%=  SPBUrlHelper.Action("UpdateScreen", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>"
class="artDialog" method="post" class="tn-helper-reset">

<div class="tn-form tn-label-right spb-apply-screen">
  <div class="tn-form">
    <div class="tn-form-row">
      <label class="tn-form-label"> 名称：</label>
      <input type="text" name="ScreenName" value="<%=Model.ScreenName %>" class="tn-textbox tn-input-medium tn-border-gray" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 关联话题：</label>
      <input type="text" name="Keyword" value="<%=Model.Keyword %>" class="tn-textbox tn-input-medium tn-border-gray" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 启用筛选：</label>
      <input type="radio" value="true" name="IsFilter" <% if (Model.IsFilter) Response.Write("checked=\"checked\""); %> class="radiobutton" id="IsFilter_t" />
      <label for="IsFilter_t">是</label>
      <input type="radio" value="false" <% if (!Model.IsFilter) Response.Write("checked=\"checked\""); %> name="IsFilter" id="IsFilter_f" class="radiobutton" />
      <label for="IsFilter_f">否</label>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> 设置起止时间：</label>
      <input type="radio" value="true" name="IsDeadline" id="IsDeadline_t" class="radiobutton"
                <% if (Model.IsDeadline) Response.Write("checked=\"checked\""); %> />
      <label for="IsDeadline_t">是</label>
      <input type="radio" value="false" name="IsDeadline" id="IsDeadline_f" class="radiobutton"
                    <% if (!Model.IsDeadline) Response.Write("checked=\"checked\""); %> />
      <label for="IsDeadline_f">否</label>
    </div>
    <div class="tn-date">
      <div id="dateGroup">
        <div class="tn-form-row">
          <label class="tn-form-label"> 开始时间：</label>
          <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("startDate", null, null, Model.StartDate, true, "tn-textbox tn-input-medium tn-border-gray")); %>
        </div>
        <div class="tn-form-row">
          <label class="tn-form-label"> 截止时间：</label>
          <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("endDate", null, null, Model.EndDate, true, "tn-textbox tn-input-medium tn-border-gray")); %>
        </div>
      </div>
    </div>
    <div class="tn-form-row tn-form-row-button tn-bg-gray tn-border-gray tn-border-top"> <%=SPBHtmlHelper.Instance().SubmitButton("","确定",ButtonSizes.Default,null,null) %> <%=SPBHtmlHelper.Instance().Button("", "取消", ButtonSizes.Default, HighlightStyles.Secondary, null, new RouteValueDictionary { { "class", "dialogClose" } })%> </div>
  </div>
</div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserGroupForm").validate({
            rules: {
                ScreenName: { required: true, maxBlength: 64 },
                Keyword: { required: true, maxBlength: 64 }
            },
            messages: {
                GroupName: { required: "分组名不能为空！", maxBlength: "最大长度不能超过64个字符！" },
                Keyword: { required: "关联话题不能为空!", maxBlength: "最大长度不能超过64个字符！" }

            }
        });
        
        if ($('#IsDeadline_t').is(':checked')) {
            $('#dateGroup').show();
        }
        else if ($('#IsDeadline_f')) {
            $('#dateGroup').hide();
        }

        $('#IsDeadline_t').click(function() {
            $('#dateGroup').show();
        });

        $('#IsDeadline_f').click(function() {
            $('#dateGroup').hide();
        });
    });
</script>
