﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserCategory>" %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      if (messageType == StatusMessageType.Success)
      {
          //关闭模式窗口
          Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();refresh();',0)</script>"));
      }
      else
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

      TempData["StatusMessageType"] = null;
      TempData["StatusMessageContent"] = null;
  }
  if (Model != null)
  {
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
%>

<form id="EditUserGroupForm" action="<%=SPBUrlHelper.Action("UpdateUserGroup","MicroBlog",new RouteValueDictionary{{ "userDomainName", userDomainName },{"gid",Model.CategoryID}}) %>"
class="artDialog" method="post">
  <div class="tn-form spb-create-group">
    <div class="tn-form-row">
      <label class="tn-form-label"> 分组名：</label>
      <input type="text" name="GroupName" value="<%=Model.CategoryName %>" class="tn-textbox tn-input-medium tn-border-gray" />
    </div>
    <div class="tn-form-row tn-form-row-button tn-bg-gray tn-border-gray tn-border-top">
      <%=SPBHtmlHelper.Instance().SubmitButton("","确定",ButtonSizes.Default,null,null) %> <%=SPBHtmlHelper.Instance().Button("", "取消", ButtonSizes.Default, HighlightStyles.Secondary, null, new RouteValueDictionary { { "class", "dialogClose" } })%> </div>
  </div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserGroupForm").validate({
            rules: {
                GroupName: { required: true, maxBlength: 20 }
            },
            messages: {
                GroupName: { required: "分组名不能为空！", maxBlength: "最大长度不能超过20个字符！" }
            }
        });
    });
</script>
<%}%>
