﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserIdentifier>>" %>
<spb:Script runat="server" ID="autoSuggest" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<% string controlName = Html.GetParameterFromRouteDateOrQueryString("controlName");
   if (string.IsNullOrEmpty(controlName))
       controlName = "friendSelector";
   int selectionLimit = Html.GetParameterFromRouteDateOrQueryString<int>("selectionLimit");
   string selectionAdded = Html.GetParameterFromRouteDateOrQueryString("selectionAdded");
   if (selectionLimit == default(int))
       selectionLimit = 30;
   string getAllFriendsUrl = SPBUrlHelper.Action("GetMyFollows", "MicroBlog");
   string searchFriendsUrl = SPBUrlHelper.Action("SearchFollows", "MicroBlog");
   string getFriendCategoriesUrl = SPBUrlHelper.Action("GetMyFollowCategories", "MicroBlog");
   string selectedUsersValue = "{}";
   string inputClass = Html.GetParameterFromRouteDateOrQueryString("inputClass");
   if (string.IsNullOrEmpty(inputClass))
       inputClass = "tn-input-long";

   System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
   if (Model != null && Model.Count > 0)
   {
       selectedUsersValue = serializer.Serialize(Model.Select(n => new
       {
           userID = n.UserID,
           displayName = n.DisplayName,
           commonName = n.CommonName,
           nickName = n.NickName,
           userAvatarUrl = SiteUrls.Instance().UserAvatarUrl(n.UserID, AvatarSizeTypes.Small)
       }));
   }   
%>
<div class="tn-expand-control">
    <input id="<%=controlName %>" type="text" />
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#<%=controlName %>").autoSuggest("<%=searchFriendsUrl %>",
        {   asHtmlID: "<%=controlName %>",
            startText: "",
            defaultCategory:"全部",
            buttonText: "<%=GetResourceString("Button_OK") %>",
            limitTextPattern: '<%="最多只能添加{0}个好友" %>',
            remainTextPattern: '<%="您还可以选择{0}被关注用户" %>',
            selectionLimit: <%=selectionLimit %>,
            preFill: <%=selectedUsersValue %>,
            allSelectData: "<%=getAllFriendsUrl %>",
            categoryData: "<%=getFriendCategoriesUrl %>",            
            selectedItemProp: "displayName",
            selectedValuesProp: "followID",
            searchObjProps: "displayName,commonName,nickName,noteName",
            formatList: function(data, elem) {
            var new_elem = elem.html("<a href=\"javascript:;\"><img src=\"" + data.userAvatarUrl + "\" width=\"22px\">" + data.displayName + "</a>");
                return new_elem;
            }
            <%if(!string.IsNullOrEmpty(selectionAdded)){%>
            ,
            selectionAdded:<%=selectionAdded %>
            <%} %>
        });
    });
   
</script>

