﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<MicroBlogThread>" %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
      if (messageType == StatusMessageType.Success)
      {
          //关闭模式窗口
          Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();',2000)</script>"));
      }
      TempData["StatusMessageType"] = null;
      TempData["StatusMessageContent"] = null;
  }
  int applicationID = ApplicationIDs.Instance().MicroBlog();
  UserIdentifier author = Users.GetUserIdentifier(Model.UserID);
  if (author == null)
      author = new UserIdentifier();
  MicroBlogThread thread;
  if (Model.OriginalThreadID > 0)
      thread = Model.GetOriginalThread;
  else
      thread = Model;
%>
<form id="microBlogForwardForm_<%=thread.ThreadID %>" name="microBlogForwardForm"
class="artDialog" action="<%=SPBUrlHelper.Action("ForwardMicroBlog","MicroBlog")%>"
method="post">
<div class="spb-reprint-form">
    <div class="tn-form tn-label-top">
        <p>
            <strong>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(thread.UserID) %>">
                    <%=thread.Author %></a></strong></p>
        <p>
            <%=thread.ForwardBody %></p>
        <div class="tn-form-row tn-emotion-box tn-textarea-wrap">
            <label class="tn-form-label tn-text-note">
                <%=GetResourceString("Title_WriteMyMicroBlog",applicationID)%><%=GetResourceString("Common_Colon")%></label>
            <div class="tn-emotion-button">
                <a id="addSmiley_<%=thread.ThreadID %>" href="javascript:;">
                    <span class="tn-icon tn-icon-emotion"></span>
                </a>
            </div>
            <%Html.RenderAction<MicroBlogController>(n => n.Control_SmileySelector(thread.ThreadID.ToString(), "forwardBody_" + thread.ThreadID.ToString()));%>
            <textarea class="tn-textarea tn-input-longest tn-border-gray" rows="" cols="" id="forwardBody_<%=thread.ThreadID %>"
                name="microBlogBody"><%=GetResourceString("Title_ForwardMicroBlog",applicationID)%><%if (Model.OriginalThreadID > 0 && !String.IsNullOrEmpty(Model.ForwardBody)) { Response.Write("//@" + author.UserName + "：" + Model.ForwardBody); } %></textarea>
            <span style="display:none"></span>
        </div>
        <div class="tn-form-row">
            <input type="checkbox" class="tn-checkbox" value="true" name="Comment" id="Comment" />
            <input type="hidden" id="threadID" name="threadID" value="<%=Model.ThreadID %>" />
            <label for="Comment">
                <%=string.Format(GetResourceString("Title_ToHisComment",applicationID),Model.Author)%></label>
            <span class="tn-count tn-helper-right" id="NoteOfThread_f_<%=thread.ThreadID %>">
                <%=GetResourceString("Message_Toenter", applicationID)%><strong id="SurplusOfFThread_f_<%=thread.ThreadID %>">140</strong><%=GetResourceString("Message_Word", applicationID)%>
            </span>
        </div>
        <%if (Model.OriginalThreadID > 0 && thread.UserID != CurrentUser.UserID)
          {%>
        <div class="tn-form-row">
            <input type="checkbox" class="tn-checkbox" value="true" name="OriginalComment" id="OriginalComment" />
            <label for="OriginalComment">
                <%=string.Format(GetResourceString("Title_ToHisComment", applicationID), thread.Author)%></label>
        </div>
        <%} %>
        <div class="tn-form-row tn-form-row-button">
            <%=SPBHtmlHelper.Instance().SubmitButton("editorFormsaveButton", GetResourceString("Action_Forward",applicationID), ButtonSizes.Default, null, null)%>
            <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, null, new RouteValueDictionary { {"class", "dialogClose" } })%>
        </div>
    </div>
</div>
</form>

<script type="text/javascript">
$(document).ready(function() {
    $("#microBlogForwardForm_<%=thread.ThreadID %>").validate({
        rules: {
            microBlogBody: { required: true, maxBlength: 140 }
        },
        messages: {
            microBlogBody: { required: "必须填写转发内容", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_BodyMaxLength", ApplicationIDs.Instance().MicroBlog()), 140)%>" }
        }
    });

    $("#editorFormsaveButton").click(function() {
        if (!$("#microBlogForwardForm_<%=thread.ThreadID %>").valid()) {
            return false;
        }
    });
        
    $("#forwardBody_<%=thread.ThreadID %>").focus(function() {
       countInterval = setInterval(function(){ count(); },360);
    }).blur(function() {
        clearInterval(countInterval);
        count();
    }).focus();     
});
function count()
{
    var length = 140 - blength($("#forwardBody_<%=thread.ThreadID %>").val());
    if(length < 0) {
      length = -length;
      $("#NoteOfThread_f_<%=thread.ThreadID %>").html('<%=GetResourceString("Message_Beyond",applicationID)%><b>' + length + '</b><%=GetResourceString("Message_Word", applicationID)%>');
    }
    else
       $("#NoteOfThread_f_<%=thread.ThreadID %>").html('<%=GetResourceString("Message_Toenter",applicationID)%><strong>' + length + '</strong><%=GetResourceString("Message_Word", applicationID)%>');
}
function blength(value)
{
    return parseInt((value.replace(/[^\x00-\xff]/g, "**").length+1)/2);
}     
</script>

