﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
  User currentDomainUser = Users.GetUser(userDomainName, false);
  int notReadMessageCount = 0;
  int userApplicationID = ApplicationIDs.Instance().User();
  int unsettledInvitationTotalCount = 0;
  int notReadNoticeCount = 0;
  int applicationID = ApplicationIDs.Instance().MicroBlog();
  if (CurrentUser != null)
  {
      //获取未读消息
      notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

      //获取未处理邀请字典集合
      Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

      foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
      {
          unsettledInvitationTotalCount += pair.Value;
      }
      notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
  }
  int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
  IList<Navigation> list = Navigations.GetDefaultNavgitions(PresentAreaIDs.Instance().Channel(), false);

  int currentUserPresentAreaID = PresentAreaIDs.Instance().UserDomain();
  if (CurrentUser != null && CurrentUser.UserType == UserTypes.CompanyUser)
      currentUserPresentAreaID = PresentAreaIDs.Instance().CompanyUserDomain();
%>
<div class="spb-top-menubar">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-home-link">
            <a class="spb-top-logo-link" href="<%=SiteUrls.Instance().Home() %>" target="_blank">
                返回总站</a>
        </div>
        <div class="spb-user-menu">
            <ul class="sf-menu sf-js-enabled sf-shadow">
                <li>
                    <%if (CurrentUser != null)
                      {%>
                    <a href="<%=SPBUrlHelper.Action("Logout","MicroBlog")%>">
                        <%=GetResourceString("Action_Logout")%></a>
                    <%}
                      else
                      { %>
                    <a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                        <%=GetResourceString("Action_Login")%></a>
                    <%} %>
                </li>
                <% if (CurrentUser != null)
                   { %>
                <li>
                    <a href="<%=SPBUrlHelper.Action("ListNotices", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                        通知</a>
                    <%if (notReadNoticeCount > 0)
                      { %>
                    <span class="tn-msg-bubble">
                        <span class="tn-img-sprite tn-msg-bubble-left"></span>
                        <span class="tn-img-sprite tn-msg-bubble-center">
                            <a href="<%=SPBUrlHelper.Action("ListNotices", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                                <%=notReadNoticeCount%></a></span><span class="tn-img-sprite tn-msg-bubble-right"></span></span>
                    <%} %>
                </li>
                <li>
                    <a href="<%=SPBUrlHelper.Action("ListMessageInBox", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                        私信</a>
                    <%if (notReadMessageCount > 0)
                      { %>
                    <span class="tn-msg-bubble">
                        <span class="tn-img-sprite tn-msg-bubble-left"></span>
                        <span class="tn-img-sprite tn-msg-bubble-center">
                            <a href="<%=SPBUrlHelper.Action("ListMessageInBox", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                                <%=notReadMessageCount%></a></span><span class="tn-img-sprite tn-msg-bubble-right"></span></span>
                    <%} %>
                </li>
                <%if (CurrentUser.UserType != UserTypes.CompanyUser)
                  { %>
                <li>
                    <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                        帐号设置</a>
                </li>
                <%} %>
                <li>
                    <a href="<%=SiteUrls.Instance().UserDomainHome(CurrentUser) %>">
                        <%=CurrentUser.DisplayName%></a>
                </li>
                <%} %>
            </ul>
        </div>
    </div>
</div>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner">
        <div id="spb-logo">
            <a href="<%=SPBUrlHelper.Action("MicroBlogRanks", "MicroBlog")%>"></a>
        </div>
    </div>
</div>
<% 
    int subMenu = ViewData.GetInt("MicroBlogDomainSubMenu", -1);
    if (CurrentUser != null)
    { %>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav1 tn-helper-reset">
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.MyMicroBlogHome) Response.Write("tn-selected");%>">
                <a href="<%=SiteUrls.Instance().UserMicroBlogHome(CurrentUser.UserID) %>">
                    <span>
                        <%=GetResourceString("Navigation_MyMicroBlogHome", applicationID)%></span></a></li>
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.News) Response.Write("tn-selected");%>">
                <a href="<%=SPBUrlHelper.Action("MicroBlogRanks","MicroBlog") %>">
                    <span>广场</span></a></li>
            <%PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().MicroBlogDomain(), false);
              if (presentArea != null && presentArea.EnableThemes)
              {    
            %>
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.CustomDress) Response.Write("tn-selected");%>">
                <a href="<%=SPBUrlHelper.Action("ModifyHome","MicroBlog",new RouteValueDictionary{{"userDomainName",CurrentUser!=null?CurrentUser.UserName:string.Empty}})%>">
                    <span>模板</span></a></li>
            <%} %>
        </ul>
        <div class="tn-search-box">
            <form id="SearchMicroBlogs" action="<%=SPBUrlHelper.Action("SearchMicroBlogs","MicroBlog") %>"
            method="get">
            <input type="text" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"
                value="" name="keyword" id="keyword" />
            <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                <button onclick="$('#SearchMicroBlogs').submit();">
                    <span class="tn-icon tn-icon-find"></span>
                </button>
            </span>
            </form>
        </div>
    </div>
</div>
<%}
    else
    { %>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav1 tn-helper-reset">
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.MyMicroBlogHome) Response.Write("tn-selected");%>">
                <a href="<%=SiteUrls.Instance().MicroBlogHome() %>">
                    <span>
                        <%=GetResourceString("Navigation_MyMicroBlogHome", applicationID)%></span></a></li>
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.News) Response.Write("tn-selected");%>">
                <a href="<%=SPBUrlHelper.Action("MicroBlogRanks","MicroBlog") %>">
                    <span>广场</span></a></li>
            <li class="spb-nav-item <%if (subMenu == (int)MicroBlogDomainSubMenu.CustomDress) Response.Write("tn-selected");%>">
                <a href="<%=SiteUrls.Instance().MicroBlogHome() %>">
                    <span>模板</span></a></li>
        </ul>
        <div class="tn-search-box">
            <input type="text" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"
                value="" name="keyword" />
            <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                <button onclick="window.location.href='<%=SiteUrls.Instance().MicroBlogHome() %>'">
                    <span class="tn-icon tn-icon-find"></span>
                </button>
            </span>
        </div>
    </div>
</div>
<%} %>

<script type="text/javascript">
    $(document).ready(function() {
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 400             
            });
        $("#keyword").watermark("<%=GetResourceString("Message_SreachDescription", applicationID) %>");
     if(<%=totalCount %> > 0)
      newMessageHint('<%=GetResourceString("Description_NewMessage")%>');

    });  
</script>

