﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogFollow>>" %>
<%  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    User domainUser = Users.GetUser(userDomainName, false);
    domainUser = domainUser == null ? domainUser = new User() : domainUser;
    MicroBlogFollowSortBy sortBy = (MicroBlogFollowSortBy)ViewData.GetInt("sortBy");
    int applicationID = ApplicationIDs.Instance().MicroBlog();
    bool isOwner = CurrentUser != null && CurrentUser.UserID == domainUser.UserID;
    MicroBlogUserData userData = MicroBlogUserDatas.GetUserData(domainUser.UserID, isOwner);
    List<UserCategory> hideGroups = ViewData["hideGroups"] as List<UserCategory>;
    List<UserCategory> defaultGroups = ViewData["defaultGroups"] as List<UserCategory>;
    List<UserCategory> groups = ViewData["groups"] as List<UserCategory>;
    int gid = Request.QueryString.GetInt("gid", 0);
    int pageIndex = Request.QueryString.GetInt("pageIndex", 0);
%>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-border-gray tn-border-bottom">
        <strong>
            <%if (sortBy == MicroBlogFollowSortBy.FollowUser)
                  Response.Write(string.Format(GetResourceString("Title_FollowUser", applicationID), domainUser.DisplayName, userData != null ? userData.FollowCount : 0));
              else
                  Response.Write(string.Format(GetResourceString("Title_Follower", applicationID), Model != null ? Model.TotalRecords : 0, domainUser.DisplayName)); %></strong></div>
    <%  if (sortBy == MicroBlogFollowSortBy.FollowUser)
        {%>
    <div class="tn-border-bottom spb-fans-filter tn-helper-clearfix">
        <span class="tn-action tn-action-text-icon">
            <span class="tn-icon tn-icon-add"></span>
            <a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditUserGroup","MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"
                id="CreateUserGroup">创建分组</a>
        </span>
        <ul class="sf-menu sf-js-enabled sf-shadow">
            <li <%if (gid == 0) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFollow", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "sortBy", sortBy } })%>">
                    所有分组</a></li>
            <li <%if (gid < 0) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFollow", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "sortBy", sortBy },{"gid",-1} })%>">
                    未分组</a></li>
            <% if (defaultGroups != null && defaultGroups.Count > 0)
               {
                   foreach (var defaultGroup in defaultGroups)
                   {%>
            <li <%if (gid == defaultGroup.CategoryID) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a title="<%=defaultGroup.CategoryName %>" href="<%=SPBUrlHelper.Action("ListFollow", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "sortBy", sortBy },{"gid",defaultGroup.CategoryID} })%>">
                    <%=StringUtils.Trim(defaultGroup.CategoryName,5)%></a></li>
            <%}
               } if (hideGroups != null && hideGroups.Count > 0)
               {%>
            <li>
                <a class="sf-with-ul" href="javascript:;">更多<span class="tn-icon tn-icon-triangle-down">»</span></a>
                <ul style="display: none; visibility: hidden;" class="tn-widget-content tn-border-gray">
                    <% foreach (var hideGroup in hideGroups)
                       {%>
                    <li title="<%=hideGroup.CategoryName %>" <%if (gid == hideGroup.CategoryID) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                        <a href="<%=SPBUrlHelper.Action("ListFollow", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "sortBy", sortBy },{"gid",hideGroup.CategoryID} })%>">
                            <%=StringUtils.Trim(hideGroup.CategoryName,5)%></a></li>
                    <%}
                    %>
                </ul>
            </li>
            <%  }  %>
        </ul>
    </div>
    <%if (gid > 0)
      { %>
    <div class="tn-actions tn-bg-gray tn-border-gray tn-border-top">
        <span class="tn-action tn-action-text-icon">
            <span class="tn-icon tn-icon-user"></span>
            <a class="tn-action-text">该分组共<%=Model != null ? Model.TotalRecords : 0%>人</a></span><span
                class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-write"></span><a
                    class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditUserGroup","MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName },{"gid",gid} })%>"
                    id="EditUserGroup">修改分组名称</a></span><span class="tn-action tn-action-text-icon"><span
                        class="tn-icon tn-icon-cross"></span><a class="tn-action-text" onclick="if(!confirm('确认删除当前分组？')) return false;"
                            href="<%=SPBUrlHelper.Action("DeleteUserGroup","MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName },{"gid",gid} }) %>">删除分组</a></span><span
                                class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-microblog"></span><a
                                    class="tn-action-text" href="<%=SPBUrlHelper.Action("MyMicroBlogHome", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName},{"gid",gid}})%>">浏览该分组微博</a></span></div>
    <form action="<%=SPBUrlHelper.Action("BatchSetFollowsToGroup", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName},{"gid",gid}})%>"
    method="post">
    <div class="tn-form spb-organize-follower">
        <div class="tn-form-row tn-helper-clearfix">
            <label class="tn-form-label">
                将关注人添加到分组：</label>
            <% Html.RenderAction<MicroBlogController>(n => n.Control_FollowSelector("FollowIDs", "", 10)); %>
            <%=SPBHtmlHelper.Instance().SubmitButton("setFollowsGroup", "添加", ButtonSizes.Default, null, null)%>
        </div>
    </div>
    </form>
    <%}
        }%>
</div>
<%if (Model != null)
  {%>
<form action="" method="post" id="followform">
<ul class="tn-list tn-helper-reset" id="ListFollowItems">
    <%foreach (MicroBlogFollow item in Model.Records)
      {
          int userID = sortBy == MicroBlogFollowSortBy.FollowUser ? item.ItemID : item.UserID;
          userData = MicroBlogUserDatas.GetUserData(userID, false);
          List<UserCategory> selectedGroups = MultiUserCategoryManager.Instance(MultiUserCategoryItemKeys.Instance().MicroBlogFollow()).GetUserCategoriesOfItem(item.FollowID, true);
          if (userData != null)
          {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="u_<%=userData.UserID %>">
        
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <a href="<%=SiteUrls.Instance().MyMicroBlogs(userID) %>">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(userID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
        </div>
        <div class="tn-list-item-area-right">
            <%if (groups != null && groups.Count > 0)
              { %>
            <span id="optionButton_<%=item.FollowID%>" class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                menu="#moreOptions_<%=item.FollowID %>">
                <span class="tn-icon tn-icon-triangle-down"></span>
                <%if (selectedGroups == null || selectedGroups.Count <= 0)
                      Response.Write("<a href=\"javascript:;\" class=\"tn-action-text\">未分组</a>");
                  else
                  {
                      int i = 0;
                      StringBuilder strgroups = new StringBuilder();
                      StringBuilder strAllgroups = new StringBuilder();
                      foreach (var selectedGroup in selectedGroups)
                      {
                          if (selectedGroup != null && i < 2)
                          {
                              strgroups.Append(StringUtils.Trim(selectedGroup.CategoryName, 6) + ",");
                              i++;
                          }

                          strAllgroups.Append(selectedGroup.CategoryName + ",");
                      }

                      Response.Write(string.Format("<a href=\"javascript:;\" title=\"{0}\" class=\"tn-action-text\">{1}</a>", strAllgroups.ToString().TrimEnd(','), strgroups.ToString().TrimEnd(',')));
                  }%></span>
            <div id="moreOptions_<%=item.FollowID %>" class="tn-drop-menu ui-widget-content"
                style="display: none;">
                <ul class="tn-menu-drop-list">
                    <%foreach (var group in groups)
                      {%>
                    <li class="tn-menu-drop-item">
                        <label title="<%=group.CategoryName %>">
                            <input class="tn-checkbox" value="true" type="checkbox" <%if (selectedGroups.Exists(n => n.CategoryID == group.CategoryID)) { Response.Write(" checked=\"checked\""); } %>
                                onclick="SetUserGroup('<%=SPBUrlHelper.Action("SetFollowToGroup","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{ "gid", group.CategoryID },{"followID",item.FollowID}}) %>',<%=item.FollowID %>)" />
                            <%=StringUtils.Trim(group.CategoryName,5)%></label>
                    </li>
                    <%} %>
                </ul>
            </div>
            <%} %>
            <% if (CurrentUser != null && CurrentUser.UserID != userID)
               {
                   if (!MicroBlogFollows.IsFollow(CurrentUser.UserID, userID))
                       Response.Write(SPBHtmlHelper.Instance().LinkButton(userID.ToString(), GetResourceString("Action_Follow", applicationID), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "name", "follow" }, { "value", 1 } }, null));
                   else
                       Response.Write(SPBHtmlHelper.Instance().LinkButton(userID.ToString(), GetResourceString("Action_CancelFollow", applicationID), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "name", "follow" }, { "value", 0 } }, null)); %>
            <%} %>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%=SiteUrls.Instance().MyMicroBlogs(userID) %>">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(userData.GetUserIdentifier.UserID,true)%></a></h5>
            </div>
            <div class="tn-list-item-row">
                <%--<cite class="tn-text-note"><a class="tn-location" href="#">家乡</a></cite>--%><em
                    class="tn-count tn-text-note"><%=GetResourceString("Action_Follower", applicationID)%><%if (userData.FollowerCount > 0) Response.Write(userData.FollowerCount); else Response.Write("0");%><%=GetResourceString("Title_People", applicationID)%></em></div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(userID,userData.MostRecentThreadID) %>">
                        <%=HtmlUtils.TrimHtml(userData.MostRecentThreadBody, userData.MostRecentThreadBody.Length)%></a></p>
            </div>
        </div>
    </li>
    <%}
      }%>
</ul>
</form>
<% if (Model != null)
   {%>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFollow", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "sortBy", sortBy }, { "gid", gid }, { "pageIndex", "{0}" }}), "pageIndexChange")%>
</div>
<%} %>

<script type="text/javascript">
    $(document).ready(function() {
        $("a[name=follow]").click(function() {
            var $follow = $(this);
            if ($(this).attr("value") > 0) {
                $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                    $follow.html('<%=GetResourceString("Action_CancelFollow",applicationID)%>').attr("value", 0).parents("span.tn-button").unbind('mouseover').unbind('mouseout').removeClass("tn-button-default-hover tn-button-default").addClass("tn-button-secondary").mouseover(function() {
                        $(this).removeClass('tn-button-secondary').addClass('tn-button-secondary-hover');
                    }).mouseout(function() {
                        $(this).removeClass('tn-button-secondary-hover').addClass('tn-button-secondary');
                    });
                });
            }
            else {
                $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                
                    <%if (sortBy == MicroBlogFollowSortBy.FollowUser)
                    { %>
                        $('#u_'+ $follow.attr("id")).fadeOut();
                    <%}else{ %>
                        $follow.html('<%=GetResourceString("Action_Follow",applicationID)%>').attr("value", 1).parents("span.tn-button").unbind('mouseover').unbind('mouseout').removeClass("tn-button-secondary-hover tn-button-secondary").addClass("tn-button-default").mouseover(function() {
                            $(this).removeClass('tn-button-default').addClass('tn-button-default-hover');
                        }).mouseout(function() {
                            $(this).removeClass('tn-button-default-hover').addClass('tn-button-default');
                        });
                    <%} %>
                });
            }
        });

        $("#setFollowsGroup").click(function() {
            if ($("#as-selections-FollowIDs li[id^='as-selection']").length <= 0 && $('#FollowIDs').val().length <= 0) {
                $(this).show();
                $('#setFollowsGroup_ForHide').hide();

                return false;
            }
        });
        $('#CreateUserGroup').dialog({
            id: 'EditGroupBox',
            title: '创建分组',
            width: 300
        });
        $('#EditUserGroup').dialog({
            id: 'EditGroupBox',
            title: '修改分组',
            width: 300
        });
        $("span[menu]").menuButton();
    });
    function pageIndexChange(url) {
        $('#followform').parent().load(url);
    }
    function SetUserGroup(postUrl, followID) {
        $('#followform').ajaxSubmit({
            url: postUrl,
            dataType: "JSON",
            success: function(data) {
                $("#optionButton_" + followID).find("a.tn-action-text").text(data);
            }
        });
    }
</script>

<%} %>