﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User domainUser = Users.GetUser(userDomainName, false);

   int applicationID = ApplicationIDs.Instance().MicroBlog();
   bool hasManagePermission = (CurrentUser != null) && (CurrentUser.UserID == domainUser.UserID || CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator);%>
<div id="MyComments">
    <div class="spb-my-comments">
        <div class="tn-tabs tn-widget">
            <ul class="tn-tabs-nav tn-helper-clearfix">
                <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
                    <a href="<%=SPBUrlHelper.Action("MyMicroBlogComments", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                        <span>收到的评论</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl">
                    <a href="<%=SPBUrlHelper.Action("MySendMicroBlogComments", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                        <span>发出的评论</span></a></li>
            </ul>
            <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
                <div class="tn-comment-wrap">
                    <ul class="tn-comments">
                        <%if (Model.Records != null && Model.Records.Count > 0)
                          {
                              foreach (MicroBlogComment comment in Model.Records)
                              {%>
                        <li class="tn-comment-item tn-border-gray tn-border-bottom">
                            <div class="tn-comment tn-helper-clearfix">
                                <div class="tn-comment-avatar">
                                    <div class="tn-avatar">
                                        <a href="<%=SiteUrls.Instance().MyMicroBlogs(comment.UserID) %>">
                                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a>
                                    </div>
                                </div>
                                <div class="tn-comment-info">
                                    <%if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator))
                                      { %>
                                    <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment") %>')){ $('#MyComments').load('<%=SPBUrlHelper.Action("DeleteMyMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",comment.ThreadID},{"commentID",comment.CommentID},{"userDomainName",userDomainName}}) %>');}">
                                    </a>
                                    <%} %>
                                    <p class="tn-comments-text">
                                        <a href="<%=SiteUrls.Instance().MyMicroBlogs(comment.UserID) %>" class="tn-author">
                                            <%=SPBHtmlHelper.Instance().UserDisplayName(comment.UserID,true) %>：</a><%=comment.Body %><em
                                                class="tn-date tn-text-note"><a href="<%=SiteUrls.Instance().ShowMicroBlog(comment.OwnerUserID,comment.ThreadID) %>"><%=Formatter.FormatFriendlyDate(comment.DateCreated)%></a></em></p>
                                    <%if (comment.ParentID > 0)
                                      { %>
                                    <p class="tn-comments-from">
                                        <%MicroBlogComment com = MicroBlogComments.GetComment(comment.ParentID, false);
                                          string comBody = string.Empty;
                                          if (com != null)
                                              comBody = com.Body;%>
                                        <span class="tn-text-note">回复我的评论：</span><%=comBody%></p>
                                    <%}
                                      else
                                      { %>
                                    <p class="tn-comments-from">
                                        <span class="tn-text-note">回复我的微博：</span><%=MicroBlogThreads.GetThread(comment.ThreadID,false).Body %></p>
                                    <%} %>
                                    <p class="tn-comments-reply">
                                        <a href="javascript:;" id="reply_<%=comment.CommentID %>" value="<%=comment.CommentID %>"
                                            name="reply">回复</a></p>
                                    <div class="tn-simple-comments" id="ListComments_<%=comment.CommentID %>" style="display: none">
                                        <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                                            <div class="tn-bubble-box-arrow">
                                                <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                                                <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                                                <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                                                <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                                                <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                                            </div>
                                            <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
                                                <form id="microBlogReplyForm_<%=comment.CommentID %>" method="post" action="<%=SPBUrlHelper.Action("CreateMyMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",comment.ThreadID},{"userDomainName",userDomainName},{"parentID",comment.CommentID},{"isSend",false}}) %>">
                                                <div class="tn-comment-form-wrap tn-emotion-box">
                                                    <div class="tn-emotion-button">
                                                        <a id="addSmiley_<%=comment.CommentID%>" href="javascript:;">
                                                            <span class="tn-icon tn-icon-emotion"></span>
                                                        </a>
                                                    </div>
                                                    <%  Html.RenderAction<MicroBlogController>(n => n.Control_SmileySelector(comment.CommentID.ToString(), "commentArea_" + comment.CommentID));%>
                                                    <div class="tn-comment-form">
                                                        <div class="tn-comment-text-wrap tn-widget-content tn-border-light tn-textarea-wrap">
                                                            <textarea id="commentArea_<%=comment.CommentID%>" name="microBlogCommentBody" cols=""
                                                                rows="" class="tn-textarea"><%=TempData.GetString("CommentBody",string.Empty) %></textarea>
                                                                <span style="display:none"></span>
                                                        </div>
                                                        <div class="tn-send-comments">
                                                            <label class="tn-helper-left" for="">
                                                                <input type="checkbox" class="tn-checkbox" name="microBlogForward" value="1">
                                                                同时转发到我的微博</label>
                                                            <span class="tn-count" id="Note_<%=comment.CommentID %>">
                                                                <%=GetResourceString("Message_Toenter", applicationID)%><strong id="Surplus_<%=comment.CommentID %>">140</strong><%=GetResourceString("Message_Word", applicationID)%>
                                                            </span>
                                                            <%=SPBHtmlHelper.Instance().SubmitButton("commentButton_" + comment.CommentID, GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%>
                                                        </div>
                                                    </div>
                                                </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <script type="text/javascript">
                        $(document).ready(function() {             
                            $("#microBlogReplyForm_<%=comment.CommentID %>").validate({
                                 rules: {
                                     microBlogCommentBody: { required: true, maxBlength: 140 }
                                 },
                                 messages: {
                                     microBlogCommentBody: { required: "*", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_BodyMaxLength", ApplicationIDs.Instance().MicroBlog()), 140)%>" }
                                 },
                                 showErrors: $.dialog.showErrors,
                                 onfocusout: false,
                                 onclick: false,
                                 onkeyup:false,
                                 onsubmit:true
                            });
                            if($("#commentArea_<%=comment.CommentID %>"))
                            {
                                $("#commentArea_<%=comment.CommentID %>").focus(function() {
                                   countInterval = setInterval(function(){ count(); },360);
                                }).blur(function() {
                                    clearInterval(countInterval);
                                    count();
                                });
                                function count()
                                {
                                    var length = 140 - blength($("#commentArea_<%=comment.CommentID %>").val());
                                    if (length < 0) {
                                        length = -length;
                                        $("#Note_<%=comment.CommentID %>").html('<%=GetResourceString("Message_Beyond",applicationID)%><b>' + length + '</b><%=GetResourceString("Message_Word", applicationID)%>');
                                    }
                                    else
                                        $("#Note_<%=comment.CommentID %>").html('<%=GetResourceString("Message_Toenter",applicationID)%><strong>' + length + '</strong><%=GetResourceString("Message_Word", applicationID)%>');
                                }    
                            }
                        });
                        </script>

                        <%}
                          }%>
                    </ul>
                    <div class="tn-pagination tn-helper-align-center">
                        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('a[name=reply]').click(function() {
            var $comments = $('#microBlogReplyContainer_' + $(this).attr("value"));
            if ($("#ListComments_" + $(this).attr("value")).is(":hidden")) {
                if ($comments.find("div.tn-loading").length) {
                    $('#microBlogReplyContainer_' + $(this).attr("value")).load($('#microBlogReplyContainer_' + $(this).attr("value")).attr("value"));
                }
                $("#ListComments_" + $(this).attr("value")).show();
                $(this).text('收起回复');
            }
            else {
                $("#ListComments_" + $(this).attr("value")).hide();
                $(this).text('<%=GetResourceString("Common_Reply") %>');
            }
        });
    });
    function blength(value) {
        return parseInt((value.replace(/[^\x00-\xff]/g, "**").length + 1) / 2);
    }
</script>

