﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% MicroBlogThread thread = ViewData["thread"] as MicroBlogThread;
   if (thread == null)
       thread = new MicroBlogThread();

   int applicationID = ApplicationIDs.Instance().MicroBlog();
   if (CurrentUser != null || SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting)
   {%>
<form id="microBlogReplyForm_<%=thread.ThreadID %>" method="post" action="<%=SPBUrlHelper.Action("CreateMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID},{"type",(int)CommentType.TopCommnet}}) %>">
<div class="tn-comment-form-wrap tn-emotion-box" id="textAreaDiv_<%=thread.ThreadID %>">
    <div class="tn-emotion-button">
        <a id="addSmiley_<%=thread.ThreadID %>" href="javascript:;">
            <span class="tn-icon tn-icon-emotion"></span>
        </a>
    </div>
    <%  Html.RenderAction<MicroBlogController>(n => n.Control_SmileySelector(thread.ThreadID.ToString(), "commentArea_" + thread.ThreadID));%>
    <div class="tn-comment-form">
        <div class="tn-comment-text-wrap tn-widget-content tn-border-light tn-textarea-wrap">
            <textarea id="commentArea_<%=thread.ThreadID %>" name="microBlogCommentBody" cols=""
                rows="" class="tn-textarea"><%=TempData.GetString("CommentBody",string.Empty) %></textarea>
                <span style="display:none"></span>
        </div>
        <div class="tn-send-comments">
            <label for="microBlogForward" class="tn-helper-left">
                <input type="checkbox" class="tn-checkbox" name="microBlogForward" value="1" id="microBlogForward" />
                同时转发到我的微博</label>
            <input type="hidden" name="commentID" id="cmtID_<%=thread.ThreadID %>" />
            <span class="tn-count" id="NoteOfThread_<%=thread.ThreadID %>">
                <%=GetResourceString("Message_Toenter", applicationID)%><strong id="SurplusOfThread_<%=thread.ThreadID %>">140</strong><%=GetResourceString("Message_Word", applicationID)%>
            </span>
            <%=SPBHtmlHelper.Instance().SubmitButton("commentButton_" + thread.ThreadID, GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%>
        </div>
    </div>
</div>
</form>
<% if (TempData["StatusMessageData"] != null)
   {
       StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, ""));
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 7000, false));
       TempData["StatusMessageData"] = null;
   }
   }
   else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"))); }%>
<div class="tn-comment-wrap">
    <ul class="tn-comments">
        <% if (Model != null)
           {
               foreach (var comment in Model)
               { %>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(comment.UserID) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID,false, HyperLinkTarget._blank,  AvatarSizeTypes.Small)%>
                        </a>
                    </div>
                </div>
                <div class="tn-comment-info">
                    <%if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator))
                      { %>
                    <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment") %>')){ $('#microBlogReplyContainer_<%=thread.ThreadID %>').load('<%=SPBUrlHelper.Action("DeleteMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID},{"commentID",comment.CommentID},{"type",CommentType.TopCommnet}}) %>');}"">
                    </a>
                    <%} %>
                    <p class="tn-comments-text">
                        <a class="tn-author" href="<%=SiteUrls.Instance().UserMicroBlogHome(comment.UserID) %>">
                            <%=comment.Author%>：</a>
                        <%=comment.Body%>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatFriendlyDate(comment.DateCreated)%></em></p>
                    <%if (CurrentUser.UserID != comment.UserID)
                      {%>
                    <p class="tn-comments-reply">
                        <%User ReplayUser = Users.GetUser(comment.UserID, false);
                          string Runame = string.Empty;
                          if (ReplayUser != null)
                              Runame = ReplayUser.UserName;
                        %>
                        <a href="javascript:;" name="CommentReply" value="<%=Runame%>" commid="<%=comment.CommentID %>">
                            回复</a></p>
                    <%} %>
                </div>
            </div>
        </li>
        <%} %>
        <%}%>
    </ul>
    <%if (Model.Count >= 10)
      { %>
    <div class="tn-more">
        <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">
            <%=GetResourceString("Action_MoreComment",applicationID)%></a>
    </div>
    <%}%>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $("#microBlogReplyForm_<%=thread.ThreadID %>").validate({
        rules: {
            microBlogCommentBody: { required: true, maxBlength: 140 }
        },
        messages: {
            microBlogCommentBody: { required: "内容不能为空！", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_BodyMaxLength", ApplicationIDs.Instance().MicroBlog()), 140)%>" }
        },
        showErrors: $.dialog.showErrors,
        onfocusout: false,
        onclick: false,
        onkeyup:false,
        onsubmit:true
    });

    $("#commentButton_<%=thread.ThreadID %>").click(function() {
        if (!$("#microBlogReplyForm_<%=thread.ThreadID %>").valid()) {
            return false;
        }
    });
    
    $("#microBlogReplyForm_<%=thread.ThreadID %>").ajaxForm({
        target: '#microBlogReplyContainer_<%=thread.ThreadID %>',
        beforeSubmit: function() {
            $('#microBlogReplyForm_<%=thread.ThreadID %>').block({
                message: '<%=GetResourceString("Message_Loading")%>'
            });
        },
        success: function() {
            $('#microBlogReplyForm_<%=thread.ThreadID %>').unblock();
            var $reply = $('#reply_<%=thread.ThreadID %>');
            var count = $reply.text().replace(/[^0-9]/ig, "");
            count++;
            $reply.text('<%=GetResourceString("Message_HideComments",applicationID) %>(' + count + ')');

        }
    });

    $("#SurplusOfThread_<%=thread.ThreadID %>").html(140 - $("#commentArea_<%=thread.ThreadID %>").val().length);
    
    
     $("#commentArea_<%=thread.ThreadID %>").focus(function() {
        $(this).removeClass('tn-text-note');
        $('#textAreaDiv_<%=thread.ThreadID %>').removeClass('tn-simple-form');
        countInterval = setInterval(function(){ count(); },360);
     }).blur(function() {
         clearInterval(countInterval);
         count();
     });     
    
    $("a[name=CommentReply]").click(function() {  
        $("#commentArea_<%=thread.ThreadID %>").val('回复@'+$(this).attr("value")+':')       
        $("#cmtID_<%=thread.ThreadID %>").attr('value',$(this).attr("commID"));
    });       
});
function count()
{
    var length = 140 - blength($("#commentArea_<%=thread.ThreadID %>").val());
    if(length < 0) {
      length = -length;
      $("#NoteOfThread_<%=thread.ThreadID %>").html('<%=GetResourceString("Message_Beyond",applicationID)%><b id="SurplusOfThread_<%=thread.ThreadID %>"></b><%=GetResourceString("Message_Word", applicationID)%>');
    }
    else
       $("#NoteOfThread_<%=thread.ThreadID %>").html('<%=GetResourceString("Message_Toenter",applicationID)%><strong id="SurplusOfThread_<%=thread.ThreadID %>"></strong><%=GetResourceString("Message_Word", applicationID)%>');
    $("#SurplusOfThread_<%=thread.ThreadID %>").html(length);
}
function blength(value)
{
    return parseInt((value.replace(/[^\x00-\xff]/g, "**").length+1)/2);
}
</script>

