﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogComment>>" %>
<% MicroBlogThread thread = ViewData.Get<MicroBlogThread>("MicroBlogThread");
   int applicationID = ApplicationIDs.Instance().MicroBlog();
   if (CurrentUser != null || SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting)
   {

       if (TempData["StatusMessageData"] != null)
       {
           StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, ""));
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 5000, false));
           TempData["StatusMessageData"] = null;
       }
       SiteSettings settings = SiteSettingsManager.GetSiteSettings();
%>
<form class="tn-helper-reset" id="commentForm" method="post" action="<%=SPBUrlHelper.Action("CreateMicroBlogComment", "MicroBlog", new RouteValueDictionary { { "ThreadID", Html.GetParameterFromRouteDateOrQueryString("ThreadID", 0) }, {"type",CommentType.ListComment},{ "pageIndex",Model.PageIndex } })%>">
<div class="tn-form">
    <div class="tn-comment-form-wrap tn-emotion-box tn-bg-gray">
        <div class="tn-comment-form">
            <div class="tn-comment-form tn-emotion-box">
                <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("Smiley", "microBlogCommentBody"));%>
                    <textarea id="microBlogCommentBody" name="microBlogCommentBody" class="tn-comment-text-area"
                        rows="" cols="" name=""><%=TempData.GetString("microBlogCommentBody", string.Empty)%></textarea>
                        <span style="display:none"></span>
                </div>
            </div>
            <div class="tn-form-row tn-text-note">
                （<%=GetResourceString("Message_Wordlimit", applicationID)%>）</div>
            <input type="hidden" name="commentID" id="cmtID_<%=thread.ThreadID %>" />
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("submitComment", "确认", ButtonSizes.Default, new RouteValueDictionary { { "name", "submitComment" } },null)%>
                <% if (Request.UrlReferrer != null)
                   {%>
                <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary() { { "onclick", "window.location.href='" + Request.UrlReferrer.AbsoluteUri + "'" } }, null)%>
                <%} %>
            </div>
        </div>
    </div>
</div>
</form>
<%if (Model != null && Model.Records.Count > 0)
  {%>
<div class="tn-comment-wrap">
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <h4>
                <%=GetResourceString("Title_Comments",applicationID) %><span class="tn-text-note">(<%if (Model != null) Response.Write(Model.TotalRecords); else Response.Write("0");%>)</span></h4>
        </div>
    </div>
    <ul class="tn-comments">
        <%foreach (var comment in ViewData.Model.Records)
          {%>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <a name="<%=comment.CommentID %>" id="<%=comment.CommentID %>"></a>
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().MyMicroBlogs(comment.UserID) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID,false, HyperLinkTarget._blank, AvatarSizeTypes.Small) %></a></div>
                </div>
                <%if (CurrentUser != null && CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator)
                  { %>
                <a href="javascript:;" class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')) { $('#commentForLoad').load('<%=SPBUrlHelper.Action("DeleteMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",comment.ThreadID},{"commentID",comment.CommentID}}) %>')}">
                </a>
                <%} %>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <%if (comment.UserID > 0)
                              { %>
                            <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(comment.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>"
                                class="tn-author">
                                <%=comment.Author%></a>
                            <%}
                              else
                              { Response.Write(comment.Author); } %></h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatDate(comment.DateCreated) %></em><span class="tn-text-note"><a
                                href="javascript:;"></a></span>
                        <%if (CurrentUser.UserID != comment.UserID)
                          { %>
                        <span class="tn-text-note">
                            <%User ReplayUser = Users.GetUser(comment.UserID, false);
                              string Runame = string.Empty;
                              if (ReplayUser != null)
                                  Runame = ReplayUser.UserName;
                            %>
                            <a href="javascript:;" name="CommentReply" value="<%=Runame%>" commid="<%=comment.CommentID %>">
                                回复</a></span>
                        <%
                            } %>
                    </div>
                    <p>
                        <%=comment.Body %></p>
                </div>
            </div>
        </li>
        <%}%>
    </ul>
    <% if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
       {%>
    <div class="tn-pagination tn-helper-align-center">
        <%= SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_MicroBlogThreadComments", "MicroBlog", new RouteValueDictionary { { "ThreadID", thread.ThreadID }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    </div>
    <%}%>
</div>
<%} %>

<script type="text/javascript">
     $(document).ready(function() {
        $("#commentForm").validate({
           rules: { 
            microBlogCommentBody:{ required: true, maxBlength: 140 },
            verifyCode:{required:true}
           },
           messages:{
            microBlogCommentBody:{ required: "<%=GetResourceString("Validate_Filledout",applicationID)%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Enterupto",applicationID),140)%>" },
            verifyCode:{required: "<%=GetResourceString("Validate_PleaseInputValidate", ApplicationIDs.Instance().MicroBlog())%>"}
           },         
         showErrors: $.dialog.showErrors,
         onfocusout: false,
         onclick: false,
         onkeyup:false,
         onsubmit:true
        }); 
        
       $("#submitComment").click(function() {
            if (!$("#commentForm").valid()) {
                return false;
            }
          });
          
        $('#commentForm').ajaxForm({
            target: '#commentForLoad',
            beforeSubmit: function() {
                $('#commentForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#commentForm').unblock();
            }
        });
        
        $('.nyroModal').nyroModal({
            resizeable: true
        });
            
        $("a[name=CommentReply]").click(function() {  
            $("#microBlogCommentBody").val('回复@'+$(this).attr("value")+':')       
            $("#cmtID_<%=thread.ThreadID %>").attr('value',$(this).attr("commID"));
        });
    }); 
    function pageIndexChange(url) {
      $('#commentForLoad').load(url);
    }        
</script>

<%}
   else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"))); }%>