﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogThread>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User domainUser = Users.GetUser(userDomainName, false);
   int scopes = ViewData.GetInt("Scopes");
   bool isShow = scopes != (int)MicroBlogScopes.MyCreate;
   int applicationID = ApplicationIDs.Instance().MicroBlog();
   int? type = Html.GetParameterFromRouteDateOrQueryString<int?>("type");
   bool hasManagePermission = (CurrentUser != null) && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator);
   RouteValueDictionary dictionarys = new RouteValueDictionary { { "userDomainName", userDomainName }, { "scopes", scopes } };
   int gid = Request.QueryString.GetInt("gid", 0);
   string pagingUrl = SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type", type }, { "gid", gid }, { "pageIndex", "{0}" } });
   int pageIndex = Request.QueryString.GetInt("pageIndex", 0);
   if (scopes == (int)MicroBlogScopes.MyFavorite)
   {%>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
        <strong class="tn-helper-left">我的收藏</strong>
        <span class="tn-text-note tn-helper-right">
            <%=string.Format(GetResourceString("Title_TotalRecords",applicationID),Model.TotalRecords) %></span>
    </div>
</div>
<%}
   else if (scopes == (int)MicroBlogScopes.ReferMe)
   { %>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
        <strong class="tn-helper-left">
            <%=string.Format(GetResourceString("Title_AtMe", applicationID), SPBHtmlHelper.Instance().UserDisplayName(domainUser))%>
        </strong>
        <span class="tn-text-note tn-helper-right">
            <%=string.Format(GetResourceString("Title_TotalRecords",applicationID),Model.TotalRecords) %></span>
    </div>
</div>
<%}
   else
   {%>
<div class="tn-tabs tn-widget">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix" id="typeMenu">
        <li class="tn-border-gray tn-border-trl <%if (type == null) Response.Write("tn-tabs-selected tn-bg-gray"); %>">
            <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys))%>">
                <span>全部</span></a></li>
        <li class="tn-border-gray tn-border-trl <%if (type==(int)MicroBlogTypes.Original) Response.Write("tn-tabs-selected tn-bg-gray");%>">
            <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type",(int)MicroBlogTypes.Original },{"gid",gid}})%>">
                <span>原创</span></a></li>
        <li class="tn-border-gray tn-border-trl <%if (type==(int)MicroBlogTypes.Photo) Response.Write("tn-tabs-selected tn-bg-gray");%>">
            <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type", (int)MicroBlogTypes.Photo },{"gid",gid}})%>">
                <span>图片</span></a></li>
        <li class="tn-border-gray tn-border-trl <%if(type==(int)MicroBlogTypes.Video) Response.Write("tn-tabs-selected tn-bg-gray");%>">
            <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type", (int)MicroBlogTypes.Video },{"gid",gid}})%>">
                <span>视频</span></a></li>
        <li class="tn-border-gray tn-border-trl <%if (type==(int)MicroBlogTypes.Music) Response.Write("tn-tabs-selected tn-bg-gray");%>">
            <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type", (int)MicroBlogTypes.Music },{"gid",gid}})%>">
                <span>音乐</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-border-gray tn-border-top tn-bg-gray spb-fans-filter tn-helper-clearfix">
        <%if (scopes == (int)MicroBlogScopes.MyFollow)
          {
              List<UserCategory> hideGroups = ViewData["hideGroups"] as List<UserCategory>;
              List<UserCategory> defaultGroups = ViewData["defaultGroups"] as List<UserCategory>;
              List<UserCategory> groups = ViewData["groups"] as List<UserCategory>;
        %>
        <span class="tn-action tn-action-text-icon">
            <span class="tn-icon tn-icon-add"></span>
            <a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditUserGroup","MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"
                id="CreateUserGroup">创建分组</a>
        </span>
        <ul class="sf-menu sf-js-enabled sf-shadow" id="groupMenu">
            <li <%if (gid == 0) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type",type }})%>">
                    所有分组</a></li>
            <li <%if (gid < 0) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type",type },{"gid",-1}})%>">
                    未分组</a></li>
            <% if (defaultGroups != null && defaultGroups.Count > 0)
               {
                   foreach (var defaultGroup in defaultGroups)
                   {%>
            <li <%if (gid == defaultGroup.CategoryID) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                <a title="<%=defaultGroup.CategoryName%>" href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type",type },{"gid",defaultGroup.CategoryID}})%>">
                    <%=StringUtils.Trim(defaultGroup.CategoryName,5)%></a></li>
            <%}
               } if (hideGroups != null && hideGroups.Count > 0)
               {%>
            <li>
                <a class="sf-with-ul" href="javascript:;">更多<span class="tn-icon tn-icon-triangle-down">»</span></a>
                <ul style="display: none; visibility: hidden;" class="tn-widget-content tn-border-gray">
                    <%foreach (var hideGroup in hideGroups)
                      { %>
                    <li <%if (gid == hideGroup.CategoryID) Response.Write("class=\"tn-widget-content tn-border-gray tn-selected tn-corner-o\""); %>>
                        <a title="<%=hideGroup.CategoryName%>" href="<%=SPBUrlHelper.Action("Control_ListMicroBlogThreads", "MicroBlog", new RouteValueDictionary(dictionarys) { { "type",type },{"gid",hideGroup.CategoryID}})%>">
                            <%=StringUtils.Trim(hideGroup.CategoryName,5)%></a></li>
                    <%} %>
                </ul>
            </li>
            <%
                }%>
        </ul>
        <%} %>
    </div>
</div>
<%}%>
<div class="tn-widget spb-new-remind" id="new_t_message" style="display: none">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
        <a href="javascript:;"></a>
        <div width="32" class="tn-loading" id="msg_load" style="min-height: 14px; display: none;">
        </div>
    </div>
</div>
<ul class="tn-list <%if (scopes == (int)MicroBlogScopes.MyFollow) Response.Write("my_mb"); %>" id="ListMicroBlogs">
    <%if (Model != null)
      {
          foreach (MicroBlogThread thread in Model.Records)
          {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="microBlogThreadItem_<%=thread.ThreadID %>">
        <%if (isShow)
          {%>
        <div class="tn-list-item-area-left">
            <div class="tn-avatar" cardurl="<%=SPBUrlHelper.Action("Control_MemberCard", "MicroBlog", new RouteValueDictionary { {"userID",thread.UserID}})%>">
                
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID,false,HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
        </div>
        <%} %>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-summary">
                <p>
                    <%if (isShow)
                      { %>
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>" title="<%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID) %>"
                        class="tn-user-name">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>：</a>
                    <%} %><%=thread.LinkBody %></p>
                <%if (thread.HasPhoto || thread.HasVideo || thread.HasMusic)
                  {%>
                <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                    <%if (thread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                    <%if (thread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, thread.ThumbnailUrl, thread.PlayUrl, false)); %>
                    <%if (thread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, thread.PlayUrl, false)); %>
                </div>
                <%} %>
            </div>
            <%MicroBlogThread originalThread = thread.GetOriginalThread;
              if (thread.OriginalThreadID > 0 && originalThread != null)
              { %>
            <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                <p>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(originalThread.UserID,true) %>：</a><%=originalThread.LinkBody%></p>
                <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                  {%>
                <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                    <%if (originalThread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                    <%if (originalThread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, originalThread.ThumbnailUrl, originalThread.PlayUrl, false)); %>
                    <%if (originalThread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, originalThread.PlayUrl, false)); %>
                </div>
                <%} %>
                <div class="tn-list-item-row">
                    <em class="tn-date">
                        <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                            <%=Formatter.FormatFriendlyDate(originalThread.DateCreated,true) %></a></em><span
                                class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                                    href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalForward",applicationID)%><%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                                </span>
                    <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                        href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalComment",applicationID)%><%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                    </span>
                </div>
            </div>
            <%} %>
            <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
                <em class="tn-date tn-text-note tn-helper-left">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">
                        <%=Formatter.FormatFriendlyDate(thread.DateCreated,true) %></a></em>
                <%if (hasManagePermission || (CurrentUser != null && thread.UserID == CurrentUser.UserID))
                  { %>
                <span class="tn-action">
                    <a href="javascript:;" onclick="deleteMicroBlogThread('<%=thread.ThreadID %>', '<%=SPBUrlHelper.Action("DeleteMicroBlogThread","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",thread.ThreadID}}) %>')"
                        class="tn-action-text">
                        <%=GetResourceString("Action_Delete") %></a>
                </span>
                <span class="tn-pipe tn-text-note">|</span>
                <%} %>
                <span class="tn-action">
                    <%if (CurrentUser != null)
                      { %>
                    <a href="javascript:;" class="tn-action-text" onclick="forward('<%=SPBUrlHelper.Action("Control_ForwardMicroBlog","MicroBlog",new RouteValueDictionary {{"threadID",thread.ThreadID}}) %>');return false;">
                        <%=GetResourceString("Action_Forward", ApplicationIDs.Instance().MicroBlog())%>
                        (<%=thread.ForwardedCount%>)</a>
                    <%}
                      else
                      { %>
                    <a href="javascript:;" class="tn-action-text">
                        <%=GetResourceString("Action_Forward", ApplicationIDs.Instance().MicroBlog())%>
                        (<%=thread.ForwardedCount%>)</a>
                    <%} %></span>
                <span class="tn-pipe tn-text-note">|</span>
                <%if (CurrentUser != null && CurrentUser.UserID != thread.UserID)
                  { %>
                <span class="tn-action">
                    <%if (!MicroBlogThreads.IsFavorite(CurrentUser.UserID, thread.ThreadID))
                      { %>
                    <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='0'>收藏</a>
                    <%}
                      else
                      { %>
                    <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='1'>取消收藏</a>
                    <%} %></span>
                <span class="tn-pipe tn-text-note">|</span>
                <%} %>
                <span class="tn-action">
                    <a href="javascript:;" name="reply" id="reply_<%=thread.ThreadID %>" value="<%=thread.ThreadID %>"
                        class="tn-action-text">
                        <%=GetResourceString("Action_Comment",applicationID)%>(<%=thread.ReplyCount%>)</a></span>
            </div>
            <%if (CurrentUser != null)
              { %>
            <div class="tn-simple-comments" id="ListComments_<%=thread.ThreadID %>" style="display: none">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                    </div>
                    <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=thread.ThreadID %>"
                        value="<%=SPBUrlHelper.Action("Control_ListCommentsOfThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>">
                        <div class="tn-loading">
                        </div>
                    </div>
                </div>
            </div>
            <%} %>
        </div>
    </li>
    <%}
      }%>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 10, pagingUrl, "pageIndexChange")%>
</div>
<%if (Model == null && scopes == (int)MicroBlogScopes.MyCreate)
  {%>
<div class="tn-no-data">
    还没有发表过一篇微博呢，快来
    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(domainUser.UserID) %>"><strong>发表</strong></a>一篇属于自己的微博吧。</div>
<%} %>
<% %>

<script type="text/javascript">
    $(document).ready(function() {
        <%if (CurrentUser != null)
        { %>
        $('ul.sf-menu').superfish();
        $("div.tn-avatar", $("#ListMicroBlogs")).spbcard();
        $('a[name=reply]').live('click',function() {
            var $comments = $('#microBlogReplyContainer_' + $(this).attr("value"));
            if ($("#ListComments_" + $(this).attr("value")).is(":hidden")) {
                if ($comments.find("div.tn-loading").length) {
                    $('#microBlogReplyContainer_' + $(this).attr("value")).load($('#microBlogReplyContainer_' + $(this).attr("value")).attr("value"));
                }
                $("#ListComments_" + $(this).attr("value")).show();
                var count = $(this).text().replace(/[^0-9]/ig, "");
                if(!count) count = 0;
                $(this).text('<%=GetResourceString("Message_HideComments",applicationID) %>(' + count + ')');
            }
            else {
                $("#ListComments_" + $(this).attr("value")).hide();
                var count = $(this).text().replace(/[^0-9]/ig, "");
                if(!count) count = 0;
                $(this).text('<%=GetResourceString("Action_Comment",applicationID)%>(' + count + ')');
            }
        });
        
        $('#CreateUserGroup').dialog({
            id: 'EditGroupBox',
            title: '创建分组',
            width: 300
        });
        
        $("a[name='fAction']").live('click',function(){
               var $favorite = $(this);
               if ($(this).attr("status") <= 0) {
                   $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', {threadID: $favorite.attr('tid') }, function(data) {
                       $favorite.html('取消收藏').attr("status", 1);
                   });
               }
               else {
                   $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', { threadID: $favorite.attr('tid') }, function(data) {
                        $favorite.html('收藏').attr("status", 0);
                   });
               }
        });
        <%if (scopes == (int)MicroBlogScopes.MyFollow){ %>
        <% if(pageIndex <= 1 && gid == 0  && type == null) {%>
           var $ct = $('#ListMicroBlogs li:first');
           if($ct && $ct.length > 0)
              setCookie('TimeLineNewst' + '<%=CurrentUser.UserID %>',$ct.attr("id").replace(/[^0-9]/ig, ""));
           else
              setCookie('TimeLineNewst' + '<%=CurrentUser.UserID %>',0);
        <%} %>
        
        $(window).scroll(function(){
          var $newt = $('#ListMicroBlogs li.tn-bg-light:first');
          if($newt&&$newt.scrollTop()< 380)
             $newt.removeClass("tn-bg-light");
        });
        
        $('#ListMicroBlogs li.tn-bg-light').live("mousemove",function(){
             $(this).removeClass("tn-bg-light");
        });
        
        setInterval(function(){
          var ctid = getCookie('TimeLineNewst' + <%=CurrentUser.UserID %>);
          if(ctid > 0 || <%=pageIndex %> <= 1)
          {         
              $.get('<%=SPBUrlHelper.Action("NewThreadsMessage", "MicroBlog") %>',{cthreadID : ctid},function(data){
                  if(data.count && data.count > 0)
                  {
                     $('#new_t_message').show();
                     $('#msg_load').hide();  
                     $('#new_t_message a').show().html('有'+ data.count +'条新微博，点击浏览');
                  }
              });
              
              $('#new_t_message').unbind('click').click(function(){
               var count = $('#new_t_message a').text().replace(/[^0-9]/ig, "");
               if(count > 20)
               {
                   refresh();
               }
               else
               {  
                   $('#new_t_message a').hide();
                   $('#msg_load').show();
                   $.get('<%=SPBUrlHelper.Action("Control_Newthreads", "MicroBlog") %>',{cthreadID : ctid},function(data){
                      if(data)
                      {
                          $('#ListMicroBlogs').prepend(data);
                          var $ct = $('#ListMicroBlogs li:first');
                          if($ct && $ct.length > 0)
                             setCookie('TimeLineNewst' + '<%=CurrentUser.UserID %>',$ct.attr("id").replace(/[^0-9]/ig, ""));
      
                      }
                      $('#new_t_message').hide();
                   });
               }
               return false;
              });
           }          
        },30000);
        
        <%} %>
        
        //video_start
        $('div[name=videoThumb]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_video_' + tid).length > 0) {
                if($.browser.msie)
                    $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
                else
                    $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        
        $("span[name=stop_Video]").live("click",function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Video]', $("ul#ListMicroBlogs")).live("click",function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            if($.browser.msie)
              $('#play_music_' + tid).hide().find('object').remove();
            else
              $('#play_music_' + tid).hide().find('embed').attr("src", "");              
              
            $('#view_photo_' + tid).hide();
            if ($('#play_video_' + tid).length > 0) {
                $thumblist.hide();
                
            if($.browser.msie)
                $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
            else
                $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //video_end

        //music_start
        var playurl = '<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?autoPlay=false&audioUrl=';
        $('div[name=musicThumb]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_music_' + tid).length > 0) {
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        $("span[name=stop_Music]").live("click",function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type="Music"]', $("ul#ListMicroBlogs")).live("click",function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            $('#view_photo_' + tid).hide();
            if($.browser.msie)                    
              $('#play_video_' + tid).hide().find('embed').remove();
            else
              $('#play_video_' + tid).hide().find('embed').attr("src", "");
              
            if ($('#play_music_' + tid).length > 0) {
                $thumblist.hide();
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //music_end

        //photo_start
        $('div[name=previewPhoto]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#view_photo_' + tid).length > 0) {
                $('#view_photo_' + tid).show();
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"view_photo_" + tid + "\">&nbsp;</div>").hide();
                $('#view_photo_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogPhoto","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid')+ '&othreadID='+ $(this).attr('otid') + "&type=" + '<%=MicroBlogPhotoTypes.View %>');
            }
        });
        $("div[name=viewPhoto]").live("click",function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        //photo_end
        
        <%}
        else
        { %>
        $('#ListMicroBlogs a').attr("href","<%=SiteUrls.Instance().LoginInModal() %>");
        $('#ListMicroBlogs a').dialog({
            id: 'loginDialog',
            title: '登录',
            width: 400             
        });

        <%} %>
        $('ul#typeMenu a,ul#groupMenu a').live('click', function() {
            $('#ListMicroBlogs').parent().load($(this).attr('href'));
            return false;
        });
    });
    
    function forward(url)
    {
       $.dialog.load(url, {id: 'showForwardmb',
         title: '<%=GetResourceString("Title_ForwardToMy", applicationID)%>',
         width: 300             
        }, false);
    }
    function deleteMicroBlogThread(microBlogThreadID, url) {
        if (confirm('<%=GetResourceString("Message_ConfirmDeleteThread", ApplicationIDs.Instance().MicroBlog())%>')) {
            $.ajax({
                url: url,
                success: function(data, textStatus) {
                    $("#microBlogThreadItem_" + microBlogThreadID).fadeOut();
                }
            });
        }
    }
    function pageIndexChange(url) {
        $('#ListMicroBlogs').parent().load(url);
    }
</script>

