﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<int,MicroBlogThread>>" %>
<%int screenID = Request.QueryString.GetInt("screenID", 0);
  MicroBlogScreen screen = MicroBlogScreens.GetScreen(screenID, false);
  if (screen == null) screen = new MicroBlogScreen();%>
<div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
    <%if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));

          TempData["StatusMessageType"] = null;
          TempData["StatusMessageContent"] = null;
      } %>
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-border-gray tn-border-bottom">
            <label class="tn-check-all">
                <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'MicroBlog')" />
                全选</label>
            <%Response.Write(SPBHtmlHelper.Instance().LinkButton("m_clear", "移除", "javascript:;", ButtonSizes.Default, HighlightStyles.Default));
              Response.Write(SPBHtmlHelper.Instance().LinkButton("", "返回", SPBUrlHelper.Action("ScreenLeadStudio", "MicroBlog", new RouteValueDictionary { { "screenID", screenID } }), ButtonSizes.Default, HighlightStyles.Secondary));%>
            <span class="tn-button tn-button-default" id="pausebtn">
                <span class="tn-first-child">
                    <a class="tn-button-text" href="javascript:;" onclick="Pause()">
                        <%=screen.IsPause?"取消暂停":"暂停" %></a></span></span>
        </div>
    </div>
    <form action="<%=SPBUrlHelper.Action("DeleteItems","MicroBlog",new RouteValueDictionary{{"screenID",screenID}}) %>"
    method="post" id="ScreenMicroBlogs">
    <ul class="tn-list">
        <%if (Model != null)
          {
              foreach (var item in Model)
              {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="m_Item_i_<%=item.Key %>">
            <div class="tn-list-checkbox">
                <input type="checkbox" name="MicroBlog" class="tn-checkbox" value="<%=item.Key %>" />
            </div>
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(item.Value.UserID) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.Value.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
            </div>
            <div class="tn-list-item-area-right">
                <ul class="tn-list-actions">
                    <li class="tn-list-action tn-bg-light tn-border-light tn-corner-all">
                        <a title="移除当前微博" class="tn-icon tn-icon-cross" onclick="removeItem(<%=item.Key %>)">
                            移除当前微博</a></li>
                </ul>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-summary">
                    <p>
                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(item.Value.UserID) %>" title="<%=SPBHtmlHelper.Instance().UserDisplayName(item.Value.UserID) %>"
                            class="tn-user-name">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(item.Value.UserID, true)%>：</a><%=item.Value.LinkBody%></p>
                    <%if (item.Value.HasPhoto)
                      {%>
                    <div class="spb-media-wrap tn-helper-clearfix">
                        <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(item.Value.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                    </div>
                    <%} %>
                </div>
                <%MicroBlogThread originalThread = item.Value.GetOriginalThread;
                  if (item.Value.OriginalThreadID > 0 && originalThread != null)
                  { %>
                <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                    <p>
                        <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                            <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
                    <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                      {%>
                    <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=item.Value.ThreadID %>">
                        <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(item.Value.ThreadID, item.Value.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                    </div>
                    <%} %>
                    <div class="tn-list-item-row">
                        <em class="tn-date">
                            <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                                <%=Formatter.FormatFriendlyDate(originalThread.DateCreated) %></a></em><span class="tn-pipe tn-text-note">|</span><span
                                    class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文转发<%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                                </span>
                        <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                            href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文评论<%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                        </span>
                    </div>
                </div>
                <%} %>
            </div>
            <div class="tn-list-item-row tn-helper-clearfix tn-helper-clear">
                <span class="tn-actions">
                    <span class="tn-action">
                        <a href="<%=SiteUrls.Instance().ShowMicroBlog(item.Value.UserID, item.Value.ThreadID)%>"
                            class="tn-action-text">
                            <%if (item.Value.ForwardedCount > 0) Response.Write("转发(" + item.Value.ForwardedCount + ")"); else Response.Write("转发"); %>
                        </a>
                    </span>
                    <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a href="<%=SiteUrls.Instance().ShowMicroBlog(item.Value.UserID, item.Value.ThreadID)%>"
                        class="tn-action-text"><%if (item.Value.ReplyCount > 0) Response.Write("评论（" + item.Value.ReplyCount + "）"); else Response.Write("评论"); %></a>
                    </span>
                </span>
                <em class="tn-date tn-text-note">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(item.Value.UserID, item.Value.ThreadID)%>">
                        <%=Formatter.FormatFriendlyDate(item.Value.DateCreated, true)%></a></em></div>
        </li>
        <%}%>

        <script type="text/javascript">
            var gi;
            $(document).ready(function() {
            
                  var $ct = $('ul li:first', $('#ScreenMicroBlogs'));
                  if($ct && $ct.length == 1)
                     setCookie('playedItem' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                     gi = setInterval(function(){ getPlayItem(); },6000);
                $('#m_clear').click(function() {
                    clearInterval(gi);
                    if(!confirm('确定要删除这些微博？'))
                    {
                       gi = setInterval(function(){ getPlayItem(); },6000);
                       return false;
                    }
                    $('#ScreenMicroBlogs').ajaxSubmit({
                        success: function(data) {
                            data = eval('(' + data + ')');
                            gi = setInterval(function(){ getPlayItem(); },6000);
                            if (data.error) {
                                alert(data.msg);
                                return false;
                            }
                            if (data.ok) {
                                
                                $('ul :checkbox:checked', $('#ScreenMicroBlogs')).each(function() {
                                    $('#m_Item_i_' + $(this).val()).remove();
                                });
                                var $ct = $('ul li:first', $('#ScreenMicroBlogs'));
                                if($ct && $ct.length >= 1)
                                {
                                   setCookie('playedItem' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                                }
                            }
                        },
                        dataType: 'JSON'
                    })
                });
            });
            
            function getPlayItem()
            {
                var itemID = getCookie('playedItem' + <%=screenID %>);       
                $.post('<%=SPBUrlHelper.Action("GetPlayedItem", "MicroBlog") %>',{itemID : itemID,screenID:<%=screenID %>},function(data){
                   if(data.ok)
                   {
                      $('ul li:first', $('#ScreenMicroBlogs')).remove();
                      var $ct = $('ul li:first', $('#ScreenMicroBlogs'));
                      if($ct && $ct.length == 1)
                      {
                          setCookie('playedItem' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                      }
                   }
                }); 
            }
            function removeItem(itemID) {
                clearInterval(gi);
                if(!confirm('确定要删除当前微博？'))
                {
                   gi = setInterval(function(){ getPlayItem(); },6000);
                   return false;
                }
                $.post('<%=SPBUrlHelper.Action("DeleteItem", "MicroBlog")%>',{screenID:<%=screenID %>,itemID:itemID},function(data){
                   gi = setInterval(function(){ getPlayItem(); },6000);
                   if(data.error)
                   {
                       alert(data.msg);
                       return false;
                   }           
                   if(data.ok)
                   {
                        $('#m_Item_i_' + itemID).remove();
                        var $ct = $('ul li:first', $('#ScreenMicroBlogs'));
                        if($ct && $ct.length == 1)
                        {
                           setCookie('playedItem' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                        }
                   }
                });
            }
            
            function Pause() {
                $.get('<%=SPBUrlHelper.Action("Pause","MicroBlog") %>', { screenID: '<%=screenID %>' }, function(data) {
                
                    if (data.pause) {
                        $('#pausebtn a').text("取消暂停");
                    }
                    else {
                        $('#pausebtn a').text("暂停");
                    }
                });
            }
            
        </script>

        <%}%>
    </ul>
    </form>
</div>
