﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogComment>>" %>
<spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User domainUser = Users.GetUser(userDomainName, false);

   int applicationID = ApplicationIDs.Instance().MicroBlog();
   bool hasManagePermission = (CurrentUser != null) && (CurrentUser.UserID == domainUser.UserID || CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator);

%>
<div id="MyComments">
    <div class="spb-my-comments">
        <div class="tn-tabs tn-widget">
            <ul class="tn-tabs-nav tn-helper-clearfix">
                <li class="tn-widget-content tn-border-gray tn-border-trl ">
                    <a href="<%=SPBUrlHelper.Action("MyMicroBlogComments", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                        <span>收到的评论</span></a></li>
                <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
                    <a href="<%=SPBUrlHelper.Action("MySendMicroBlogComments", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                        <span>发出的评论</span></a></li>
            </ul>
            <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
                <div class="tn-comment-wrap">
                    <ul class="tn-comments">
                        <%if (Model.Records != null && Model.Records.Count > 0)
                          {
                              foreach (MicroBlogComment comment in Model.Records)
                              {
                                  string body;
                                  string authorStr;
                                  int id;
                                  if (comment.ParentID > 0)
                                  {
                                      MicroBlogComment com = MicroBlogComments.GetComment(comment.ParentID, false);
                                      body = HtmlUtils.TrimHtml(com.Body, 20);
                                      authorStr = string.Format("回复{0}的评论:", com.Author);
                                      id = com.UserID;
                                  }
                                  else
                                  {
                                      MicroBlogThread thread = MicroBlogThreads.GetThread(comment.ThreadID, false);
                                      body = StringUtils.Trim(thread.ForwardBody, 20);
                                      if (thread.HasPhoto)
                                          body = body + SPBHtmlHelper.Instance().Icon(IconTypes.Picture, "图片微博", new RouteValueDictionary { { "class", "tn-icon-inline" } });
                                      authorStr = string.Format("回复{0}的微博:", thread.Author);
                                      id = thread.UserID;

                                  }%>
                        <li class="tn-comment-item tn-border-gray tn-border-bottom">
                            <div class="tn-comment tn-helper-clearfix">
                                <div class="tn-comment-avatar">
                                    <div class="tn-avatar">
                                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(id) %>">
                                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(id, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a>
                                    </div>
                                </div>
                                <div class="tn-comment-info">
                                    <%if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator))
                                      { %>
                                    <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment") %>')){ $('#MyComments').load('<%=SPBUrlHelper.Action("DeleteMySendMicroBlogComment","MicroBlog",new RouteValueDictionary{{"threadID",comment.ThreadID},{"commentID",comment.CommentID},{"userDomainName",userDomainName}}) %>');}">
                                    </a>
                                    <%} %>
                                    <p class="tn-comments-text">
                                        <%=comment.Body %><em class="tn-date tn-text-note"><a href="<%=SiteUrls.Instance().ShowMicroBlog(comment.OwnerUserID,comment.ThreadID) %>"><%=Formatter.FormatFriendlyDate(comment.DateCreated)%></a></em></p>
                                    <p class="tn-comments-from">
                                        <span class="tn-text-note">
                                            <%=authorStr %></span><%=body%></p>
                                </div>
                            </div>
                        </li>
                        <%}
                          }%>
                    </ul>
                    <div class="tn-pagination tn-helper-align-center">
                        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
