﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<MicroBlogThread>>" %>
<% bool hasManagePermission = CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator);
   int applicationID = ApplicationIDs.Instance().MicroBlog();
   MicroBlogThreadSortBy sortBy = ViewData.Get<MicroBlogThreadSortBy>("sortBy");
   int pageIndex = Request.QueryString.GetInt("pageIndex", 0);%>
<div class="tn-list-header tn-helper-align-right">
    <span class="tn-action tn-action-text-icon">
        <span class="tn-icon tn-icon-microblog"></span>
        <a class="tn-action-text" id="m_publish" href="<%=SPBUrlHelper.Action("Control_ShareMicroBlogTopic","MicroBlog", new RouteValueDictionary{{"returnUrl",WebUtils.UrlEncode(Request.RawUrl)}}) %>">
            来说两句</a>
    </span>
</div>
<div class="tn-widget spb-new-remind" id="new_t_message" style="display: none">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
        <a href="javascript:;"></a>
        <div width="32" class="tn-loading" id="msg_load" style="min-height: 14px; display: none;">
        </div>
    </div>
</div>
<ul class="tn-list" id="ListMicroBlogs">
    <%if (Model != null)
      {
          foreach (MicroBlogThread thread in Model.Records)
          {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="microBlogThreadItem_<%=thread.ThreadID %>">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar" cardurl="<%=SPBUrlHelper.Action("Control_MemberCard", "MicroBlog", new RouteValueDictionary { {"userID",thread.UserID}})%>">
                <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID,false,HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-summary">
                <p>
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>" class="tn-user-name">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>：</a>
                    <%=thread.LinkBody%></p>
                <%if (thread.HasPhoto || thread.HasVideo || thread.HasMusic)
                  {%>
                <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                    <%if (thread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                    <%if (thread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, thread.ThumbnailUrl, thread.PlayUrl, false)); %>
                    <%if (thread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, thread.PlayUrl, false)); %>
                </div>
                <%} %>
            </div>
            <%MicroBlogThread originalThread = thread.GetOriginalThread;
              if (thread.OriginalThreadID > 0 && originalThread != null)
              { %>
            <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                <p>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(originalThread.UserID,true) %>：</a><%=originalThread.LinkBody%></p>
                <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                  {%>
                <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                    <%if (originalThread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                    <%if (originalThread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, originalThread.ThumbnailUrl, originalThread.PlayUrl, false)); %>
                    <%if (originalThread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, originalThread.PlayUrl, false)); %>
                </div>
                <%} %>
                <div class="tn-list-item-row">
                    <em class="tn-date">
                        <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                            <%=Formatter.FormatFriendlyDate(originalThread.DateCreated,true) %></a></em><span
                                class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                                    href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalForward",applicationID)%><%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                                </span>
                    <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                        href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalComment",applicationID)%><%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                    </span>
                </div>
            </div>
            <%} %>
            <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
                <em class="tn-date tn-text-note tn-helper-left">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">
                        <%=Formatter.FormatFriendlyDate(thread.DateCreated,true) %></a></em>
                <%if (hasManagePermission || (CurrentUser != null && thread.UserID == CurrentUser.UserID))
                  { %>
                <span class="tn-action">
                    <a href="javascript:;" onclick="deleteMicroBlogThread('<%=thread.ThreadID %>', '<%=SPBUrlHelper.Action("DeleteMicroBlogThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>')"
                        class="tn-action-text">
                        <%=GetResourceString("Action_Delete") %></a>
                </span>
                <span class="tn-pipe tn-text-note">|</span>
                <%} %>
                <span class="tn-action">
                    <%if (CurrentUser != null)
                      { %>
                    <a href="javascript:;" class="tn-action-text" onclick="forward('<%=SPBUrlHelper.Action("Control_ForwardMicroBlog","MicroBlog",new RouteValueDictionary {{"threadID",thread.ThreadID}}) %>')">
                        <%=GetResourceString("Action_Forward", applicationID)%>
                        (<%=thread.ForwardedCount%>)</a>
                    <%}
                      else
                      { %>
                    <a href="javascript:;" class="tn-action-text">
                        <%=GetResourceString("Action_Forward", applicationID)%>
                        (<%=thread.ForwardedCount%>)</a>
                    <%} %>
                </span>
                <span class="tn-pipe tn-text-note">|</span>
                <%if (CurrentUser != null && CurrentUser.UserID != thread.UserID)
                  { %>
                <span class="tn-action">
                    <%if (!MicroBlogThreads.IsFavorite(CurrentUser.UserID, thread.ThreadID))
                      { %>
                    <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='0'>收藏</a>
                    <%}
                      else
                      { %>
                    <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='1'>取消收藏</a>
                    <%} %></span>
                <span class="tn-pipe tn-text-note">|</span>
                <%} %>
                <span class="tn-action">
                    <a name="reply" href="javascript:;" id="reply_<%=thread.ThreadID %>" value="<%=thread.ThreadID %>"
                        class="tn-action-text">
                        <%=GetResourceString("Action_Comment", ApplicationIDs.Instance().MicroBlog())%>(<%=thread.ReplyCount %>)</a></span>
            </div>
            <%if (CurrentUser != null)
              { %>
            <div class="tn-simple-comments" id="ListComments_<%=thread.ThreadID %>" style="display: none">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                    </div>
                    <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=thread.ThreadID %>"
                        value="<%=SPBUrlHelper.Action("Control_ListCommentsOfThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>">
                        <div class="tn-loading">
                        </div>
                    </div>
                </div>
            </div>
            <%} %>
        </div>
    </li>
    <%} %>
</ul>

<script type="text/javascript">
    $(document).ready(function() {
        <%if (CurrentUser != null)
        { %>
        $('#m_publish').dialog({
             id: 'showShareTopic',
             title:"发布微博",
             width:50
        });
        $("div.tn-avatar",$("#ListMicroBlogs")).spbcard();
        $('a[name=reply]').live("click",function() {
            var $comments = $('#microBlogReplyContainer_' + $(this).attr("value"));
            if ($("#ListComments_" + $(this).attr("value")).is(":hidden")) {
                if ($comments.find("div.tn-loading").length) {
                    $('#microBlogReplyContainer_' + $(this).attr("value")).load($('#microBlogReplyContainer_' + $(this).attr("value")).attr("value"));
                }
                $("#ListComments_" + $(this).attr("value")).show();
                var count = $(this).text().replace(/[^0-9]/ig, "");
                $(this).text('<%=GetResourceString("Message_HideComments",applicationID) %>(' + count + ')');
            }
            else {
                $("#ListComments_" + $(this).attr("value")).hide();
                var count = $(this).text().replace(/[^0-9]/ig, "");
                $(this).text('<%=GetResourceString("Action_Comment", ApplicationIDs.Instance().MicroBlog()) %>(' + count + ')');
            }
        });
        
       $("a[name='fAction']").live("click",function(){
              var $favorite = $(this);
              if ($(this).attr("status") <= 0) {
                  $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', {threadID: $favorite.attr('tid') }, function(data) {
                      $favorite.html('取消收藏').attr("status", 1);
                  });
              }
              else {
                  $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', { threadID: $favorite.attr('tid') }, function(data) {
                       $favorite.html('收藏').attr("status", 0);
                  });
              }
        });
      <%if (sortBy == MicroBlogThreadSortBy.DateCreated)
      { %>
        $(window).scroll(function(){
          var $newt = $('#ListMicroBlogs li.tn-bg-light:first');
          if($newt&&$newt.scrollTop()< 380)
             $newt.removeClass("tn-bg-light");
        });
        
        $('#ListMicroBlogs li.tn-bg-light').live("mousemove",function(){
             $(this).removeClass("tn-bg-light");
        });
        
        if(<%=pageIndex%> <= 1) {
           var $ct = $('#ListMicroBlogs li:first');
           if($ct && $ct.length > 0)
              setCookie('mnewst',$ct.attr("id").replace(/[^0-9]/ig, ""));
           else
              setCookie('mnewst',0);
        }
        
        setInterval(function(){
          var ctid = getCookie('mnewst');
          if(ctid > 0 || <%=pageIndex %> <= 1)
          { 
              $.get('<%=SPBUrlHelper.Action("NewThreadsMessage", "MicroBlog") %>',{inDomain : false ,cthreadID : ctid},function(data){
                  if(data.count && data.count > 0)
                  {
                     $('#new_t_message').show();
                     $('#msg_load').hide();  
                     $('#new_t_message a').show().html('有'+ data.count +'条新微博，点击浏览');
                  }
              });
              
              $('#new_t_message').unbind('click').click(function(){
               var count = $('#new_t_message a').text().replace(/[^0-9]/ig, "");
               if(count > 20)
               {
                  refresh();
               }
               else
               {  
                   $('#new_t_message a').hide();
                   $('#msg_load').show();
                   $.get('<%=SPBUrlHelper.Action("Control_Newthreads", "MicroBlog") %>',{inDomain : false ,cthreadID : ctid,showCount:false},function(data){
                      if(data)
                      {
                          $('#ListMicroBlogs').prepend(data);
                          var $ct = $('#ListMicroBlogs li:first');
                          if($ct && $ct.length > 0)
                             setCookie('mnewst',$ct.attr("id").replace(/[^0-9]/ig, ""));  
                      }
                      $('#new_t_message').hide();
                   });
               }
               return false;
              });
          }
        },30000);
        <%} %>
        //video_start
        $('div[name=videoThumb]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_video_' + tid).length > 0) {
                if($.browser.msie)
                    $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
                else
                    $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        
        $("span[name=stop_Video]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Video]', $("ul.tn-list")).live("click",function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            if($.browser.msie)
              $('#play_music_' + tid).hide().find('object').remove();
            else
              $('#play_music_' + tid).hide().find('embed').attr("src", "");              
              
            $('#view_photo_' + tid).hide();
            if ($('#play_video_' + tid).length > 0) {
                $thumblist.hide();
                
            if($.browser.msie)
                $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
            else
                $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //video_end

        //music_start
        var playurl = '<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?autoPlay=false&audioUrl=';
        $('div[name=musicThumb]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_music_' + tid).length > 0) {
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        $("span[name=stop_Music]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Music]', $("ul.tn-list")).live("click",function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            $('#view_photo_' + tid).hide();
            if($.browser.msie)                    
              $('#play_video_' + tid).hide().find('embed').remove();
            else
              $('#play_video_' + tid).hide().find('embed').attr("src", "");
              
            if ($('#play_music_' + tid).length > 0) {
                
                $thumblist.hide();
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //music_end

        //photo_start
        $('div[name=previewPhoto]').live("click",function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#view_photo_' + tid).length > 0) {
                $('#view_photo_' + tid).show();
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"view_photo_" + tid + "\">&nbsp;</div>").hide();
                $('#view_photo_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogPhoto","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid')+ '&othreadID='+ $(this).attr('otid') + "&type=" + '<%=MicroBlogPhotoTypes.View %>');
            }
        });
        $("div[name=viewPhoto]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        //photo_end
        
        <%}
        else 
        {%>
        $('ul.tn-list a').attr("href","<%=SiteUrls.Instance().LoginInModal() %>");
        $('ul.tn-list a').dialog({
            id: 'loginDialog',
            title: '登录',
            width: 400             
        });
        <%} %>

    });
    function deleteMicroBlogThread(microBlogThreadID, url) {
        if (confirm('<%=GetResourceString("Message_ConfirmDeleteThread", ApplicationIDs.Instance().MicroBlog())%>')) {
            $.ajax({
                url: url,
                success: function(data, textStatus) {
                    $("#microBlogThreadItem_" + microBlogThreadID).fadeOut();
                }
            });
        }
    }
    
    function forward(url)
    {
       $.dialog.load(url, {id: 'showForwardmb',
         title: '<%=GetResourceString("Title_ForwardToMy", applicationID)%>',
         width: 300             
        }, false);
    }
</script>

<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %>
</div>
<%} %>
