﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<SearchResultDataSet<MicroBlogThread>>" %>
<%int screenID = Request.QueryString.GetInt("screenID", 0);
  string keyword = ViewData.GetString("keyword", string.Empty);
  MicroBlogScreen screen = MicroBlogScreens.GetScreen(screenID, false);
  if (screen == null) screen = new MicroBlogScreen();%>
<div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
    <%if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));

          TempData["StatusMessageType"] = null;
          TempData["StatusMessageContent"] = null;
      } %>
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-border-gray tn-border-bottom">
            <label class="tn-check-all">
                <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'MicroBlog')" />
                全选</label>
            <span class="tn-button tn-button-default">
                <span class="tn-first-child">
                    <a class="tn-button-text" href="javascript:;" onclick="$('#ScreenMicroBlogs').attr('action','<%=SPBUrlHelper.Action("AddItems","MicroBlog",new RouteValueDictionary{{ "screenID",screenID},{"returnUrl",Request.RawUrl}})%>').submit();return false;">
                        加入播放列表</a></span></span>
            <span class="tn-button tn-button-default" id="pausebtn">
                <span class="tn-first-child">
                    <a class="tn-button-text" href="javascript:;" onclick="Pause()">
                        <%=screen.IsPause?"取消暂停":"暂停" %></a></span></span>
        </div>
    </div>
    <form action="" method="post" id="ScreenMicroBlogs">
    <div class="tn-widget spb-new-remind" id="new_t_message" style="display: none">
        <div class="tn-cue-highlight tn-corner-all tn-message-box">
            <a href="javascript:;"></a>
            <div width="32" class="tn-loading" id="msg_load" style="min-height: 14px; display: none;">
            </div>
        </div>
    </div>
    <ul class="tn-list" id="topicmbList">
        <%if (Model != null)
          {
              foreach (var thread in Model.Records)
              {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom <%if (MicroBlogThreads.IsInPalys(screenID, thread.ThreadID)) Response.Write("tn-bg-light"); %>"
            id="m_Item_<%=thread.ThreadID %>">
            <div class="tn-list-checkbox">
                <input type="checkbox" name="MicroBlog" class="tn-checkbox" value="<%=thread.ThreadID %>" />
            </div>
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
            </div>
            <div class="tn-list-item-area-right">
                <ul class="tn-list-actions">
                    <li class="tn-list-action tn-bg-light tn-border-light tn-corner-all">
                        <a title="插入播放列表" class="tn-icon tn-icon-arrow-rt" href="javascript:;" onclick="InsertPlays(<%=thread.ThreadID %>)">
                            插入播放列表</a></li>
                    <li class="tn-list-action tn-bg-light tn-border-light tn-corner-all">
                        <a title="加入播放列表" class="tn-icon tn-icon-send" onclick="AddPlay(<%=thread.ThreadID %>)">
                            加入播放列表</a></li>
                </ul>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-summary">
                    <p>
                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>" title="<%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID) %>"
                            class="tn-user-name">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>：</a><%=thread.LinkBody %></p>
                    <%if (thread.HasPhoto)
                      {%>
                    <div class="spb-media-wrap tn-helper-clearfix">
                        <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                    </div>
                    <%} %>
                </div>
                <%MicroBlogThread originalThread = thread.GetOriginalThread;
                  if (thread.OriginalThreadID > 0 && originalThread != null)
                  { %>
                <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                    <p>
                        <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                            <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
                    <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                      {%>
                    <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                        <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                    </div>
                    <%} %>
                    <div class="tn-list-item-row">
                        <em class="tn-date">
                            <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                                <%=Formatter.FormatFriendlyDate(originalThread.DateCreated) %></a></em><span class="tn-pipe tn-text-note">|</span><span
                                    class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文转发<%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                                </span>
                        <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                            href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文评论<%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                        </span>
                    </div>
                </div>
                <%} %>
            </div>
            <div class="tn-list-item-row tn-helper-clearfix tn-helper-clear">
                <span class="tn-actions">
                    <span class="tn-action">
                        <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>"
                            class="tn-action-text">
                            <%if (thread.ForwardedCount > 0) Response.Write("转发(" + thread.ForwardedCount + ")"); else Response.Write("转发"); %>
                        </a>
                    </span>
                    <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>"
                        class="tn-action-text"><%if (thread.ReplyCount > 0) Response.Write("评论（" + thread.ReplyCount + "）"); else Response.Write("评论"); %></a>
                    </span>
                </span>
                <span class="spb-fav-operate">
                    <a title="存入收藏夹1" href="javascript:;" class="tn-corner-o tn-bg-light tn-border-deep"
                        onclick="FavoriteM(1,<%=thread.ThreadID %>)">1</a><a title="存入收藏夹2" href="javascript:;"
                            onclick="FavoriteM(2,<%=thread.ThreadID %>)" class="tn-corner-o tn-bg-light tn-border-deep">2</a><a
                                title="存入收藏夹3" href="javascript:;" onclick="FavoriteM(3,<%=thread.ThreadID %>)"
                                class="tn-corner-o tn-bg-light tn-border-deep">3</a></span><em class="tn-date tn-text-note"><a
                                    href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>">
                                    <%=Formatter.FormatFriendlyDate(thread.DateCreated,true) %></a></em></div>
        </li>
        <%}%>

        <script type="text/javascript">
            var msgcontent = '<table id="msg_tb"><tbody><tr><td class="aui_td_icon"><div class="aui_icon art_succeed"></div></td>'
                           +'<td style="width: auto; height: auto" class="aui_td_content"><div class="aui_content_wrap"><div>'
                           +'<h3>添加成功</h3></div><div class="aui_content_mask"></div></div></td></tr></tbody></table>';
            $(document).ready(function() { 
                  if(<%=Model.PageIndex%> <= 1) {
                     var $ct = $('#topicmbList li:first');
                     if($ct && $ct.length > 0)
                        setCookie('LeadStudioNewst' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                     else
                        setCookie('LeadStudioNewst' + <%=screenID %>,0);
                  }
            
                  setInterval(function(){
                    var ctid = getCookie('LeadStudioNewst' + <%=screenID %>);
                    if(ctid > 0 || <%=Model.PageIndex %> <= 1)
                    {         
                        $.get('<%=SPBUrlHelper.Action("NewThreadsMessage", "MicroBlog") %>',{inDomain : false,cthreadID : ctid,keyword:'<%=WebUtils.UrlEncode(keyword) %>'},function(data){
                            if(data.count && data.count > 0)
                            {
                               $('#new_t_message').show();
                               $('#msg_load').hide(); 
                               $('#new_t_message a').show().html('有'+ data.count +'条新微博，点击浏览');
                            }
                        });
                        
                        $('#new_t_message').unbind('click').click(function(){
                         var count = $('#new_t_message a').text().replace(/[^0-9]/ig, "");
                         if(count > 20)
                         {
                             refresh();
                         }
                         else
                         {
                             $('#new_t_message a').hide();
                             $('#msg_load').show();  
                             $.get('<%=SPBUrlHelper.Action("GetTopicItem", "MicroBlog") %>',{cthreadID : ctid,keyword:'<%=WebUtils.UrlEncode(keyword) %>'},function(data){
                                if(data)
                                {
                                    $('#topicmbList').prepend(data);
                                    var $ct = $('#topicmbList li:first');
                                    if($ct && $ct.length > 0)
                                       setCookie('LeadStudioNewst' + <%=screenID %>,$ct.attr("id").replace(/[^0-9]/ig, ""));
                                }
                                $('#new_t_message').hide();
                             });
                         }
                         return false;
                        });
                     }          
                  },30000);
                  var itemID = getCookie('playedItem' + <%=screenID %>);
                  $.post('<%=SPBUrlHelper.Action("GetPlayedItem", "MicroBlog") %>',{itemID:itemID,screenID:<%=screenID %>}); 
            });
            function AddPlay(id) {
                $.get('<%=SPBUrlHelper.Action("AddItem", "MicroBlog", new RouteValueDictionary { { "screenID", screenID } })%>', { threadID: id }, function(data) {
                    if (data.ok)
                    {
                        if (!$("#m_Item_" + id).hasClass("tn-bg-light"))
                             $("#m_Item_" + id).addClass("tn-bg-light");
                        $.dialog.tips(msgcontent,0.8);
                    }
                });
            }

            function InsertPlays(id) {
                $.get('<%=SPBUrlHelper.Action("AddItem", "MicroBlog", new RouteValueDictionary { { "screenID", screenID }})%>', { threadID: id, isInsert: true }, function(data) {
                    if (data.ok) {
                        if (!$("#m_Item_" + id).hasClass("tn-bg-light"))
                             $("#m_Item_" + id).addClass("tn-bg-light");
                        $.dialog.tips(msgcontent,0.8);
                    }
                });
            }

            function FavoriteM(serialNumber, id) {

                $.get('<%=SPBUrlHelper.Action("CreateFavoriteOfScreen", "MicroBlog", new RouteValueDictionary { { "screenID", screenID } })%>', { serialNumber: serialNumber, threadID: id }, function(data) {
                    if (data.ok)
                        $.dialog.tips(msgcontent,1);
                });
            }
            
            function Pause() {
                $.get('<%=SPBUrlHelper.Action("Pause","MicroBlog") %>', { screenID: '<%=screenID %>' }, function(data) {
                
                    if (data.pause) {
                        $('#pausebtn a').text("取消暂停");
                    }
                    else {
                        $('#pausebtn a').text("暂停");
                    }
                });
            }
        </script>

        <%}%>
    </ul>
    </form>
    <!-- #BeginLibraryItem "/Library/Paging.lbi" -->
    <div class="tn-pagination tn-helper-align-center">
        <%if (Model != null)
          {
              SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex);
          } %>
    </div>
    <!-- #EndLibraryItem -->
</div>
