﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl< ICollection<UserTag>>" %>
<div id="userTagsList">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-my-tags">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <%int applicationID = ApplicationIDs.Instance().MicroBlog();
              string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
              User domainUser = Users.GetUser(userDomainName, false);%>
            <h3 class="tn-helper-reset">
                <%=GetResourceString("Title_ListUserTags", applicationID)%></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <p class="tn-tags-cloud">
                <%
                    Random random = new Random();
                    if (Model != null && Model.Count > 0)
                    {
                        foreach (UserTag userTag in Model)
                        {
                            if (userTag == null) continue;
                %>
                <% %>
                <span class="tn-font-size-<%=userTag.UserCount%>">
                    <a href="<%=SPBUrlHelper.Action("SearchUsers", "MicroBlog", new RouteValueDictionary { { "type", (int)MicroBlogSearchType.UserTag },{ "Keyword", WebUtils.UrlEncode(userTag.TagName)}}) %>">
                        <%=userTag.TagName%></a></span>
                <%}
                    }
                    else
                    { %>
                <p class="tn-text-note">
                    添加你自己感兴趣的标签，找到与你有共同爱好的人。</p>
                <%} %>
            </p>
            <%if (CurrentUser.UserID == domainUser.UserID || CurrentUser.IsAdministrator)
              {%>
            <p class="tn-actions">
                <span class="tn-action">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_CreateUserSiteTagInModal", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }}) %>"
                        id="newTagModalInBlock">添加</a>
                </span>
                <span class="tn-action">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("UserTags", "MicroBlog",new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                        管理</a>
                </span>
            </p>
            <%} %>
        </div>
    </div>
    <div class="tn-blank10">
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {

        $('#newTagModalInBlock').dialog({
            id: 'vedioModel',
            follow: document.getElementById('newTagModalInBlock'),
            title: '添加标签',
            drag: false,
            width: 220,
            closeFn: function() {
                $('#userTagsList').load('<%=SPBUrlHelper.Action("Control_ListUserSiteTags","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>');
            }
        });
    })
</script>

