﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<PersonUser>>" %>
<%int applicationID = ApplicationIDs.Instance().MicroBlog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  User currentDomainUser = Users.GetUser(userDomainName, false);
  if (currentDomainUser == null)
      currentDomainUser = new User();
  if (CurrentUser != null && currentDomainUser.UserID == CurrentUser.UserID && Model != null && Model.Count > 0)
  {
      int displayCount = ViewData.GetInt("displayCount", 0);
      int userCount = ViewData.GetInt("userCount", 0);
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-may-know" id="MayknowUsers">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            可能认识的人</h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <% int i = 0;
               foreach (PersonUser user in Model)
               {
                   if (user == null)
                       continue;
                   bool isFollow = MicroBlogFollows.IsFollow(CurrentUser.UserID, user.UserID);%>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a><a name="followers" href="javascript:;"
                        class="tn-text-note" value="<%if (isFollow) Response.Write("0"); else Response.Write("1"); %>"
                        id="<%=user.UserID %>">
                        <%if (!isFollow)
                              Response.Write(GetResourceString("Action_FollowHe", applicationID));
                          else
                              Response.Write(GetResourceString("Action_CancelFollow", applicationID));
                        %>
                    </a>
            </li>
            <%i++;
               } %>
        </ul>
        <%if (userCount >= displayCount)
          { %>
        <p class="tn-more">
            <a href="javascript:;" id="ChangeMKUsers">换一换</a></p>
        <%} %>

        <script type="text/javascript">
            $(document).ready(function() {
                $("a[name=followers]").click(function() {
                    var $follow = $(this);
                    if ($(this).attr("value") > 0) {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_CancelFollow",applicationID)%>').attr("value", 0);
                        });
                    }
                    else {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_FollowHe",applicationID)%>').attr("value", 1);
                        });
                    }
                });
                $("#ChangeMKUsers").click(function() {
                    $("#MayknowUsers").parent().load('<%=SPBUrlHelper.Action("Control_MayknowUsers", "MicroBlog", new RouteValueDictionary { { "userDomainName",userDomainName },{"displayCount",displayCount} })%>');
                });
            });
        </script>

    </div>
</div>
<div class="tn-blank10">
</div>
<%} %>
