﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<MicroBlogUserData>" %>
<div class="tn-card tn-card-complete">
    <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-left">
        <div class="tn-bubble-box-arrow">
            <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b6 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b7 tn-widget-content tn-bg-light"></b>
        </div>
        <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
            <%
                if (Model != null)
                {
                    string controlID = ViewData.GetString("controlID", string.Empty);
                    PersonUser user = ViewData.Get<PersonUser>("PersonUser", new PersonUser());
                    string userName = CurrentUser != null ? CurrentUser.UserName : string.Empty;%>
            <div class="tn-showcase tn-helper-clearfix">
                <div class="tn-helper-left">
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(Model.UserID) %>" target="_blank">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID,false,HyperLinkTarget._blank, AvatarSizeTypes.Small)%>
                    </a>
                </div>
                <div class="tn-info">
                    <div class="tn-id-name">
                        <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(Model.UserID) %>"
                            target="_blank" title="<%=SPBHtmlHelper.Instance().UserDisplayName(Model.UserID)%>">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(Model.UserID,true)%></a></div>
                    <div class="tn-details">
                        &nbsp;
                        <%if (user.Gender != Genders.All)
                          {
                              if (user.Gender == Genders.Male)
                              {%>
                        <span class="tn-icon tn-icon-male tn-icon-inline"></span>
                        <%}
                              else if (user.Gender == Genders.Female)
                              { %>
                        <span class="tn-icon tn-icon-female tn-icon-inline"></span>
                        <%}
                          } %>
                        <span class="tn-location">
                            <%=Formatter.FormatArea(user.NowAreaCode,true) %></span></div>
                </div>
            </div>
            <div class="tn-marked">
                <div class="tn-info-part">
                    <dl>
                        <dt>关注</dt>
                        <dd>
                            <a href="<%=SiteUrls.Instance().ListFollowUser(user.UserName,(int)MicroBlogFollowSortBy.FollowUser) %>">
                                <%=Model.FollowCount %></a></dd>
                    </dl>
                    <dl>
                        <dt>粉丝</dt>
                        <dd>
                            <a href="<%=SiteUrls.Instance().ListFollowUser(user.UserName, (int)MicroBlogFollowSortBy.Follower)%>">
                                <%=Model.FollowerCount %></a></dd>
                    </dl>
                    <dl>
                        <dt>微博</dt>
                        <dd>
                            <a href="<%=SiteUrls.Instance().UserMicroBlogHome(user.UserID)%>">
                                <%=Model.ThreadCount %></a></dd>
                    </dl>
                </div>
            </div>
            <div class="tn-introduction">
            </div>
            <%if (CurrentUser != null && CurrentUser.UserID != Model.UserID)
              { %>
            <div class="tn-actions tn-bg-gray tn-border-gray tn-border-top">
                <span class="tn-action">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("NewMessage", "MicroBlog", new RouteValueDictionary { { "userDomainName", userName }, { "toUserID",user.UserID } })%>">
                        发私信</a></span><span class="tn-action">
                            <%if (CurrentUser != null && MicroBlogFollows.IsFollow(CurrentUser.UserID, Model.UserID))
                              {  %>
                            <a class="tn-action-text" href="javascript:;" id="addFavorite_<%=controlID %>_af<%=Model.UserID %>"
                                value="0">取消关注</a>
                            <%}
                              else
                              {%>
                            <a class="tn-action-text" href="javascript:;" id="addFavorite_<%=controlID %>_af<%=Model.UserID %>"
                                value="1">关注</a>
                            <%} %>
                        </span>
            </div>
            <%} %>

            <script type="text/javascript">
                $(document).ready(function() {
                    $('#addFavorite_<%=controlID %>_af<%=Model.UserID %>').click(function() {
                        $af=$(this);
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: <%=Model.UserID %>}, function(data) {
                            if ($af.attr("value") > 0) {
                                $("a[id$='af<%=Model.UserID %>']").text("取消关注").attr("value",0);
                                
                            }
                            else {
                                $("a[id$='af<%=Model.UserID %>']").text("关注").attr("value",1);
                            }
                        });
                    });
                });
            </script>

            <%}%>
        </div>
    </div>
</div>
<div class="tn-card tn-card-complete">
</div>
