﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<MicroBlogUserData>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  User domainUser = Users.GetUser(userDomainName, false);
  if (domainUser == null)
      domainUser = new User();
  int applicationID = ApplicationIDs.Instance().MicroBlog();
  int subMenu = ViewData.GetInt("MicroBlogDomainSubMenu", -1);%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-panel" id="MicroBlogInfo">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <%if (subMenu != (int)MicroBlogDomainSubMenu.MyMicroBlogs)
          { %>
        <div class="tn-card tn-card-mini">
            <div class="tn-helper-left">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().MyMicroBlogs(userDomainName)%>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(domainUser.UserID,false,HyperLinkTarget._blank,AvatarSizeTypes.Small)%></a></div>
            </div>
            <div class="tn-info">
                <div class="tn-id-name">
                    <strong><a href="<%=SiteUrls.Instance().MyMicroBlogs(userDomainName)%>" class="tn-user-name">
                        <%=SPBHtmlHelper.Instance().UserDisplayName(domainUser.UserID,true)%></a></strong></div>
            </div>
        </div>
        <%} %>
      
 <%if (subMenu == (int)MicroBlogDomainSubMenu.MyMicroBlogs)
   { %>

     <% UserIdentity userIdentity = Identities.GetUserIdentity(domainUser.UserID,true );
           SiteSettings setting = SiteSettingsManager.GetSiteSettings();
           if (userIdentity != null && setting.EnableUserIdentity==true)
           {                                        %>
        <div class="spb-vip-info ">
            <b>
                <img class="spb-icon-v-big" src="<%=SiteUrls.Instance().IdentityIcon(userIdentity.Identity, IdentityIconTypes.Big) %>"
                    alt="认证用户" height="26" width="90" />
            </b>
            <p class="tn-description">
                <%=userIdentity.IdentityDescription %></p>
        </div>
        <%} %>
<%} %>
        <ul class="spb-microblogs-count tn-helper-clearfix">
            <li class="tn-border-light tn-border-right"><a href="<%=SiteUrls.Instance().ListFollowUser(userDomainName,(int)MicroBlogFollowSortBy.FollowUser) %>">
                <strong class="tn-count">
                    <%=Model.FollowCount %></strong><br />
            </a><a href="<%=SiteUrls.Instance().ListFollowUser(userDomainName,(int)MicroBlogFollowSortBy.FollowUser) %>">
                <span>
                    <%=GetResourceString("Action_Follow", applicationID)%></span></a></li>
            <li class="tn-border-light tn-border-right"><a href="<%=SiteUrls.Instance().ListFollowUser(userDomainName, (int)MicroBlogFollowSortBy.Follower)%>">
                <strong class="tn-count">
                    <%=Model.FollowerCount %></strong><br />
            </a><a href="<%=SiteUrls.Instance().ListFollowUser(userDomainName, (int)MicroBlogFollowSortBy.Follower)%>">
                <span>
                    <%=GetResourceString("Action_Follower", applicationID)%></span></a></li>
            <li><a href="<%=SiteUrls.Instance().MyMicroBlogs(userDomainName)%>"><strong class="tn-count">
                <%=Model.ThreadCount %></strong><br />
            </a><a href="<%=SiteUrls.Instance().MyMicroBlogs(userDomainName)%>"><span>
                <%=GetResourceString("Action_MicroBlog", applicationID)%></span></a></li>
        </ul>
        <%if (CurrentUser != null && CurrentUser.UserID == domainUser.UserID && subMenu > -1)
          { %>
        <ul class="tn-side-menu">
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.MyMicroBlogHome) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-home"></span><a href="<%=SiteUrls.Instance().UserMicroBlogHome(userDomainName) %>"
                    class="tn-menu-text">
                    <%=GetResourceString("Navigation_MyMicroBlogHome", applicationID)%></a></li>
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.MyMicroBlogs) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-microblog"></span><a href="<%=SiteUrls.Instance().MyMicroBlogs(userDomainName)%>"
                    class="tn-menu-text">
                    <%=GetResourceString("Navigation_MyMicroBlog", applicationID)%></a></li>
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.Atme) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-at"></span><a href="<%=SiteUrls.Instance().AtMe(userDomainName) %>"
                    class="tn-menu-text">提到我的</a></li>
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.MyComment) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-bubble"></span><a href="<%=SPBUrlHelper.Action("MyMicroBlogComments", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>"
                    class="tn-menu-text">我的评论</a></li>
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.MyFavorite) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-favorite"></span><a href="<%=SPBUrlHelper.Action("MyFavoriteMicroBlogs", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>"
                    class="tn-menu-text">我的收藏</a></li>
            <li class="<%if (subMenu == (int)MicroBlogDomainSubMenu.MyScreen) Response.Write("tn-selected tn-bg-light tn-border-light tn-corner-all"); %>">
                <span class="tn-icon tn-icon-screen"></span><a href="<%=SPBUrlHelper.Action("MyScreens", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName}})%>"
                    class="tn-menu-text">我的大屏幕</a></li>
        </ul>
        <%} %>
    </div>
</div>
