﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<MicroBlogThread>" %>
<spb:Script runat="server" ID="miniblogAutocomplete" Src="~/Utility/jquery/miniblog.autocomplete.js"
    SetExpireDays="30" />
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
%>
<%if (CurrentUser != null && CurrentUser.UserName.Equals(userDomainName, StringComparison.CurrentCultureIgnoreCase))
  {
      int applicationID = ApplicationIDs.Instance().MicroBlog();
      bool isbind = ViewData.GetBool("isbind", false);
      bool isSimple = ViewData.GetBool("isSimple", false);
      string postMiniBlogUrl = SPBUrlHelper.Action("CreateMicroBlogThread", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } });
      string uploadPhoto = SPBUrlHelper.Action("UploadPhoto", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } });
      bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-microblog-publish"
    id="ShareInput">
    <div class="tn-box-content tn-widget-content tn-corner-all tn-bg-light">
        <div class="spb-microblog-form">
            <form id="microBlogForm" name="microBlogForm" method="post">
            <div class="spb-microblog-textarea">
                <textarea id="microBlogBody" name="microBlogBody" class="tn-textarea tn-border-gray"
                    cols="" rows=""><%=ViewData.GetString("Body",string.Empty)%></textarea>
                <input type="hidden" name="attachmentID" />
                <input type="hidden" name="syncsina" id="syncsinastatus" />
            </div>
            </form>
            <div class="spb-foot tn-helper-clearfix">
                <%if (!isSimple && enableSina)
                  { %>
                <div class="spb-sync-to">
                    <em>同步：</em>
                    <label>
                        <input type="checkbox" id="syncsina" class="tn-checkbox" />
                        <span title="同步到新浪微博" class="tn-icon tn-icon-sync-sina tn-icon-inline">新浪微博</span></label>
                </div>
                <%} %>
                <div class="tn-actions">
                    <span class="tn-action tn-action-text-icon tn-action-has-drop-menu tn-border-trl"
                        id="addSmiley_MicroBlogPost">
                        <span class="tn-icon tn-icon-emotion"></span>
                        <a href="javascript:;" class="tn-action-text">
                            <%=GetResourceString("Title_Expression", applicationID)%></a>
                    </span>
                    <span class="tn-action tn-action-text-icon" id="uploadspan">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Picture) %><a class="tn-action-text" href="javascropt:;"><strong>传图</strong></a>
                        <form id="uploadPhotoForm" method="post" class="spb-insert-photo-form">
                        <input type="file" id="uploadPhoto" name="uploadPhoto" value="0" />
                        </form>
                    </span>
                    <span class="tn-action tn-action-text-icon" id="uploadloading" style="display: none">
                        <span class="tn-icon tn-icon-waiting"></span>
                        <span class="tn-action-text tn-text-note">上传中</span><a href="javascript:;">取消</a></span>
                    <span menu="#spb-insert-photo" id="viewPhoto" class="tn-action tn-action-text-icon tn-action-has-drop-menu tn-border-trl"
                        style="display: none">
                        <span class="tn-icon tn-icon-picture"></span>
                        <a class="tn-action-text tn-text-note" href="javascript:;"></a>
                        <a href="javascript:;">删除</a></span>
                    <div id="spb-insert-photo" class="tn-drop-menu ui-widget-content spb-insert-photo"
                        style="display: none">
                        <img alt="" /></div>
                    <span class="tn-action tn-action-text-icon">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Bubble)%>
                        <a href="javascript:;" id="Topic" class="tn-action-text"><strong>
                            <%=GetResourceString("Action_NewTopic", applicationID)%></strong></a>
                    </span>
                    <%if (!isSimple)
                      { %>
                    <span class="tn-action tn-action-text-icon">
                        <span class="tn-icon tn-icon-movie"></span>
                        <a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_ShareMedia","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"cotentID","microBlogBody"},{"type",(int)MediaTypes.Video}}) %>"
                            id="shareVedio"><strong>视频</strong></a></span>
                    <span class="tn-action tn-action-text-icon">
                        <span class="tn-icon tn-icon-music"></span>
                        <a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_ShareMedia","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"cotentID","microBlogBody"},{"type",(int)MediaTypes.Music}}) %>"
                            id="shareMusic"><strong>音乐</strong></a></span>
                    <%} %>
                </div>
                <%Html.RenderAction<MicroBlogController>(n => n.Control_SmileySelector("MicroBlogPost", "microBlogBody"));%>
                <div class="spb-microblog-send">
                    <span id="Note" class="tn-count">
                        <%=GetResourceString("Message_Toenter", applicationID)%><strong id="Surplus">140</strong><%=GetResourceString("Message_Word", applicationID)%></span>
                    <span class="tn-button-disabled tn-button-large tn-button" id="publish_span">
                        <span class="tn-first-child">
                            <button class="tn-button-text" id="postMicroBlog" type="button">
                                发表</button></span></span>
                </div>
            </div>
        </div>
    </div>
</div>
<%if (!isbind)
  { %>
<div id="bindmsg" style="display: none">
    <div class="spb-bind-tip">
        <p>
            还没有绑定新浪微博，点这里</p>
        <%=SPBHtmlHelper.Instance().Button("", "开始绑定", ButtonSizes.Default, HighlightStyles.Primary, null, TextIconLayout.TextOnly, null, new RouteValueDictionary { { "onclick", "openSina();" }, { "class", "dialogClose" } })%>
    </div>
</div>
<%} %>

<script type="text/javascript">
$(document).ready(function() {
	 //Ready Start
     var countInterval;
	 $("span[menu]").menuButton({ buttonHoverClass:'ui-widget-content tn-action-hover'});
	  
     $("#microBlogForm").validate({
         rules: {
             microBlogBody:  { required: true, maxBlength: 140 }
         },
         messages: {
             microBlogBody: { required: "<%=GetResourceString("Validate_FillInThreadBody", ApplicationIDs.Instance().MicroBlog())%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_BodyMaxLength", ApplicationIDs.Instance().MicroBlog()), 140)%>" }
         },
         showErrors: $.dialog.showErrors,
         onfocusout: false,
         onclick: false,
         onkeyup:false,
         onsubmit:true
     });
          
     var $mbody = $('#microBlogBody');
     $(window).unload( function () { 
       setCookie('mbody' + '<%=CurrentUser.UserID %>',$mbody.val());
     });
     
     var $mbody = $('#microBlogBody');     
     var mbody = getCookie('mbody' + <%=CurrentUser.UserID %>);
     if(mbody && mbody.length > 0 && $mbody.val().length <= 0)
     {
        $mbody.val(mbody);
     }
     
     $("#Topic").click(function(){
         var str =$('#microBlogBody').val();
         var index = str.indexOf('#请输入话题内容#');
         if(index < 0)
         {
             insertAtCaret($("#microBlogBody").get(0),'#请输入话题内容#',true);
             $("#microBlogBody").focus();
         }
         return false;
     });
     
     $("#Surplus").html(140 -blength($("#microBlogBody").val()));
     
     $("#microBlogBody").focus(function() {
        countInterval = setInterval(function(){ count(); },360);
     }).blur(function() {
         clearInterval(countInterval);
         count();
     });
     count();
    function split(val) {
		return val.split(/@\s*/);
	}
	function extractLast(term) {

		return split(term).pop();
	}
    
    function blength(value)
    {
        return parseInt((value.replace(/[^\x00-\xff]/g, "**").length+1)/2);
    }

    $("#microBlogBody").miniblogAutocomplete({
		source: function(request, response) {
			$.ajax({
				url: "<%=SPBUrlHelper.Action("GetMyFollowUsers","MicroBlog") %>",
				dataType: "json",
				data: {
					topNumber: 10,
					term: extractLast(request.term)
				},
				success: function(data) {
					response($.map(data, function(item) {
						return {
							label: item.displayName +"("+ item.userName+")",
							value: item.userName
						}
					}))
				}
			})
		},
		minLength: 1,
		focus: function() {
			// prevent value inserted on focus
			return false;
		},
        search: function() {
			// custom minLength
			var term = extractLast(this.value);
			if (!term || term.length < 1) {
				return false;
			}
		},
		select: function(event, ui) {
		    var terms = split( this.value );
			// remove the current input
			terms.pop();				
			// add the selected item
			terms.push(ui.item.value);
			// add placeholder to get the comma-and-space at the end
			terms.push();
			if(this.value && this.value.indexOf("@")==0 && $.browser.msie) {
			    this.value="@"+terms.join("@")+" ";
            }
			else				
			    this.value = terms.join("@")+" ";				
			    
			return false;
		}
	});
	
	$('#uploadloading a').click(function(){
       $("#uploadspan").show();
       $("#uploadloading").hide();
   });	
   
	$('#uploadPhoto').change(function(){
        $('#uploadPhotoForm').ajaxSubmit({url:'<%=uploadPhoto %>',dataType:'json', success:function(data){
            if(data == undefined) {
              $("#uploadspan").show();
              $("#uploadloading").hide();
              alert("上传失败，请联系管理员！");
              return false;
            }
            
            if(data.ok && $("#viewPhoto").is(":hidden")) {
                $('#uploadspan').hide();
                $("#uploadloading").hide();
                $("#viewPhoto").show();
                $("input[name=attachmentID]").val(data.attachmentID);
            }
            else if(data.message) {
                $("#uploadspan").show();
                $("#uploadloading").hide();
                alert(data.message);
                return false;
            }
            
            $('#spb-insert-photo img').attr("src",data.url);
            $('#viewPhoto .tn-action-text').html(data.PhotoName);
            
            $('#viewPhoto a:eq(1)').click(function(){
                $.post('<%=SPBUrlHelper.Action("DeletePhoto","MicroBlog")%>',{attachmentID:data.attachmentID},function(args){
                if(args.ok) {
                    $("#viewPhoto").hide();
                    $("#uploadspan").show();
                    $('#spb-insert-photo').hide();
                }},'json');
            });
            $("#uploadPhoto").val(' ');            
	    },beforeSubmit:function(){
	        $("#uploadspan").hide();
	        $("#uploadloading").show();
	    }});
	});
	
	$('#postMicroBlog').click(function(){
	     if (!$("#microBlogForm").valid()) {
             return false;
        }
		 $(this).attr("disabled","disabled");
		 
		 var status = 'succeed';
		 var statusmsg = '发布成功';
        $.ajax({
            url: '<%=postMiniBlogUrl %>',
            data: $('#microBlogForm').serialize(),
            type: "post",
            cache : false,
            success: function(data)
            {
                $('#postMicroBlog').removeAttr("disabled");  
                if(data)
                {
                    if(data.error)
                    {
                    
                      var content = '<table><tbody><tr><td class="aui_td_icon"><div class="aui_icon art_error"></div></td><td style="width:auto;height:auto" class="aui_td_content"><div class="aui_content_wrap"><div><h3>'
                      + data.msg + '</h3></div><div class="aui_content_mask"></div></div></td></tr></tbody></table>';
                       $.dialog.tips(content,2);
                       return false;
                    }
                    $('#publish_span').removeClass("tn-button-primary").removeClass('tn-button-primary-hover').addClass("tn-button-disabled");
                    var $lm = $('#ListMicroBlogs');
                    $lm.prepend($(data).hide());
                    if($lm.hasClass("my_mb"))
                    {
                        var $nt = $('#ListMicroBlogs li:first');
                        var tid = $nt.attr("id").replace(/[^0-9]/ig, "");
                        setCookie('TimeLineNewst<%=CurrentUser.UserID %>',tid);
                        $nt.fadeIn("slow");
                    }
                    $.dialog.tips('<table><tbody><tr><td class="aui_td_icon"><div class="aui_icon art_succeed"></div></td><td style="width:auto;height:auto" class="aui_td_content"><div class="aui_content_wrap"><div><h3>发布成功</h3></div><div class="aui_content_mask"></div></div></td></tr></tbody></table>',1);
                    $("#viewPhoto").hide();
                    $("#uploadspan").show();
                    $('#spb-insert-photo').hide();
                    $('#microBlogBody').val('');
                    $('#microBlogBody').focus();
                    setCookie('mbody<%=CurrentUser.UserID %>','');
                    if($('#favkeyword') && $('#favkeyword').length > 0)
                        $('#microBlogBody').val('#'+ $('#favkeyword').val() + '#');
                    $("#uploadPhoto").val(' ');
                }}
          });
	});
   <%if(!isSimple){ %>
	$('#shareVedio').click(function(){
	    var $modal = $.dialog.get('musicModel');
	    if($modal)
         $modal.close();
    }).dialog({
        id: 'vedioModel',
        follow:document.getElementById('shareVedio'),
        title: '视频',
        drag: false,
        width: 350
    });
    
   $('#shareMusic').click(function(){
   	    var $modal = $.dialog.get('vedioModel');
	    if($modal)
         $modal.close();
    }).dialog({
        id: 'musicModel',
        title: '音乐',
        follow:document.getElementById('shareMusic'),
        drag: false,
        width: 350
    });
    
     $('#syncsina').removeAttr("checked");
     <%if(isbind) {%>
          var bindstatus = getCookie('bindsina' + <%=CurrentUser.UserID %>);
          $('#syncsinastatus').val('');
          if(bindstatus && bindstatus == 'checked')
          {
              $('#syncsina').attr("checked","checked");
              $('#syncsinastatus').val('true');
          }
     <%} %>
     $('#syncsina').live("click",function(){
       if ($(this).is(":checked"))
       {
           setCookie('bindsina<%=CurrentUser.UserID %>','checked');
           $('#syncsinastatus').val('true');
       }
       else
       {
           setCookie('bindsina<%=CurrentUser.UserID %>','');
           $('#syncsinastatus').val('');
       }    
       <%if(!isbind) {%>
           if($(this).is(":checked"))
           {
              $.dialog({ id:'binddialog1',content:$("#bindmsg").html(),title:'绑定账户',width:300,closeFn:function(){
                  $('#syncsina').removeAttr("checked");
                  $('#syncsinastatus').val('');
              }});
           }
       <%} %>
     });
    <%} %>
    
    $('#microBlogBody').keydown(function(event){
        if(event.ctrlKey && event.keyCode == 13) { 
            $('#postMicroBlog').click();
        } 
    });
	
    function count()
    {
        var length = 140 - blength($("#microBlogBody").val());
        var $ps = $('#publish_span');
        if(length < 0) {
          length = -length;
          $("#Note").html('<%=GetResourceString("Message_Beyond",applicationID)%><b id="Surplus">' + length + '</b><%=GetResourceString("Message_Word", applicationID)%>');
          $ps.addClass('tn-button-disabled').removeClass('tn-button-primary');
        }
        else
        {
          $("#Note").html('<%=GetResourceString("Message_Toenter",applicationID)%><strong id="Surplus">' + length + '</strong><%=GetResourceString("Message_Word", applicationID)%>');
          if(length == 140)
             $ps.addClass('tn-button-disabled').removeClass('tn-button-primary');
          else
             $ps.addClass('tn-button-primary').removeClass('tn-button-disabled');   
        }
    } 
	//Ready End
 });


function insertAtCaret(textObj,textFeildValue,isSelect)
{
   var rangeStart = 0;
   var rangeEnd = 0;
  textObj.focus(); 
  if (document.selection) {
    var sel = document.selection.createRange();
    sel.text = textFeildValue;
  }
  else if(document.all && textObj.createTextRange && textObj.caretPos) {     
       var caretPos = textObj.caretPos;    
       caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == ''?textFeildValue + '':textFeildValue;
   }
   else if(textObj.setSelectionRange) {      
       rangeStart = textObj.selectionStart;
       rangeEnd = textObj.selectionEnd;   
       var tempStr1 = textObj.value.substring(0,rangeStart);    
       var tempStr2 = textObj.value.substring(rangeEnd);    
       textObj.value = tempStr1 + textFeildValue + tempStr2;
       textObj.focus();
       var len = textFeildValue.length;
       textObj.setSelectionRange(rangeStart + len,rangeStart + len);
       textObj.blur();
   }
   else {        
     textObj.value += textFeildValue;
     rangeStart = textObj.value.length - textFeildValue.length;
   }  
   if(isSelect) {
       var clone;  
       if ($.browser.msie) {  
           var range = document.selection.createRange();  
           var pos = new Object();
           clone = range.duplicate();  
           clone.moveToElementText(textObj);  
           clone.setEndPoint('EndToEnd',range);  
           pos.start = clone.text.length - textFeildValue.length;  
           clone.moveStart("character",pos.start + 1);  
           clone.moveEnd( "character", - 1);  
           clone.select();  
       }
       else if(window.getSelection()) {  
           textObj.selectionStart = rangeStart + 1;  
           textObj.selectionEnd = rangeStart + textFeildValue.length - 1;  
       }    
   }
}
function openSina() {
    var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
}

</script>

<%} %>
