﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogThread>>" %>
<%if (Model != null)
  {
      bool isTopic = ViewData.GetBool("isTopic", true);
      bool hasManagePermission = (CurrentUser != null) && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator) && !isTopic;
      int applicationID = ApplicationIDs.Instance().MicroBlog();
      foreach (MicroBlogThread thread in Model)
      {%>
<li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom tn-bg-light"
    id="microBlogThreadItem_<%=thread.ThreadID %>">
    <div class="tn-list-item-area-left">
        <div class="tn-avatar">
            <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID,false,HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
    </div>
    <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-summary">
            <p>
                <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>" title="<%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID) %>"
                    class="tn-user-name">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>：</a>
                <%=thread.LinkBody %></p>
            <%if (thread.HasPhoto || thread.HasVideo || thread.HasMusic)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                <%if (thread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                <%if (thread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, thread.ThumbnailUrl, thread.PlayUrl, false)); %>
                <%if (thread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, thread.PlayUrl, false)); %>
            </div>
            <%} %>
        </div>
        <%MicroBlogThread originalThread = thread.GetOriginalThread;
          if (thread.OriginalThreadID > 0 && originalThread != null)
          { %>
        <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
            <p>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                    <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
            <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                <%if (originalThread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                <%if (originalThread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, originalThread.ThumbnailUrl, originalThread.PlayUrl, false)); %>
                <%if (originalThread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, originalThread.PlayUrl, false)); %>
            </div>
            <%} %>
            <div class="tn-list-item-row">
                <em class="tn-date">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                        <%=Formatter.FormatFriendlyDate(originalThread.DateCreated,true) %></a></em><span
                            class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                                href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalForward",applicationID)%><%if (isTopic && originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                            </span>
                <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                    href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalComment",applicationID)%><%if (isTopic && originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                </span>
            </div>
        </div>
        <%} %>
        <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
            <em class="tn-date tn-text-note tn-helper-left">
                <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">
                    <%=Formatter.FormatFriendlyDate(thread.DateCreated,true) %></a></em>
            <%if (hasManagePermission || (CurrentUser != null && thread.UserID == CurrentUser.UserID))
              { %>
            <span class="tn-action">
                <a href="javascript:;" onclick="deleteMicroBlogThread('<%=thread.ThreadID %>', '<%=SPBUrlHelper.Action("DeleteMicroBlogThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>')"
                    class="tn-action-text">
                    <%=GetResourceString("Action_Delete") %></a>
            </span>
            <span class="tn-pipe tn-text-note">|</span>
            <%} %>
            <span class="tn-action">
                <%if (CurrentUser != null)
                  { %>
                <a href="javascript:;" class="tn-action-text" onclick="forward('<%=SPBUrlHelper.Action("Control_ForwardMicroBlog","MicroBlog",new RouteValueDictionary {{"threadID",thread.ThreadID}}) %>');return false;">
                    <%=GetResourceString("Action_Forward", ApplicationIDs.Instance().MicroBlog())%>
                    <%if (isTopic && thread.ForwardedCount > 0) Response.Write("(" + thread.ForwardedCount + ")"); %></a>
                <%}
                  else
                  { %>
                <a href="javascript:;" class="tn-action-text">
                    <%=GetResourceString("Action_Forward", ApplicationIDs.Instance().MicroBlog())%>
                    (<%=thread.ForwardedCount%>)</a>
                <%} %></span>
            <span class="tn-pipe tn-text-note">|</span>
            <%if (CurrentUser != null && CurrentUser.UserID != thread.UserID)
              { %>
            <span class="tn-action">
                <%if (!MicroBlogThreads.IsFavorite(CurrentUser.UserID, thread.ThreadID))
                  { %>
                <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='0'>收藏</a>
                <%}
                  else
                  { %>
                <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='1'>取消收藏</a>
                <%} %></span>
            <span class="tn-pipe tn-text-note">|</span>
            <%} %>
            <span class="tn-action">
                <a href="javascript:;" name="reply" id="reply_<%=thread.ThreadID %>" value="<%=thread.ThreadID %>"
                    class="tn-action-text">
                    <%=GetResourceString("Action_Comment",applicationID)%><% if (isTopic && thread.ReplyCount > 0) Response.Write("(" + thread.ReplyCount + ")");%></a></span>
        </div>
        <%if (CurrentUser != null)
          { %>
        <div class="tn-simple-comments" id="ListComments_<%=thread.ThreadID %>" style="display: none">
            <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                <div class="tn-bubble-box-arrow">
                    <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                    <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                    <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                    <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                    <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                </div>
                <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=thread.ThreadID %>"
                    value="<%=SPBUrlHelper.Action("Control_ListCommentsOfThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>">
                    <div class="tn-loading">
                    </div>
                </div>
            </div>
        </div>
        <%} %>
    </div>
</li>
<%}
  }%>