﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
  int? othreadID = Html.GetParameterFromRouteDateOrQueryString<int>("othreadID");
  MicroBlogPhotoTypes type = Html.GetParameterFromRouteDateOrQueryString<MicroBlogPhotoTypes>("type");
  Attachment attachment = null;

  if (othreadID.HasValue && othreadID.Value > 0)
      attachment = MicroBlogAttachmentManager.Instance().GetLatestAttachmentOfAssociateID(othreadID.Value);
  else
      attachment = MicroBlogAttachmentManager.Instance().GetLatestAttachmentOfAssociateID(threadID);

  if (attachment != null)
  {
      if (type != MicroBlogPhotoTypes.View)
      { %>
<div class="spb-photo-view tn-bg-gray tn-border-gray" name="previewPhoto" tid="<%=threadID %>"
    otid="<%=othreadID %>">
    <img src="<%=SiteUrls.Instance().MicroBlogPhotoUrl(attachment, MicroBlogPhotoTypes.Preview)%>"
        alt="" class="spb-photo-small" style="cursor: url(&quot;<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/big.cur")%>&quot;
        ), -moz-zoom-in;" /></div>
<%}
      else
      { %>
<div class="spb-photo-view tn-bg-gray tn-border-gray">
    <div class="tn-toolbar-area" id="rotate_<%=threadID %>">
        <span class="tn-action tn-action-text-icon tn-helper-right">
            <a class="tn-action-text" href="<%=SiteUrls.Instance().MicroBlogPhotoUrl(attachment, MicroBlogPhotoTypes.Original)%>"
                target="_blank">
                <span class="tn-icon tn-icon-enlarge"></span>
                大图</a></span>
        <span class="tn-action tn-action-text-icon">
            <a class="tn-action-text" href="javascript:;">
                <span class="tn-icon tn-icon-rotate-left"></span>
                向左</a></span><span class="tn-action tn-action-text-icon"><a class="tn-action-text"
                    href="javascript:;"><span class="tn-icon tn-icon-rotate-right"> </span>
                    向右</a></span></div>
    <div name="viewPhoto" tid="<%=threadID %>">
        <img alt="" id="img_<%=threadID %>" src="<%=SiteUrls.Instance().MicroBlogPhotoUrl(attachment, MicroBlogPhotoTypes.View)%>"
            class="spb-photo-big" style="cursor: url(&quot;<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/small.cur")%>&quot;
            ), -moz-zoom-out;" /></div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('.tn-icon-rotate-left', $('#rotate_<%=threadID %>')).parent().click(function() {
            $("#img_<%=threadID %>").rotateLeft();
        });
        $('.tn-icon-rotate-right', $('#rotate_<%=threadID %>')).parent().click(function() {
            $("#img_<%=threadID %>").rotateRight();
        });
    });
</script>

<%}
  }%>
