﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%int applicationID = ApplicationIDs.Instance().MicroBlog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

  User domainUser = Users.GetUser(userDomainName, false);

  if (domainUser == null)
      domainUser = new User();

  bool isDomainUser = CurrentUser != null && CurrentUser.UserID == domainUser.UserID;
  bool isManager = CurrentUser != null && CurrentUser.IsAdministrator && CurrentUser.IsContentAdministrator;
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-detail" id="MicroBlogUserCard">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-card">
            <div class="tn-showcase tn-helper-clearfix">
                <div class="tn-helper-left">
                    <a href="<%=SiteUrls.Instance().UserMicroBlogHome(userDomainName) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(domainUser.UserID,AvatarSizeTypes.Card) %></a></div>
                <div class="tn-info">
                    <div class="tn-id-name">
                        <strong>
                            <%=SPBHtmlHelper.Instance().UserDisplayName(domainUser.UserID,true) %>
                        </strong>
                    </div>
                    <div class="tn-info-part">
                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(userDomainName) %>">
                            <%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserMicroBlogHome(userDomainName)) %></a></div>
                    <%if (domainUser.UserType == UserTypes.PersonUser)
                      {
                          PersonUser pu = domainUser as PersonUser;%>
                    <div class="tn-info-part">
                        <%if (pu.Gender != Genders.All)
                          { %>
                        <em class="tn-text-note">
                            <% if (pu.Gender == Genders.Male) Response.Write(GetResourceString("Enum_Genders_Male")); else if (pu.Gender == Genders.Female) Response.Write(GetResourceString("Enum_Genders_Female")); %></em>
                        <%}
                          if (pu.Age > 0)
                          {%>
                        <em class="tn-text-note">
                            <%=pu.Age%><%=GetResourceString("Title_Age", applicationID)%></em>
                        <%} if (!string.IsNullOrEmpty(pu.School))
                          {%>
                        <em class="tn-text-note">
                            <%=pu.School%></em>
                        <%} %></div>
                    <div class="tn-info-part">
                        <%if (!string.IsNullOrEmpty(pu.SelfAppraisal))
                          { %>
                        <p>
                            <%=pu.SelfAppraisal%></p>
                        <%}
                          else if (CurrentUser != null && CurrentUser.UserID == domainUser.UserID)
                          {%>
                        <p class="tn-description">
                            想要获得更多人的关注？来完善一下
                            <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog", new RouteValueDictionary { { "userDomainName", domainUser.UserName } })%>">
                                个人信息</a>
                            吧</p>
                        <%} %>
                    </div>
                    <%}%>
                    <div class="tn-actions">
                        <span class="tn-helper-right">
                            <%if (isManager)
                              { %>
                    <span class="tn-action">
                        <a class="nyroModal tn-action-text" href="<%= SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().User(),
                        domainUser.UserID, domainUser.UserID, domainUser.DisplayName)  %>">推荐</a>
                    </span>
                    <span class="tn-pipe tn-text-note">|</span>
                    <%}%>
                    <span class="tn-action">
                        <a class="tn-action-text" target="_blank" href="<%=SPBUrlHelper.Action("ShowProfile", "UserDomain", new RouteValueDictionary { { "userDomainName", domainUser.UserName } })%>">
                            <%=GetResourceString("Widget_UserPref_shortcutName_defaultValue_More") %></a>
                    </span>
                    </span>
                    <%if (CurrentUser != null && CurrentUser.UserID != domainUser.UserID)
                      {
                          if (!MicroBlogFollows.IsFollow(CurrentUser.UserID, domainUser.UserID))
                              Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Follow", applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText, null, new RouteValueDictionary { { "name", "follow" }, { "value", 1 } }));
                          else
                          {%>
                    <span class="tn-action tn-action-text-icon"><em class="tn-action-text">
                        <span class="tn-icon tn-icon-accept"></span>
                        已关注</em> </span>
                    <span class="tn-action">
                        <a class="tn-action-text" href="javascript:;" value="0" name="follow">取消关注</a>
                    </span>
                    <%}
                          } %>
                </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("span[name=follow],a[name=follow]").live('click', function() {
            var $pa = $(this);
            if ($(this).attr("value") > 0) {
                $.get('<%=SPBUrlHelper.Action("FollowUserInDomain", "MicroBlog", new RouteValueDictionary {{ "userDomainName",userDomainName}})%>', { userDomainName: '<%=userDomainName %>' }, function(data) {
                    $pa.after('<span class="tn-action tn-action-text-icon"><em class="tn-action-text"><span class="tn-icon tn-icon-accept"></span>已关注</em></span><span class="tn-action"><a class="tn-action-text" href="javascript:;" value="0" name="follow">取消关注</a></span>').remove();
                    $.dialog.load('<%=SPBUrlHelper.Action("Control_SetUserGroup", "MicroBlog", new RouteValueDictionary { { "itemID", domainUser.UserID} })%>', { id: 'SetUserGroup', title: "设置用户分组", width: 220 }, false);
                });
            }
            else {
                $.get('<%=SPBUrlHelper.Action("FollowUserInDomain", "MicroBlog", new RouteValueDictionary {{ "userDomainName",userDomainName}})%>', { userDomainName: '<%=userDomainName %>' }, function(data) {
                    $pa.parent().after('<span value="1" name="follow" class="tn-button-text-icon tn-button tn-button-primary"><span class="tn-first-child"><span title="" class="tn-icon-add tn-icon"></span><a href="javascript:;" class="tn-button-text">关注</a></span></span>');
                    $pa.parent().siblings('span.tn-action-text-icon').remove().end().remove();
                });
            }
        });
    });
</script>

<div class="tn-blank10">
</div>
