﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageInboxItem>>" %>
<%     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
%>
<div id="ListMessageInBoxDiv">
    <form id="ListMessageInBoxForm" method="post">
    <%foreach (PrivateMessageInboxItem message in Model.Records)
      {%>
    <ul class="tn-list">
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom  <%if(!message.IsRead) Response.Write(" tn-bg-gray tn-unread"); %>">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <a href="#">
                        <% if (message.MessageType == PrivateMessageType.Serve)
                           { %>
                        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                            width="46" height="46" />
                        <%}
                           else if (message.MessageType == PrivateMessageType.System)
                           {%>
                        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/SystemAvatar.gif") %>"
                            width="46" height="46" />
                        <% }
                           else
                           {
                               if (message.SenderUserID > 0)
                               { %>
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.SenderUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                        <%}
                           }%>
                        <span class="tn-round-corner"></span>
                    </a>
                </div>
            </div>
            <% int returnToPageIndex = ViewData.Model.PageIndex;
               if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
               {
                   returnToPageIndex = ViewData.Model.PageIndex - 1;
               } %>
            <a id="del" href="<%=SPBUrlHelper.Action("DeleteInBoxMessage","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",message.ThreadID},{"pageIndex",returnToPageIndex}}) %>"
                class="tn-icon tn-icon-cross tn-helper-right" onclick="if (!confirm('<%= GetResourceString("Message_ConfirmDeleteThisMessage", ApplicationIDs.Instance().User())%>')) {return false;}">
            </a>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-summary">
                    <p>
                        <cite>
                            <a title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), message.Sender)%>"
                                href="<%=SiteUrls.Instance().MyMicroBlogs(message.SenderUserID)%>" class="tn-author">
                                <%=message.Sender %>：</a></cite>
                        <%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 30) %></p>
                </div>
                <div class="tn-list-item-row">
                    <em class="tn-date tn-text-note">
                        <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %></em>
                    <a href="<%=SPBUrlHelper.Action("ShowMessage", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", message.ThreadID },{"returnUrl",Request.RawUrl} })%>"
                        class="tn-author">查看</a>
                </div>
            </div>
        </li>
    </ul>
    <%} %>
    </form>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListMessageInBox", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>

<script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListMessageInBoxDiv').load(url);
        }
        function operate(action) {
            if (action == 'delete') {
                if (confirm('<%=GetResourceString("Message_ConfirmDeleteMessage",ApplicationIDs.Instance().User()) %>')) {
                    $('#ListMessageInBoxForm').ajaxSubmit({ target: '#ListMessageInBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteInBoxMessages","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' });
                }
            }
        }
</script>

