﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageOutboxItem>>" %>
<div id="ListMessageOutBoxDiv">
    <form id="ListMessageOutBoxForm" method="post">
    <%     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");%>
    <%foreach (PrivateMessageOutboxItem message in ViewData.Model.Records)
      { %>
    <ul class="tn-list tn-helper-reset">
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <% if (message.MessageType == PrivateMessageType.Serve)
                       { %>
                    <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                        width="46" height="46" />
                    <%}
                       else
                       {
                           if (message.ReceiverUserID > 0)
                           { %>
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.ReceiverUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small, new RouteValueDictionary { { "title", string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), message.Receiver) } })%>
                    <%}
                       }%>
                    <span class="tn-round-corner"></span>
                </div>
            </div>
            <% int returnToPageIndex = ViewData.Model.PageIndex;
               if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
               {
                   returnToPageIndex = ViewData.Model.PageIndex - 1;
               } %>
            <a id="del" href="<%=SPBUrlHelper.Action("DeleteOutBoxMessage","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",message.ThreadID},{"pageIndex",returnToPageIndex}}) %>"
                class="tn-icon tn-icon-cross tn-helper-right" onclick="if (!confirm('<%= GetResourceString("Message_ConfirmDeleteThisMessage", ApplicationIDs.Instance().User())%>')) {return false;}">
            </a>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-summary">
                    <cite>
                        <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(message.ReceiverUserID) %>"
                            title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), message.Receiver)%>">
                            <%=message.Receiver%></a>
                        <a class="tn-subject" href="<%=SPBUrlHelper.Action("ShowMessage", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", message.ThreadID },{"returnUrl",Request.RawUrl} })%>"
                            title="<%=message.MostRecentPostSubject %>">
                            <%=StringUtils.Trim(message.MostRecentPostSubject, 30) %></a>
                    </cite>
                    <p class="tn-helper-reset">
                        <span class="tn-snippet">
                            <%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 30)%></span></p>
                </div>
                <div class="tn-list-item-row">
                    <em class="tn-date tn-text-note">
                        <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %></em>
                    <a href="<%=SPBUrlHelper.Action("ShowMessage", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", message.ThreadID },{"returnUrl",Request.RawUrl} })%>"
                        class="tn-author">查看</a>
                </div>
        </li>
    </ul>
    <%} %>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListMessageOutBox", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
    </form>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListMessageOutBoxDiv').load(url);
        }
        function deleteMessage() {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteMessage",ApplicationIDs.Instance().User()) %>')) { $('#ListMessageOutBoxForm').ajaxSubmit({ target: '#ListMessageOutBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteOutBoxMessages","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' }); }
        }
    </script>

</div>
