﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<User>>" %>
<% if (Model != null && Model.Count > 0)
   {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-recommended-users"
    id="RecommendUserBlock">
    <%int applicationID = ApplicationIDs.Instance().MicroBlog(); %>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right">
            <a href="javascript:;"></a>
        </span>
        <h3 class="tn-helper-reset">
            <%RecommendationType recommendType = ViewData["RecommendationType"] as RecommendationType;
              Response.Write(recommendType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-avatar-list tn-helper-reset">
            <% foreach (User user in Model)
               {
                   bool isFollow = CurrentUser != null && MicroBlogFollows.IsFollow(CurrentUser.UserID, user.UserID);
            %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(user)%></a>
                <%if (CurrentUser != null && CurrentUser.UserID != user.UserID)
                  {
                      if (!isFollow)
                      {%>
                <span class="tn-action tn-action-text-icon">
                    <a name="followUser" class="tn-action-text tn-secondary-text" href="javascript:;"
                        value="1" id="<%=user.UserID%>">
                        <span class="tn-icon tn-icon-add"></span>
                        <%=GetResourceString("Action_FollowHe", applicationID)%></a></span>
                <%}
                      else
                      {%>
                <a name="followUser" href="javascript:;" class="tn-text-note" value="0" id="<%=user.UserID%>">
                    <%=GetResourceString("Action_CancelFollow", applicationID)%>
                </a>
                <%}%>
            </li>
            <%}
               } %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>

<script type="text/javascript">
$(document).ready(function() {
    <%if (CurrentUser == null)
    { %>
          $('ul a', $('#RecommendUserBlock')).attr("href", "<%=SiteUrls.Instance().LoginInModal() %>");
          $('ul a', $('#RecommendUserBlock')).dialog({
              id: 'loginDialog',
              title: '登录',
              width: 400
          });
    <%}else
    { %>

    $("a[name=followUser]").live("click", function() {
        var $follow = $(this);
        if ($(this).attr("value") > 0) {
            $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                $follow.parent().after('<a name="followUser" class="tn-action-text tn-secondary-text" href="javascript:;"value="0" id="'
                + $follow.attr("id") + '"><%=GetResourceString("Action_CancelFollow",applicationID)%></a>').remove();
            });
        }
        else {
            $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                $follow.after('<span class="tn-action tn-action-text-icon"><a name="followUser" class="tn-action-text tn-secondary-text" href="javascript:;" value="1" id="'
                + $follow.attr("id") + '"><span class="tn-icon tn-icon-add"></span><%=GetResourceString("Action_FollowHe", applicationID)%></a></span>').remove();
            });
        }
    });
    <%} %>
});
</script>

<% }%>