﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%if (ViewData["DictThreads"] != null)
  {
      Dictionary<int, MicroBlogThread> dict = ViewData["DictThreads"] as Dictionary<int, MicroBlogThread>;
      foreach (var item in dict)
      {
          if (item.Value != null)
          {%>
<li class="tn-list-item tn-helper-clearfix tn-widget-content" id="m_item_<%=item.Value.ThreadID %>"
    style="display: none">
    <div class="tn-list-item-area-left">
        <div class="tn-avatar-medium">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.Value.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Card)%></div>
    </div>
    <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-summary">
            <p>
                <a class="tn-user-name" href="javascript:;">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(item.Value.UserID, true)%>：</a><%=item.Value.LinkBody%></p>
            <%if (item.Value.HasPhoto)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix">
                <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(item.Value.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
        </div>
        <%MicroBlogThread originalThread = item.Value.GetOriginalThread;
          if (item.Value.OriginalThreadID > 0 && originalThread != null)
          { %>
        <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
            <p>
                <a href="javascript:;" class="tn-user-name">
                    <%=originalThread.Author%></a>
                <%=originalThread.LinkBody%></p>
            <%if (item.Value.HasPhoto)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix">
                <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(originalThread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
            <div class="tn-list-item-row">
                <em class="tn-date">
                    <a href="javascript:;">
                        <%=Formatter.FormatFriendlyDate(originalThread.DateCreated, true)%></a></em>
            </div>
        </div>
        <%} %>
        <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
            <em class="tn-date tn-text-note tn-helper-left">
                <a href="javascript:;">
                    <%=Formatter.FormatFriendlyDate(item.Value.DateCreated, true)%></a></em></div>
    </div>
    <input type="hidden" name="item" value="<%=item.Key %>" />
</li>
<%}
          else
          {%>
<li class="tn-list-item tn-helper-clearfix tn-widget-content item_0" style="display: none">
    <input type="hidden" name="item" value="<%=item.Key %>" />
</li>
<% }
      }
  }
  else if (ViewData["ilthreads"] != null)
  {
      IList<MicroBlogThread> threads = ViewData["ilthreads"] as IList<MicroBlogThread>;
      foreach (var item in threads)
      {%>
<li class="tn-list-item tn-helper-clearfix tn-widget-content" id="m_item_<%=item.ThreadID %>"
    style="display: none">
    <div class="tn-list-item-area-left">
        <div class="tn-avatar-medium">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID,false,HyperLinkTarget._blank, AvatarSizeTypes.Normal)%></div>
    </div>
    <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-summary">
            <p>
                <a class="tn-user-name" href="javascript:;">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(item.UserID,true) %>：</a><%=item.LinkBody %></p>
            <%if (item.HasPhoto)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix">
                <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(item.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
        </div>
        <%MicroBlogThread originalThread = item.GetOriginalThread;
          if (item.OriginalThreadID > 0 && originalThread != null)
          { %>
        <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
            <p>
                <a href="javascript:;" class="tn-user-name">
                    <%=originalThread.Author %></a>
                <%=originalThread.LinkBody %></p>
            <%if (item.HasPhoto)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix">
                <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(originalThread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
            <div class="tn-list-item-row">
                <em class="tn-date">
                    <a href="javascript:;">
                        <%=Formatter.FormatFriendlyDate(originalThread.DateCreated,true) %></a></em>
            </div>
        </div>
        <%} %>
        <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
            <em class="tn-date tn-text-note tn-helper-left">
                <a href="javascript:;">
                    <%=Formatter.FormatFriendlyDate(item.DateCreated,true) %></a></em></div>
    </div>
    <input type="hidden" name="threadItem" value="<%=item.ThreadID %>" />
</li>
<%}
  } %>