﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      if (messageType == StatusMessageType.Success)
      {
          //关闭模式窗口
          Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();',0)</script>"));
      }
      else
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

      TempData["StatusMessageType"] = null;
      TempData["StatusMessageContent"] = null;
  }

  int itemID = Html.GetParameterFromRouteDateOrQueryString<int>("itemID");
  List<UserCategory> selectCategory = ViewData["selectCategories"] as List<UserCategory>;
  if (selectCategory == null)
      selectCategory = new List<UserCategory>();
    
%>
<div class="tn-form tn-label-right spb-set-group">
    <form action="<%=SPBUrlHelper.Action("SetUserToGroups", "MicroBlog", new RouteValueDictionary { { "itemID", itemID } })%>"
    method="post" class="artDialog">
    <div class="tn-form-row tn-multi-line">
        <ul id="groupsBox">
            <%if (Model != null)
              {
                  foreach (var item in Model)
                  { %>
            <li>
                <input type="checkbox" value="<%=item.CategoryID%>" name="gid" id="Group_<%=item.CategoryID%>"
                    class="tn-checkbox" <%if (selectCategory.Select(n => n.CategoryID).Contains(item.CategoryID)) Response.Write("checked=\"checked\""); %> />
                <label for="Group_<%=item.CategoryID%>" title="<%=item.CategoryName %>">
                    <%=StringUtils.Trim(item.CategoryName,10)%>
                </label>
            </li>
            <%}
              }%>
        </ul>
    </div>
    <div class="tn-form-row tn-create">
        <span style="display: none;">
            <input type="text" name="groupName" value="" class="tn-textbox tn-input-medium tn-border-gray" />
            <a id="CreateGorup" href="javascript:;">创建</a>&nbsp;&nbsp;<a id="cananlCreateGroup"
                href="javascript:;">取消</a></span>
    </div>
    <div class="tn-form-row tn-form-row-button tn-bg-gray tn-border-gray tn-border-top">
        <span class="tn-action">
            <a class="tn-action-text" id="newGroup" href="javascript:;">创建分组</a></span>
        <%=SPBHtmlHelper.Instance().SubmitButton("", "确定", ButtonSizes.Default, null, null)%>
        <%=SPBHtmlHelper.Instance().Button("", "取消", ButtonSizes.Default, HighlightStyles.Secondary, null, new RouteValueDictionary { { "class", "dialogClose" } })%>
    </div>
    </form>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#newGroup").click(function() {
            $(this).parent().hide();
            $("#CreateGorup").parent().show();
        });

        $("#cananlCreateGroup").click(function() {
            $(this).parent().hide();
            $("#newGroup").parent().show();
        });
        $("#CreateGorup").click(function() {
            if ($("input[name='groupName']").val() <= 0) {
                return false;
            }
            else if ($("input[name='groupName']").val().length > 20) {
                alert("超出长度限制！");
                return false;
            }
            $(this).parent().hide();
            $("#newGroup").parent().show();

            $.post('<%=SPBUrlHelper.Action("CreateGroup","MicroBlog")%>', { groupName: $("input[name='groupName']").val() }, function(data) {
                if (data.error)
                    alert(data.message);
                else if (data.ok) {
                    if (data.gid > 0) {
                        $('#groupsBox').prepend('<li><input type="checkbox" value="' + data.gid +
                    '" name="gid" id="Group_' + data.gid + '" class="tn-checkbox" checked="checked" /><label for="Group_' +
                    data.gid + '" title="' + data.groupName + '">' + data.groupName + '</label></li>');
                    }
                    else
                        alert("创建失败或分组已经存在！");
                }

            });
        });
    });
</script>

