﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    UserDomainSettingsMenuType menuType = UserDomainSettingsMenuType.Account;
    try
    {
        menuType = (UserDomainSettingsMenuType)ViewData["UserDomainSettingsMenuType"];
    }
    catch
    {
    }
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);
    
    int applicationID = ApplicationIDs.Instance().User();
    bool IsUserDomainOwner = false;
    if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
        IsUserDomainOwner = true;
    UserDomainConfiguration userDomainConfiguration = UserDomainConfiguration.Instance();
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <% if (CurrentUser!=null && (Globals.GetCurrentUser().IsContentAdministrator || IsUserDomainOwner))
               {%>
            <li id="AccountLi" <%if (menuType == UserDomainSettingsMenuType.Account)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="Account" href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        个人资料</span></a></li>
            <% PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().UserDomain(), false);
               if (presentArea != null && presentArea.EnableThemes)
               {%>
            <li id="ThemeSettingLi" <%if (menuType == UserDomainSettingsMenuType.ThemeSetting)Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");%>>
                <a id="editThemeSetting" href="<%=SPBUrlHelper.Action("ModifyHome", "UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <span>
                        <%=GetResourceString("Title_ModifyHome",applicationID)%></span></a>
            </li>
            <%} %>
          
        </ul>
    </div>
</div>
