﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogFollow>>" %>
<%int applicationID = ApplicationIDs.Instance().MicroBlog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  User currentDomainUser = Users.GetUser(userDomainName, false);
  if (currentDomainUser == null)
      currentDomainUser = new User();
  if (CurrentUser != null && currentDomainUser.UserID != CurrentUser.UserID)
  {
      int disPlayCount = ViewData.GetInt("disPlayCount");
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-recommended-users"
    id="TopFollowUserBlock">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=string.Format(GetResourceString("Title_UsersFollowers", applicationID), currentDomainUser.DisplayName)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%if (Model != null && Model.Count > 0)
          { %>
        <ul class="tn-avatar-list tn-helper-reset">
            <% int i = 1;
               foreach (MicroBlogFollow follow in Model)
               {
                   User user = Users.GetUser(follow.UserID, false);
                   if (i > disPlayCount)
                       break;
                   if (user == null || user.UserID == CurrentUser.UserID)
                       continue;
                   bool isFollow = MicroBlogFollows.IsFollow(CurrentUser.UserID, user.UserID);%>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <a href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(user.UserID) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a><a name="followers" href="javascript:;"
                        class="tn-text-note" value="<%if (isFollow) Response.Write("0"); else Response.Write("1"); %>"
                        id="<%=user.UserID %>">
                        <%if (!isFollow)
                              Response.Write(GetResourceString("Action_FollowHe", applicationID));
                          else
                              Response.Write(GetResourceString("Action_CancelFollow", applicationID));
                        %>
                    </a>
            </li>
            <%i++;
               } %>
        </ul>
        <%if (i > 1)
          { %>
        <p class="tn-more">
            <a href="<%=SPBUrlHelper.Action("ListFollow","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName},{"sortBy",MicroBlogFollowSortBy.Follower}}) %>">
                <%=GetResourceString("Action_More")%></a></p>
        <%} %>

        <script type="text/javascript">
            $(document).ready(function() {
                $("a[name=followers]").click(function() {
                    var $follow = $(this);
                    if ($(this).attr("value") > 0) {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_CancelFollow",applicationID)%>').attr("value", 0);
                        });
                    }
                    else {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_FollowHe",applicationID)%>').attr("value", 1);
                        });
                    }
                });
            });
        </script>

        <%}
          else
          { %>
        <p class="tn-text-note">
            还没有任何用户关注过TA。</p>
        <%} %>
    </div>
</div>
<div class="tn-blank10">
</div>
<%} %>